/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.emulator.core.devfrm.IDeviceFrameworkSupport;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.DeviceUtils;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;

public class TmLDeviceFrameworkSupport
implements IDeviceFrameworkSupport {
    @Override
    public Collection<IAndroidEmulatorInstance> getAllInstances() {
        List tmlInstances = InstanceRegistry.getInstance().getInstances();
        HashSet<IAndroidEmulatorInstance> androidCollection = new HashSet<IAndroidEmulatorInstance>();
        for (IInstance tmlInstance : tmlInstances) {
            if (!(tmlInstance instanceof IAndroidEmulatorInstance)) continue;
            androidCollection.add((IAndroidEmulatorInstance)tmlInstance);
        }
        return androidCollection;
    }

    public static IStatus runService(IInstance instance, String serviceID, Map<Object, Object> arguments, IProgressMonitor monitor) throws SequoyahException {
        IStatus runStatus = null;
        IDeviceType deviceType = DeviceUtils.getDeviceType((IInstance)instance);
        for (IService service : deviceType.getServices()) {
            if (!service.getId().equals(serviceID)) continue;
            ServiceHandler serviceHandler = (ServiceHandler)service.getHandler();
            runStatus = serviceHandler.run(instance, arguments, monitor);
            break;
        }
        return runStatus;
    }
}

