/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.instance;

import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.model.IInputLogic;
import org.eclipse.andmore.android.emulator.device.definition.AndroidEmuDefMgr;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOptionsMgt;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AbstractStartAndroidEmulatorLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.emulator.logic.stop.AndroidEmulatorStopper;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AndroidDeviceInstance
extends AbstractMobileInstance
implements IAndroidLogicInstance,
IWorkbenchAdapter,
ISerialNumbered {
    private ProtocolHandle handle;
    private boolean hasCli = false;
    private String currentLayout;
    private Process process;
    private long windowHandle;
    private Composite composite;

    @Override
    public boolean isStarted() {
        boolean instanceStarted = false;
        String status = this.getStatus();
        if ("org.eclipse.andmore.android.emulator.status.online".equals(status)) {
            instanceStarted = true;
        }
        return instanceStarted;
    }

    @Override
    public boolean isConnected() {
        if (super.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).equals("true")) {
            ProtocolHandle protocolHandle = this.getProtocolHandle();
            if (protocolHandle != null) {
                return PluginProtocolActionDelegate.isProtocolRunning((ProtocolHandle)protocolHandle);
            }
            return false;
        }
        return this.isStarted();
    }

    @Override
    public void stop(boolean force) throws InstanceStopException {
        AndmoreLogger.info((String)("Stopping the Android Emulator instance: " + this));
        if (this.isStarted()) {
            if (this.getStateMachineHandler().isTransitioning()) {
                AndmoreLogger.info((String)("The instance is already executing a stop process:  " + this));
                throw new InstanceStopException("The instance is already executing a stop process");
            }
            AndmoreLogger.info((String)("Instance is started. Run the regular transition to stopped status: " + this));
            ServiceHandler stopHandler = EmulatorPlugin.getStopServiceHandler();
            if (stopHandler != null) {
                try {
                    HashMap<String, Boolean> args = new HashMap<String, Boolean>();
                    args.put("force", true);
                    stopHandler.run((IInstance)this, args);
                }
                catch (Exception exception) {
                    AndmoreLogger.error((String)"The instance is not in an appropriate state for stopping");
                }
                AndmoreLogger.info((String)("Finished stop process: " + this));
            }
        } else if (this.getStateMachineHandler().isTransitioning()) {
            AndmoreLogger.info((String)("Instance is not fully started yet. Execute a stop process directly..." + this));
            Job haltJob = new Job(EmulatorNLS.UI_AndroidDeviceInstance_StopInstanceJob){

                protected IStatus run(IProgressMonitor monitor) {
                    AndroidEmulatorStopper.stopInstance(AndroidDeviceInstance.this, true, true, monitor);
                    if (AndroidDeviceInstance.this.getStatus().equals("org.eclipse.andmore.android.emulator.status.offlineNoData")) {
                        AndmoreLogger.info((String)("Instance was initially in stopped/clean status. Rollback if needed." + (Object)((Object)this)));
                        File userdataFile = AndroidDeviceInstance.this.getUserdata();
                        if (userdataFile != null && userdataFile.exists()) {
                            AndmoreLogger.info((String)("Deleted data created during the start tentative." + userdataFile));
                            userdataFile.delete();
                        }
                    }
                    AndmoreLogger.info((String)("Finished stop process: " + AndroidDeviceInstance.this));
                    return Status.OK_STATUS;
                }
            };
            haltJob.schedule();
        }
    }

    @Override
    public Properties getProperties() {
        Properties properties = super.getProperties();
        File fromSdk = SdkUtils.getUserdataDir((String)this.getName());
        if (fromSdk != null) {
            properties.put("Vm_Path", fromSdk.getAbsolutePath());
        }
        return properties;
    }

    @Override
    public boolean getHasCli() {
        return this.hasCli;
    }

    @Override
    public String getInstanceIdentifier() {
        return this.getSerialNumber();
    }

    @Override
    public ProtocolHandle getProtocolHandle() {
        return this.handle;
    }

    public String getEmulatorDefId() {
        return this.getProperties().getProperty("Emulator_Type");
    }

    @Override
    public String getCurrentLayout() {
        return this.currentLayout;
    }

    @Override
    public void setCurrentLayout(String layoutName) {
        this.currentLayout = layoutName;
    }

    @Override
    public void setHasCli(boolean hasCli) {
        this.hasCli = hasCli;
    }

    @Override
    public void setProtocolHandle(ProtocolHandle handle) {
        this.handle = handle;
    }

    void resetRuntimeVariables() {
        this.handle = null;
        this.hasCli = false;
        this.currentLayout = null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public static void populateWithDefaultProperties(Properties defaultProperties) {
        AndroidEmuDefMgr emuDefMgr = AndroidEmuDefMgr.getInstance();
        String emuDefId = EmulatorPlugin.DEFAULT_EMULATOR_DEFINITION;
        defaultProperties.setProperty("Emulator_Type", emuDefId);
        defaultProperties.setProperty("Skin_Plugin_Id", emuDefMgr.getSkinId(emuDefId));
        defaultProperties.setProperty("Command_Line", emuDefMgr.getCommandLineArgumentsForEmuDefinition(emuDefId));
        defaultProperties.setProperty("Timeout", "120");
        defaultProperties.setProperty("UseVnc", NativeUIUtils.getDefaultUseVnc());
        defaultProperties.setProperty("UseProxy", "false");
    }

    public static void populateWithVMInfo(String instanceName, Properties instanceProperties) {
        AvdInfo vmInfo = SdkUtils.getValidVm((String)instanceName);
        if (vmInfo != null) {
            instanceProperties.setProperty("Vm_Target", vmInfo.getTarget().getName());
            instanceProperties.setProperty("Abi_Type", vmInfo.getAbiType());
            instanceProperties.setProperty("Vm_Skin", SdkUtils.getSkin((AvdInfo)vmInfo));
            instanceProperties.setProperty("Vm_Path", vmInfo.getDataFolderPath());
            String useSnapShot = (String)vmInfo.getProperties().get("snapshot.present");
            if (useSnapShot == null) {
                useSnapShot = "false";
            }
            instanceProperties.setProperty("UseSnapshot", useSnapShot);
            if (instanceProperties.getProperty("startFromSnapshot") == null) {
                instanceProperties.setProperty("startFromSnapshot", useSnapShot);
            }
            if (instanceProperties.getProperty("SaveSnapshot") == null) {
                instanceProperties.setProperty("SaveSnapshot", useSnapShot);
            }
        }
    }

    @Override
    public String getSkinId() {
        return this.getProperties().getProperty("Skin_Plugin_Id");
    }

    @Override
    public File getSkinPath() {
        File skinFile = null;
        AvdInfo avdInfo = SdkUtils.getValidVm((String)this.getName());
        if (avdInfo != null) {
            String skinPath = (String)avdInfo.getProperties().get("skin.path");
            skinPath = String.valueOf(SdkUtils.getCurrentSdk().getSdkOsLocation()) + skinPath;
            IAndroidTarget target = avdInfo.getTarget();
            File candidateFile = new File(skinPath);
            if (!candidateFile.exists()) {
                candidateFile = SdkUtils.getSkinFolder((String)SdkUtils.getSkin((AvdInfo)avdInfo), (IAndroidTarget)target);
            }
            if (!target.isPlatform()) {
                if (!candidateFile.isDirectory()) {
                    IAndroidTarget baseTarget = target.getParent();
                    skinPath = this.getSkinFolderPath(baseTarget);
                    skinFile = new File(skinPath);
                } else {
                    skinFile = candidateFile;
                }
            } else {
                skinFile = candidateFile;
            }
        }
        return skinFile;
    }

    private String getSkinFolderPath(IAndroidTarget target) {
        String vmSkin = this.getProperties().getProperty("Vm_Skin");
        return String.valueOf(target.getLocation()) + File.separator + "skins" + File.separator + vmSkin;
    }

    @Override
    public int getTimeout() {
        int timeout = 0;
        String timeoutString = null;
        try {
            AndmoreLogger.info((String)("Try to get Timeout property from " + this));
            Properties instanceProps = this.getProperties();
            timeoutString = instanceProps.getProperty("Timeout");
            timeout = Integer.parseInt(timeoutString) * 1000;
        }
        catch (Exception exception) {
            AndmoreLogger.warn((String)("Unnable to parse timeout string:" + timeoutString));
            timeout = Integer.parseInt("120") * 1000;
        }
        return timeout;
    }

    public IAndroidTarget getAndroidTarget() {
        IAndroidTarget result = null;
        AvdInfo avdInfo = SdkUtils.getValidVm((String)this.getName());
        if (avdInfo != null) {
            result = avdInfo.getTarget();
        }
        return result;
    }

    @Override
    public String getTarget() {
        String result = null;
        IAndroidTarget target = this.getAndroidTarget();
        if (target != null) {
            result = target.getName();
        }
        return result;
    }

    @Override
    public int getAPILevel() {
        int result = -1;
        IAndroidTarget target = this.getAndroidTarget();
        if (target != null) {
            result = target.getVersion().getApiLevel();
        }
        return result;
    }

    @Override
    public String getCommandLineArguments() {
        return this.getProperties().getProperty("Command_Line", NativeUIUtils.getDefaultCommandLine());
    }

    @Override
    public AbstractStartAndroidEmulatorLogic getStartLogic() {
        String emuDefinition = this.getEmulatorDefId();
        AndroidEmuDefMgr definitionManager = AndroidEmuDefMgr.getInstance();
        return definitionManager.getStartLogic(emuDefinition);
    }

    @Override
    public IInputLogic getInputLogic() {
        String emuDefinition = this.getEmulatorDefId();
        AndroidEmuDefMgr definitionManager = AndroidEmuDefMgr.getInstance();
        return definitionManager.getInputLogic(emuDefinition, this);
    }

    @Override
    public boolean hasDevice() {
        return DDMSFacade.getDeviceBySerialNumber((String)this.getSerialNumber()) != null;
    }

    @Override
    public void changeOrientation(final String parameters) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DDMSFacade.execRemoteApp((String)AndroidDeviceInstance.this.getSerialNumber(), (String)("sendevent /dev/input/event0 " + parameters), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException iOException) {
                    AndmoreLogger.error((String)"Failed to send the command to change the emulator display orientation to portrait.");
                }
            }
        }).start();
    }

    @Override
    public File getUserdata() {
        return SdkUtils.getUserdataFile((String)this.getName());
    }

    @Override
    public File getSnapshotOriginalFilePath() {
        File snapshotOriginalFile = null;
        String snapshotFilePath = String.valueOf(SdkUtils.getSdkToolsPath()) + "lib" + File.separator + "emulator" + File.separator + "snapshots.img";
        snapshotOriginalFile = new File(snapshotFilePath);
        if (!snapshotOriginalFile.exists()) {
            snapshotOriginalFile = null;
        }
        return snapshotOriginalFile;
    }

    @Override
    public List<File> getStateData() {
        return SdkUtils.getStateDataFiles((String)this.getName());
    }

    @Override
    public boolean isClean() {
        boolean userdataExists = false;
        File userdataFile = this.getUserdata();
        if (userdataFile != null && userdataFile.exists()) {
            userdataExists = true;
        }
        return !userdataExists;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public void setProcess(Process process) {
        this.process = process;
    }

    @Override
    public long getWindowHandle() {
        return this.windowHandle;
    }

    @Override
    public void setWindowHandle(long handle) {
        this.windowHandle = handle;
    }

    public String getDeviceName() {
        return this.getName();
    }

    @Override
    public String getFullName() {
        String suffix = this.getNameSuffix();
        if (suffix != null) {
            return String.valueOf(this.getName()) + " (" + suffix + ")";
        }
        return this.getName();
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getSerialNumber() {
        return DDMSFacade.getSerialNumberByName((String)this.getName());
    }

    @Override
    public boolean isAvailable() {
        return !this.getStatus().equals("org.eclipse.andmore.android.emulator.status.notavailable");
    }

    @Override
    public Properties getCommandLineArgumentsAsProperties() {
        return StartupOptionsMgt.parseCommandLine(this.getCommandLineArguments());
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setComposite(Composite composite) {
        this.composite = composite;
    }
}

