/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.sync;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.andmore.ddms.DdmsPlugin;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceMgtView;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceSelectionChangeEvent;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceSelectionChangeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DeviceViewsSync {
    private static DeviceViewsSync instance = null;
    public static final int EMULATOR_VIEW = 0;
    public static final int DEVICE_VIEW = 1;
    public static final int DDMS_VIEW = 2;
    private Method[] syncMethods = null;
    private static String syncInstance = null;

    public static DeviceViewsSync getInstance() {
        if (instance == null) {
            instance = new DeviceViewsSync();
        }
        return instance;
    }

    private DeviceViewsSync() {
        try {
            Class[] parameterTypes = new Class[]{String.class};
            this.syncMethods = new Method[3];
            this.syncMethods[0] = this.getClass().getDeclaredMethod("syncEmulatorView", parameterTypes);
            this.syncMethods[1] = this.getClass().getDeclaredMethod("syncDeviceView", parameterTypes);
            this.syncMethods[2] = this.getClass().getDeclaredMethod("syncDDMSView", parameterTypes);
        }
        catch (Exception e) {
            AndmoreLogger.error((String)("Could not add syncronization method: " + e.getMessage()));
        }
    }

    public void initialize() {
        AbstractAndroidView.addTabSwitchListener(new Listener(){

            public void handleEvent(Event event) {
                String selectedInstanceName;
                IAndroidEmulatorInstance activeInstance = AbstractAndroidView.getActiveInstance();
                if (activeInstance != null && (selectedInstanceName = activeInstance.getName()) != null && !selectedInstanceName.equals(syncInstance)) {
                    DeviceViewsSync.this.sync(0, selectedInstanceName);
                }
            }
        });
        InstanceMgtView.addInstanceSelectionChangeListener((InstanceSelectionChangeListener)new InstanceSelectionChangeListener(){

            public void instanceSelectionChanged(InstanceSelectionChangeEvent event) {
                String selectedInstanceName;
                IInstance instance = event.getInstance();
                if (instance != null && "org.eclipse.andmore.android.emulator.status.online".equals(instance.getStatus()) && (selectedInstanceName = instance.getName()) != null && !selectedInstanceName.equals(syncInstance)) {
                    DeviceViewsSync.this.sync(1, selectedInstanceName);
                }
            }
        });
        DdmsPlugin.getDefault().addSelectionListener(new DdmsPlugin.ISelectionListener(){

            public void selectionChanged(Client client) {
            }

            public void selectionChanged(IDevice device) {
                String selectedInstanceName;
                if (device != null && (selectedInstanceName = device.getAvdName()) != null && !selectedInstanceName.equals(syncInstance)) {
                    DeviceViewsSync.this.sync(2, selectedInstanceName);
                }
            }
        });
    }

    private void sync(Integer fireSyncView, String instanceName) {
        syncInstance = instanceName;
        Object[] arglist = new Object[]{instanceName};
        int i = 0;
        while (i < this.syncMethods.length) {
            if (i != fireSyncView) {
                try {
                    this.syncMethods[i].invoke((Object)this, arglist);
                }
                catch (Exception e) {
                    AndmoreLogger.error((String)("Could not call syncronization method for " + i + " : " + e.getMessage()));
                }
            }
            ++i;
        }
        syncInstance = null;
    }

    private void syncEmulatorView(String instanceName) {
        try {
            IAndroidEmulatorInstance emulatorInstance = DeviceFrameworkManager.getInstance().getInstanceByName(instanceName);
            if (emulatorInstance != null) {
                AbstractAndroidView.setInstance(emulatorInstance);
            } else {
                AndmoreLogger.warn((String)("Could not synchronize with Emulator View: " + instanceName + " not in DeviceFrameworkManager model"));
            }
        }
        catch (Exception e) {
            AndmoreLogger.error((String)("Could not synchronize with Emulator View: " + e.getMessage()));
        }
    }

    private void syncDeviceView(String instanceName) {
        try {
            InstanceRegistry registry = InstanceRegistry.getInstance();
            List tmlInstances = registry.getInstancesByName(instanceName);
            if (tmlInstances.size() > 0) {
                IInstance tmlInstance = (IInstance)tmlInstances.get(0);
                InstanceMgtView.setSeletectedInstance((IInstance)tmlInstance);
            } else {
                AndmoreLogger.warn((String)("Could not synchronize with Device Management View: " + instanceName + " not in TmL InstanceManager model"));
            }
        }
        catch (Exception e) {
            AndmoreLogger.error((String)("Could not synchronize with Device Management View: " + e.getMessage()));
        }
    }

    private void syncDDMSView(String instanceName) {
        try {
            IDevice device = DDMSFacade.getDeviceWithVmName((String)instanceName);
            if (device != null) {
                DdmsPlugin.getDefault().selectionChanged(device, null);
            } else {
                AndmoreLogger.warn((String)"Could not synchronize with DDMS Devices View: Could not retrieve Device object from ADT model");
            }
        }
        catch (Exception e) {
            AndmoreLogger.error((String)("Could not synchronize with DDMS Devices View: " + e.getMessage()));
        }
    }
}

