/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui;

import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedHashSet;
import org.eclipse.sequoyah.device.framework.events.IInstanceListener;
import org.eclipse.sequoyah.device.framework.events.InstanceAdapter;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPropertiesComposite
extends Composite {
    private static final int DEFAULT_MARGIN_SIZE = 20;
    private static final Collection<PropertyCompositeChangeListener> listeners = new LinkedHashSet<PropertyCompositeChangeListener>();
    private IInstanceListener instanceListener;

    public AbstractPropertiesComposite(Composite parent) {
        super(parent, 0);
    }

    public static void addCompositeChangeListener(PropertyCompositeChangeListener listener) {
        listeners.add(listener);
    }

    public static void removeCompositeChangeListener(PropertyCompositeChangeListener listener) {
        listeners.remove(listener);
    }

    protected void notifyCompositeChangeListeners() {
        PropertyCompositeChangeEvent event = new PropertyCompositeChangeEvent(this);
        for (PropertyCompositeChangeListener listener : listeners) {
            listener.compositeChanged(event);
        }
    }

    protected void addInstanceListener(Collection<Control> affectedControls) {
        this.instanceListener = new PropertyInstanceListener(affectedControls);
        InstanceEventManager.getInstance().addInstanceListener(this.instanceListener);
    }

    protected void updateWidgetEnableStatus(boolean enabled, Collection<Control> controlsToUpdate) {
        for (Control control : controlsToUpdate) {
            if (control.isDisposed()) continue;
            control.setEnabled(enabled);
        }
    }

    protected final void setMainLayout(int numColumns) {
        GridLayout mainLayout = new GridLayout(numColumns, false);
        mainLayout.marginWidth = 20;
        mainLayout.marginHeight = 20;
        this.setLayout((Layout)mainLayout);
    }

    public abstract String getErrorMessage();

    public void dispose() {
        if (this.instanceListener != null) {
            InstanceEventManager.getInstance().removeInstanceListener(this.instanceListener);
        }
        super.dispose();
    }

    public class PropertyCompositeChangeEvent
    extends EventObject {
        PropertyCompositeChangeEvent(AbstractPropertiesComposite composite) {
            super((Object)composite);
        }
    }

    public static interface PropertyCompositeChangeListener
    extends EventListener {
        public void compositeChanged(PropertyCompositeChangeEvent var1);
    }

    private class PropertyInstanceListener
    extends InstanceAdapter {
        private Collection<Control> affectedControls;

        public PropertyInstanceListener(Collection<Control> affectedControls) {
            this.affectedControls = affectedControls;
        }

        public void instanceUpdated(final InstanceEvent e) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IInstance instance = e.getInstance();
                    boolean editable = !instance.getStatus().equals("org.eclipse.andmore.android.emulator.status.online");
                    AbstractPropertiesComposite.this.updateWidgetEnableStatus(editable, PropertyInstanceListener.this.affectedControls);
                }
            });
        }
    }
}

