/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui.wizard;

import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.device.IDevicePropertiesConstants;
import org.eclipse.andmore.android.emulator.device.instance.AndroidDeviceInstance;
import org.eclipse.andmore.android.emulator.device.ui.AbstractPropertiesComposite;
import org.eclipse.andmore.android.emulator.device.ui.PropertiesMainComposite;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.DefaultDeviceTypeMenuWizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.IInstanceProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WizardMainPage
extends WizardPage
implements IInstanceProperties {
    private PropertiesMainComposite mainComposite;
    DefaultDeviceTypeMenuWizardPage tmlPage = null;
    private AbstractPropertiesComposite.PropertyCompositeChangeListener listener = new AbstractPropertiesComposite.PropertyCompositeChangeListener(){

        @Override
        public void compositeChanged(AbstractPropertiesComposite.PropertyCompositeChangeEvent e) {
            String errorMessage = WizardMainPage.this.mainComposite.getErrorMessage();
            if (errorMessage != null) {
                WizardMainPage.this.setErrorMessage(errorMessage);
                WizardMainPage.this.setPageComplete(false);
            } else {
                WizardMainPage.this.setErrorMessage(null);
                WizardMainPage.this.setPageComplete(true);
                WizardMainPage.this.setMessage(EmulatorNLS.UI_WizardMainPage_PageName);
            }
        }
    };

    public WizardMainPage() {
        super(EmulatorNLS.UI_WizardMainPage_PageName);
    }

    public void createControl(Composite parent) {
        try {
            AndmoreLogger.collectUsageData((String)"new_device_wizard", (String)"emulator", (String)"operation_executed", (String)"org.eclipse.andmore.android.emulator", (String)EmulatorPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        this.setTitle(EmulatorNLS.UI_General_WizardTitle);
        this.setErrorMessage(null);
        this.setMessage(EmulatorNLS.UI_WizardMainPage_PageName);
        IAndroidTarget vmTarget = null;
        String vmSkin = "";
        String abiType = "armeabi";
        this.tmlPage = (DefaultDeviceTypeMenuWizardPage)this.getPreviousPage();
        IAndroidTarget[] targets = SdkUtils.getAllTargets();
        if (targets != null && targets.length > 0) {
            Arrays.sort(targets, new Comparator<IAndroidTarget>(){

                @Override
                public int compare(IAndroidTarget o1, IAndroidTarget o2) {
                    int returnValue = o1.getVersion().getApiLevel() == o2.getVersion().getApiLevel() ? 0 : (o1.getVersion().getApiLevel() > o2.getVersion().getApiLevel() ? 1 : -1);
                    return returnValue;
                }
            });
            int maxAPILevel = targets[targets.length - 1].getVersion().getApiLevel();
            IAndroidTarget[] iAndroidTargetArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IAndroidTarget t = iAndroidTargetArray[n2];
                if (t.getVersion().getApiLevel() == maxAPILevel) {
                    vmTarget = t;
                    break;
                }
                ++n2;
            }
            File[] skins = vmTarget.getSkins();
            vmSkin = vmTarget.getDefaultSkin().getName();
            List<File> skinsList = Arrays.asList(skins);
            if (SdkUtils.isJILSdk()) {
                String tmpVmSkin = null;
                int i = 0;
                while (tmpVmSkin == null && i < skins.length) {
                    if (skins[i].getName().toLowerCase().trim().equals("wvga")) {
                        tmpVmSkin = skins[i].getName();
                    }
                    ++i;
                }
                if (tmpVmSkin != null) {
                    vmSkin = tmpVmSkin;
                }
            }
            if (!skinsList.contains(vmSkin)) {
                vmSkin = skins[0].getName();
            }
        }
        String vmPath = IDevicePropertiesConstants.defaultVmPath;
        Properties defaultProperties = new Properties();
        AndroidDeviceInstance.populateWithDefaultProperties(defaultProperties);
        String timeout = defaultProperties.getProperty("Timeout");
        String useVnc = defaultProperties.getProperty("UseVnc");
        String useProxy = defaultProperties.getProperty("UseProxy");
        String useSnapshot = defaultProperties.getProperty("UseSnapshot");
        String saveSnapshot = defaultProperties.getProperty("SaveSnapshot");
        String startFromSnapshot = defaultProperties.getProperty("startFromSnapshot");
        this.mainComposite = new PropertiesMainComposite(parent, this.tmlPage.getInstanceName(), EmulatorPlugin.DEFAULT_EMULATOR_DEFINITION, timeout, Boolean.parseBoolean(useVnc), Boolean.parseBoolean(useProxy), Boolean.parseBoolean(useSnapshot), Boolean.parseBoolean(saveSnapshot), Boolean.parseBoolean(startFromSnapshot), vmTarget, vmSkin, vmPath, abiType, false, true, true);
        AbstractPropertiesComposite.addCompositeChangeListener(this.listener);
        this.setControl((Control)this.mainComposite);
        if (targets == null || targets != null && targets.length <= 0) {
            this.setMessage(EmulatorNLS.WizardMainPage_NO_SDK_CONFIGURED_MSG);
            this.setPageComplete(false);
            return;
        }
        String initialMessage = this.mainComposite.getErrorMessage();
        if (initialMessage != null) {
            this.setMessage(initialMessage);
        }
        this.setPageComplete(initialMessage == null);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.mainComposite.setName(this.tmlPage.getInstanceName());
        }
        super.setVisible(visible);
    }

    public String getSkinId() {
        return this.mainComposite.getSkinId();
    }

    public String getTimeout() {
        return this.mainComposite.getTimeout();
    }

    public String getUseVnc() {
        return this.mainComposite.getUseVnc();
    }

    public String getUseProxy() {
        return this.mainComposite.getUseProxy();
    }

    public String getEmulatorDefId() {
        return EmulatorPlugin.DEFAULT_EMULATOR_DEFINITION;
    }

    public String getUseSnapshot() {
        return this.mainComposite.getUseSnapshot();
    }

    public void setInstanceName(String name) {
        this.mainComposite.setName(name);
    }

    public IAndroidTarget getVmTarget() {
        return this.mainComposite.getVmTarget();
    }

    public String getAbiType() {
        return this.mainComposite.getAbiType();
    }

    public String getVmSkin() {
        return this.mainComposite.getVmSkin();
    }

    public String getVmPath() {
        return this.mainComposite.getVmPath();
    }

    public String getSDCard() {
        return this.mainComposite.getSDCard();
    }

    public String getCommandLine() {
        Properties defaultProperties = new Properties();
        AndroidDeviceInstance.populateWithDefaultProperties(defaultProperties);
        return defaultProperties.getProperty("Command_Line");
    }

    public boolean isPageComplete() {
        return this.mainComposite != null && this.mainComposite.getErrorMessage() == null;
    }

    public void dispose() {
        AbstractPropertiesComposite.removeCompositeChangeListener(this.listener);
        this.setControl(null);
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
        }
        super.dispose();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("Timeout", this.getTimeout());
        properties.setProperty("UseVnc", this.getUseVnc());
        properties.setProperty("UseProxy", this.getUseProxy());
        properties.setProperty("Emulator_Type", this.getEmulatorDefId());
        properties.setProperty("Skin_Plugin_Id", this.getSkinId());
        properties.setProperty("Vm_Skin", this.getVmSkin());
        properties.setProperty("Vm_Path", this.getVmPath());
        properties.setProperty("Abi_Type", this.getAbiType());
        properties.setProperty("UseSnapshot", this.getUseSnapshot());
        properties.setProperty("SaveSnapshot", this.getSaveSnapshot());
        properties.setProperty("startFromSnapshot", this.getstartFromSnapshot());
        if (this.getVmTarget() != null) {
            properties.setProperty("Vm_Target", this.getVmTarget().getName());
        } else {
            properties.setProperty("Vm_Target", "");
        }
        return properties;
    }

    public String getstartFromSnapshot() {
        return this.mainComposite.getstartFromSnapshot();
    }

    public String getSaveSnapshot() {
        return this.mainComposite.getSaveSnapshot();
    }
}

