/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui.wizard;

import com.android.sdklib.IAndroidTarget;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.device.refresh.InstancesListRefresh;
import org.eclipse.andmore.android.emulator.device.ui.wizard.WizardMainPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sequoyah.device.framework.ui.wizard.DefaultDeviceTypeMenuWizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.DeviceWizardRunnable;

public class WizardMainPageOperation
extends DeviceWizardRunnable {
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        WizardMainPage page = (WizardMainPage)this.getWizardPage();
        DefaultDeviceTypeMenuWizardPage tmlPage = (DefaultDeviceTypeMenuWizardPage)page.getPreviousPage();
        try {
            if (!tmlPage.getInstanceName().equals(page.getName())) {
                page.setInstanceName(tmlPage.getInstanceName());
            }
            SdkUtils.createVm((String)page.getVmPath(), (String)tmlPage.getInstanceName(), (IAndroidTarget)page.getVmTarget(), (String)page.getAbiType(), (String)page.getVmSkin(), (String)page.getUseSnapshot(), (String)(page.getSDCard().length() == 0 ? null : page.getSDCard()));
        }
        catch (CoreException e) {
            EclipseUtils.showErrorDialog((String)"Could not create instance ", (String)e.getStatus().getMessage());
            AndmoreLogger.error(WizardMainPageOperation.class, (String)("Could not create AVD: " + tmlPage.getInstanceName()), (Throwable)e);
        }
        Collection vmInstances = SdkUtils.getAllValidVmNames();
        InstancesListRefresh.refreshStatus(vmInstances, tmlPage.getInstanceName());
    }
}

