/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.device.ui.wizard;

import java.io.File;
import java.util.Properties;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.core.skin.SkinFramework;
import org.eclipse.andmore.android.emulator.device.instance.options.StartupOptionsMgt;
import org.eclipse.andmore.android.emulator.device.ui.AbstractPropertiesComposite;
import org.eclipse.andmore.android.emulator.device.ui.StartupOptionsComposite;
import org.eclipse.andmore.android.emulator.device.ui.wizard.WizardMainPage;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.device.framework.ui.wizard.IInstanceProperties;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WizardStartupOptionsPage
extends WizardPage
implements IInstanceProperties {
    private StartupOptionsComposite startupOptionsComposite;
    private IAndroidSkin skin;
    private final AbstractPropertiesComposite.PropertyCompositeChangeListener compositeChangeListener = new AbstractPropertiesComposite.PropertyCompositeChangeListener(){

        @Override
        public void compositeChanged(AbstractPropertiesComposite.PropertyCompositeChangeEvent e) {
            String errorMessage = WizardStartupOptionsPage.this.startupOptionsComposite.getErrorMessage();
            if (errorMessage != null) {
                WizardStartupOptionsPage.this.setErrorMessage(errorMessage);
                WizardStartupOptionsPage.this.setPageComplete(false);
            } else {
                WizardStartupOptionsPage.this.setErrorMessage(null);
                WizardStartupOptionsPage.this.setPageComplete(true);
            }
        }
    };

    public WizardStartupOptionsPage() {
        super(EmulatorNLS.UI_WizardStartupOptionsPage_PageMessage);
    }

    public void createControl(Composite parent) {
        WizardMainPage page = (WizardMainPage)this.getPreviousPage();
        boolean canCalculateScale = true;
        try {
            if (page.getSkinId() != null) {
                SkinFramework sm = new SkinFramework();
                this.skin = sm.getSkinById(page.getSkinId(), new File(String.valueOf(page.getVmTarget().getLocation()) + "skins" + File.separator + page.getVmSkin()));
            }
        }
        catch (SkinException e) {
            AndmoreLogger.error(((Object)((Object)this)).getClass(), (String)"Error reading instance skin during startup options page creation", (Throwable)((Object)e));
            canCalculateScale = false;
        }
        this.setTitle(EmulatorNLS.UI_General_WizardTitle);
        this.setErrorMessage(null);
        if (this.getMessage() != null) {
            this.setMessage(EmulatorNLS.UI_WizardStartupOptionsPage_PageMessage);
        }
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginTop = 0;
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.startupOptionsComposite = new StartupOptionsComposite(parent, NativeUIUtils.getDefaultCommandLine(), this.skin, canCalculateScale);
        AbstractPropertiesComposite.addCompositeChangeListener(this.compositeChangeListener);
        this.startupOptionsComposite.setLayout((Layout)mainLayout);
        this.setControl((Control)this.startupOptionsComposite);
        this.setPageComplete(true);
    }

    public boolean isPageComplete() {
        boolean isComplete = true;
        if (this.startupOptionsComposite != null) {
            isComplete = this.startupOptionsComposite.getErrorMessage() == null;
        }
        return isComplete;
    }

    public void dispose() {
        AbstractPropertiesComposite.removeCompositeChangeListener(this.compositeChangeListener);
        this.setControl(null);
        if (this.startupOptionsComposite != null) {
            this.startupOptionsComposite.dispose();
            this.startupOptionsComposite = null;
        }
        super.dispose();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.startupOptionsComposite == null) {
            properties.setProperty("Command_Line", NativeUIUtils.getDefaultCommandLine());
        } else {
            properties.setProperty("Command_Line", StartupOptionsMgt.getParamList());
        }
        return properties;
    }
}

