/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.exception.StartTimeoutException;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class TransferFilesLogic
implements IAndroidLogic {
    private String localDir = "";
    private String remoteDir = "";
    private final Collection<String> filenames = new LinkedList<String>();

    @Override
    public void execute(IAndroidLogicInstance instance, int timeout, IProgressMonitor monitor) throws InstanceStartException, StartCancelledException, StartTimeoutException, IOException {
        if (instance != null && timeout > 0 && this.localDir != null && !"".equals(this.localDir) && this.remoteDir != null && "".equals(this.remoteDir)) {
            AndmoreLogger.error((String)"Cannot transfer files because the parameters provided are not as expected.");
            throw new InstanceStartException(EmulatorNLS.ERR_TransferFilesLogic_NotEnoughInformation);
        }
        String serialNumber = DDMSFacade.getSerialNumberByName((String)instance.getName());
        IStatus status = DDMSFacade.pushFiles((String)serialNumber, (String)this.getLocalDir(), this.getFilenames(), (String)this.getRemoteDir(), (int)timeout, (IProgressMonitor)monitor, null);
        if (status.getSeverity() == 8) {
            throw new StartCancelledException();
        }
        if (status.getSeverity() == 4) {
            throw new InstanceStartException(status.getMessage());
        }
    }

    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    public void addFilename(String filename) {
        this.filenames.add(filename);
    }

    public Collection<String> getFilenames() {
        return this.filenames;
    }

    public void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    public String getRemoteDir() {
        return this.remoteDir;
    }
}

