/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.logic;

import java.util.Collection;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStartException;
import org.eclipse.andmore.android.emulator.logic.AndroidLogicUtils;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.emulator.logic.StartVncServerLogic;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class VncServerJob
extends Job
implements ISchedulingRule {
    private String serialNumber;
    private final Collection<String> remoteCommands;

    public VncServerJob(IAndroidLogicInstance instance, Collection<String> remoteCommands) throws InstanceStartException {
        super("VNC Server - " + instance.getName());
        this.serialNumber = ((ISerialNumbered)instance).getSerialNumber();
        try {
            AndroidLogicUtils.testDeviceStatus(this.serialNumber);
        }
        catch (AndroidException e) {
            throw new InstanceStartException(e.getMessage());
        }
        this.remoteCommands = remoteCommands;
        this.setSystem(true);
        this.setRule(this);
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            AndmoreLogger.info((String)("Executing VNC Server on " + this.serialNumber));
            AndroidLogicUtils.testDeviceStatus(this.serialNumber);
            DDMSFacade.execRemoteApp((String)this.serialNumber, this.remoteCommands, (IProgressMonitor)monitor);
            if (monitor.isCanceled()) {
                status = Status.CANCEL_STATUS;
            }
        }
        catch (Exception e) {
            String errorMessage = "Error while trying to run the VNC server on " + this.serialNumber;
            AndmoreLogger.error((String)(String.valueOf(errorMessage) + " " + e.getMessage()));
            status = new Status(8, "org.eclipse.andmore.android.emulator", errorMessage, (Throwable)e);
        }
        AndmoreLogger.info((String)("Finished the execution of the VNC Server on " + this.serialNumber + " with status " + status));
        return status;
    }

    public boolean belongsTo(Object family) {
        return StartVncServerLogic.VNC_SERVER_JOB_FAMILY.equals(family);
    }

    public boolean contains(ISchedulingRule rule) {
        boolean contains = false;
        if (rule instanceof VncServerJob) {
            VncServerJob otherVncServerJob = (VncServerJob)rule;
            contains = otherVncServerJob.serialNumber.equals(this.serialNumber);
        }
        return contains;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.contains(rule);
    }
}

