/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.skin.android;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.skin.AndroidSkinBean;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidKey;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.skin.android.AndroidSkinTranslator;
import org.eclipse.andmore.android.emulator.skin.android.parser.LayoutFileModel;
import org.eclipse.andmore.android.emulator.skin.android.parser.LayoutFileParser;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class AndroidSkin
implements IAndroidSkin {
    private final Map<String, ImageData> releasedImagesPool = new HashMap<String, ImageData>();
    private final Map<String, ImageData> pressedImagesPool = new HashMap<String, ImageData>();
    private final Map<String, ImageData> enterImagesPool = new HashMap<String, ImageData>();
    private final Map<String, Collection<IAndroidKey>> androidKeysPool = new HashMap<String, Collection<IAndroidKey>>();
    private File skinFilesPath;
    private LayoutFileModel layoutFile;
    private Properties keycodes;

    private ImageData getImageFromPool(String layoutName, Map<String, ImageData> pool) throws SkinException {
        if (this.layoutFile == null) {
            AndmoreLogger.error((String)"User has tried to request skin data without setting a valid skin files path");
            throw new SkinException(EmulatorNLS.ERR_AndroidSkin_NoLayoutLoaded);
        }
        ImageData id = pool.get(layoutName);
        if (id == null) {
            this.addImagesToPools(layoutName);
            id = pool.get(layoutName);
        }
        return id;
    }

    @Override
    public Collection<IAndroidKey> getKeyDataCollection(String layoutName) {
        Collection<Object> androidKeys;
        try {
            if (this.layoutFile == null) {
                AndmoreLogger.error((String)"User has tried to request skin data without setting a valid skin files path");
                throw new SkinException(EmulatorNLS.ERR_AndroidSkin_NoLayoutLoaded);
            }
            androidKeys = this.androidKeysPool.get(layoutName);
            if (androidKeys == null) {
                System.gc();
                androidKeys = AndroidSkinTranslator.generateAndroidKeys(this.layoutFile, layoutName, this.skinFilesPath);
                System.gc();
                this.androidKeysPool.put(layoutName, androidKeys);
            }
        }
        catch (SkinException e) {
            androidKeys = new HashSet();
            AndmoreLogger.error((String)("The key data could not be retrieved from skin files. Cause: " + e.getMessage()));
            EclipseUtils.showErrorDialog((AndroidException)e);
        }
        return androidKeys;
    }

    @Override
    public Properties getKeyCodes() {
        if (this.keycodes == null || this.keycodes != null && this.keycodes.isEmpty()) {
            try {
                this.keycodes = AndroidSkinTranslator.getKeycodes(this.layoutFile, this.skinFilesPath);
            }
            catch (SkinException e) {
                this.keycodes = new Properties();
                AndmoreLogger.error((String)("The key data could not be retrieved from skin files. Cause: " + e.getMessage()));
            }
        }
        return this.keycodes;
    }

    @Override
    public ImageData getPressedImageData(String layoutName) throws SkinException {
        return this.getImageFromPool(layoutName, this.pressedImagesPool);
    }

    @Override
    public ImageData getEnterImageData(String layoutName) throws SkinException {
        return this.getImageFromPool(layoutName, this.enterImagesPool);
    }

    @Override
    public ImageData getReleasedImageData(String layoutName) throws SkinException {
        return this.getImageFromPool(layoutName, this.releasedImagesPool);
    }

    @Override
    public AndroidSkinBean getSkinBean(String layoutName) throws SkinException {
        int dh;
        int dw;
        if (this.layoutFile == null) {
            AndmoreLogger.error((String)"User has tried to request additional skin data without setting a valid skin files path");
            throw new SkinException(EmulatorNLS.ERR_AndroidSkin_NoLayoutLoaded);
        }
        AndroidSkinBean bean = new AndroidSkinBean();
        String partName = this.layoutFile.getMainPartName(layoutName);
        Point dPosition = AndroidSkinTranslator.translateDisplayPosition(this.layoutFile, layoutName, partName, this.skinFilesPath);
        int dWidth = this.layoutFile.getDisplayWidth(partName);
        int dHeight = this.layoutFile.getDisplayHeight(partName);
        if (this.layoutFile.isSwapWidthHeightNeededAtLayout(layoutName)) {
            dw = dHeight;
            dh = dWidth;
        } else {
            dw = dWidth;
            dh = dHeight;
        }
        bean.addSkinPropertyValue("internalViewX", dPosition.x);
        bean.addSkinPropertyValue("internalViewY", dPosition.y);
        bean.addSkinPropertyValue("internalViewWidth", dw);
        bean.addSkinPropertyValue("internalViewHeight", dh);
        bean.addSkinPropertyValue("embeddedViewScale", 10);
        return bean;
    }

    @Override
    public boolean isFlipSupported() {
        return false;
    }

    @Override
    public void setSkinFilesPath(String skinFilesPath) throws SkinException {
        this.skinFilesPath = new File(skinFilesPath);
        if (!this.skinFilesPath.isDirectory()) {
            AndmoreLogger.error((String)"Provided skin files path is not a directory. Setting the skin files path operation has failed.");
            throw new SkinException(EmulatorNLS.ERR_AndroidSkin_ProvidedSkinPathIsNotADirectory);
        }
        this.layoutFile = LayoutFileParser.readLayout(this.skinFilesPath);
    }

    @Override
    public boolean isSwapWidthHeightNeededAtLayout(String layoutName) {
        return this.layoutFile.isSwapWidthHeightNeededAtLayout(layoutName);
    }

    @Override
    public Collection<String> getAvailableLayouts() {
        return this.layoutFile.getLayoutNames();
    }

    @Override
    public String getLayoutScreenCommand(String layoutName) {
        return this.layoutFile.getLayoutSwitchCommand(layoutName);
    }

    @Override
    public String getNextLayout(String referenceLayout) {
        AndmoreLogger.info((String)"Calculating the next layout");
        String next = null;
        if (referenceLayout != null) {
            ArrayList<String> layoutsList = new ArrayList<String>(this.getAvailableLayouts());
            if (layoutsList.size() > 1) {
                int currentLayoutNum = layoutsList.indexOf(referenceLayout);
                next = currentLayoutNum != layoutsList.size() - 1 ? (String)layoutsList.get(++currentLayoutNum) : (String)layoutsList.get(0);
                AndmoreLogger.info((String)("Next layout:  " + next));
            } else {
                AndmoreLogger.warn((String)"The skin doesn't have multiple layouts. The operation was not performed");
            }
        } else {
            AndmoreLogger.warn((String)"The skin doesn't have multiple layouts. The operation was not performed");
        }
        return next;
    }

    @Override
    public String getPreviousLayout(String referenceLayout) {
        AndmoreLogger.info((String)"Calculating the previous layout");
        String previous = null;
        if (referenceLayout != null) {
            ArrayList<String> layoutsList = new ArrayList<String>(this.getAvailableLayouts());
            if (layoutsList.size() > 1) {
                int currentLayoutNum = layoutsList.indexOf(referenceLayout);
                previous = currentLayoutNum != 0 ? (String)layoutsList.get(--currentLayoutNum) : (String)layoutsList.get(layoutsList.size() - 1);
                AndmoreLogger.info((String)("Previous layout: " + previous));
            } else {
                AndmoreLogger.warn((String)"The skin doesn't have multiple layouts. The operation was not performed");
            }
        } else {
            AndmoreLogger.warn((String)"The skin doesn't have multiple layouts. The operation was not performed");
        }
        return previous;
    }

    @Override
    public RGB getBackgroundColor(String layoutName) {
        return this.layoutFile.getLayoutColor(layoutName, this.skinFilesPath);
    }

    @Override
    public int getDpadRotation(String layoutName) {
        return this.layoutFile.getDpadRotation(layoutName);
    }

    private void addImagesToPools(String key) throws SkinException {
        if (key == null || !this.layoutFile.getLayoutNames().contains(key)) {
            throw new SkinException(EmulatorNLS.ERR_AndroidSkin_InvalidLayoutProvided);
        }
        System.gc();
        ImageData[] images = AndroidSkinTranslator.generateLayoutImages(this.layoutFile, key, this.skinFilesPath);
        AndmoreLogger.info((String)"Adding released/pressed/hover images to the pool");
        this.releasedImagesPool.put(key, images[0]);
        this.pressedImagesPool.put(key, images[1]);
        this.enterImagesPool.put(key, images[2]);
        System.gc();
    }
}

