/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.skin.android;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.EmulatorPlugin;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.skin.AndroidPressKey;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidKey;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.skin.android.parser.LayoutFileModel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;

public class AndroidSkinTranslator {
    private static final String CHARMAP_QWERTY = "qwerty";
    private static final String CHARMAP_QWERTY2 = "qwerty2";
    private static final String CHARMAP_QWERTY_FILE = "res/qwerty.properties";
    private static final String CHARMAP_AVRCP = "AVRCP";
    private static final String CHARMAP_AVRCP_FILE = "res/AVRCP.properties";
    private static final String CHARMAP_OPHONE_QWERTY_FILE = "res/ophone_qwerty.properties";
    private static final String CHARMAP_OPHONE_AVRCP_FILE = "res/ophone_AVRCP.properties";
    private static final String DPAD_DOWN = "DPAD_DOWN";
    private static final String DPAD_UP = "DPAD_UP";
    private static final String DPAD_LEFT = "DPAD_LEFT";
    private static final String DPAD_RIGHT = "DPAD_RIGHT";

    static Collection<IAndroidKey> generateAndroidKeys(LayoutFileModel layoutFile, String layoutName, File skinFilesPath) throws SkinException {
        LinkedHashSet<IAndroidKey> keyCollection = new LinkedHashSet<IAndroidKey>();
        Properties keycodes = AndroidSkinTranslator.getKeycodes(layoutFile, skinFilesPath);
        Collection<String> partNames = layoutFile.getLayoutPartNames(layoutName);
        Point offsetL = AndroidSkinTranslator.getLayoutOffset(layoutFile, layoutName, skinFilesPath);
        for (String partName : partNames) {
            Point offsetP = AndroidSkinTranslator.getPartOffset(layoutFile, partName);
            Point partSize = AndroidSkinTranslator.getPartImageSize(layoutFile, partName, skinFilesPath, offsetP);
            Collection<String> buttonNames = layoutFile.getButtonNames(partName);
            for (String buttonName : buttonNames) {
                int endY;
                int endX;
                String k = buttonName.toUpperCase().replace("-", "_");
                String keyCodeStr = (String)keycodes.get(k);
                if (keyCodeStr == null) continue;
                int buttonW = layoutFile.getButtonWidth(partName, buttonName, skinFilesPath);
                int buttonH = layoutFile.getButtonHeight(partName, buttonName, skinFilesPath);
                Point buttonPos = AndroidSkinTranslator.translateButtonPosition(layoutFile, layoutName, partName, buttonName, skinFilesPath, offsetP, partSize);
                int startX = offsetL.x + buttonPos.x;
                int startY = offsetL.y + buttonPos.y;
                if (layoutFile.isSwapWidthHeightNeededAtLayout(layoutName, partName)) {
                    endX = startX + buttonH;
                    endY = startY + buttonW;
                } else {
                    endX = startX + buttonW;
                    endY = startY + buttonH;
                }
                int dpadRotation = layoutFile.getDpadRotation(layoutName);
                keyCodeStr = AndroidSkinTranslator.getRotatedKeyCode(k, keyCodeStr, dpadRotation, keycodes);
                AndroidPressKey key = new AndroidPressKey(buttonName, keyCodeStr, buttonName, startX, startY, endX, endY, "", 0);
                keyCollection.add(key);
            }
        }
        return keyCollection;
    }

    private static String getRotatedKeyCode(String keyName, String keyCodeStr, int dpadRotation, Properties keycodes) {
        String keyCode = keyCodeStr;
        switch (dpadRotation % 4) {
            case 1: {
                if (DPAD_DOWN.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_RIGHT);
                    break;
                }
                if (DPAD_LEFT.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_DOWN);
                    break;
                }
                if (DPAD_RIGHT.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_UP);
                    break;
                }
                if (!DPAD_UP.equals(keyName)) break;
                keyCode = (String)keycodes.get(DPAD_LEFT);
                break;
            }
            case 2: {
                if (DPAD_DOWN.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_UP);
                    break;
                }
                if (DPAD_LEFT.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_RIGHT);
                    break;
                }
                if (DPAD_RIGHT.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_LEFT);
                    break;
                }
                if (!DPAD_UP.equals(keyName)) break;
                keyCode = (String)keycodes.get(DPAD_DOWN);
                break;
            }
            case 3: {
                if (DPAD_DOWN.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_LEFT);
                    break;
                }
                if (DPAD_LEFT.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_UP);
                    break;
                }
                if (DPAD_RIGHT.equals(keyName)) {
                    keyCode = (String)keycodes.get(DPAD_DOWN);
                    break;
                }
                if (!DPAD_UP.equals(keyName)) break;
                keyCode = (String)keycodes.get(DPAD_RIGHT);
                break;
            }
        }
        return keyCode;
    }

    static ImageData mergeImageGC(ImageData srcData, ImageData dstData, int dstX, int dstY) {
        Shell s = new Shell();
        Image srcImg = new Image((Device)s.getDisplay(), srcData);
        Image dstImg = new Image((Device)s.getDisplay(), dstData);
        GC gc = new GC((Drawable)dstImg);
        gc.drawImage(srcImg, dstX, dstY);
        gc.dispose();
        return dstImg.getImageData();
    }

    static ImageData[] generateLayoutImages(LayoutFileModel layoutFile, String layoutName, File skinFilesPath) {
        ImageData[] layoutImgs = new ImageData[3];
        Point offsetL = AndroidSkinTranslator.getLayoutOffset(layoutFile, layoutName, skinFilesPath);
        Collection<String> partNames = layoutFile.getLayoutPartNames(layoutName);
        for (String partName : partNames) {
            ImageData[] bgDatas;
            if (!layoutFile.partHasBg(partName) || (partName.equals("portrait") || partName.equals("landscape")) && !partName.equals(layoutName)) continue;
            Point offsetP = AndroidSkinTranslator.getPartOffset(layoutFile, partName);
            Point partSize = AndroidSkinTranslator.getPartImageSize(layoutFile, partName, skinFilesPath, offsetP);
            int bgH = layoutFile.getBackgroundHeight(partName, skinFilesPath);
            int bgW = layoutFile.getBackgroundWidth(partName, skinFilesPath);
            bgDatas = new ImageData[]{offsetP.x > 0 || offsetP.y > 0 || partSize.x > offsetP.x + bgW || partSize.y > offsetP.y + bgH ? AndroidSkinTranslator.generateExpandedPartImageData(layoutFile, layoutName, partName, offsetP, skinFilesPath, offsetP, partSize) : AndroidSkinTranslator.getImageData(layoutFile, partName, null, skinFilesPath), AndroidSkinTranslator.generateMergedWithButtonsImage(layoutFile, (ImageData)bgDatas[0].clone(), partName, skinFilesPath, offsetP, false), AndroidSkinTranslator.generateMergedWithButtonsImage(layoutFile, (ImageData)bgDatas[0].clone(), partName, skinFilesPath, offsetP, true)};
            int img = 0;
            while (img < 3) {
                ImageData merge;
                if (layoutImgs[img] == null) {
                    Point layoutSize = AndroidSkinTranslator.getLayoutImageSize(layoutFile, layoutName, skinFilesPath, offsetL);
                    layoutImgs[img] = AndroidSkinTranslator.generateImageDataWithBackground(layoutFile, layoutName, layoutSize.x, layoutSize.y, bgDatas[img], skinFilesPath);
                }
                int rotation = layoutFile.getPartRotationAtLayout(layoutName, partName);
                Point partPos = AndroidSkinTranslator.translatePartPosition(layoutFile, layoutName, partName, skinFilesPath, offsetP, partSize);
                bgDatas[img] = AndroidSkinTranslator.generateRotatedImage(bgDatas[img], rotation);
                int startX = offsetL.x - offsetP.x + partPos.x;
                int startY = offsetL.y - offsetP.y + partPos.y;
                layoutImgs[img] = merge = AndroidSkinTranslator.mergeImageGC(bgDatas[img], layoutImgs[img], startX, startY);
                ++img;
            }
        }
        return layoutImgs;
    }

    static Point translateDisplayPosition(LayoutFileModel layoutFile, String layoutName, String partName, File skinFilesPath) {
        Point displayPos = layoutFile.getDisplayPosition(partName);
        int displayW = layoutFile.getDisplayWidth(partName);
        int displayH = layoutFile.getDisplayHeight(partName);
        Point offsetP = AndroidSkinTranslator.getPartOffset(layoutFile, partName);
        Point partSize = !layoutFile.partHasBg(partName) ? AndroidSkinTranslator.getPartImageSize(layoutFile, layoutName, skinFilesPath, offsetP) : AndroidSkinTranslator.getPartImageSize(layoutFile, partName, skinFilesPath, offsetP);
        displayPos = AndroidSkinTranslator.translatePartElementPosition(layoutFile, layoutName, partName, skinFilesPath, displayPos, displayW, displayH, offsetP, partSize);
        Point offsetL = AndroidSkinTranslator.getLayoutOffset(layoutFile, layoutName, skinFilesPath);
        displayPos.x += offsetL.x;
        displayPos.y += offsetL.y;
        return displayPos;
    }

    static Properties getKeycodes(LayoutFileModel layoutFile, File skinFilesPath) throws SkinException {
        String charmap = layoutFile.getKeyboardCharmap();
        Properties keycodes = new Properties();
        InputStream is = null;
        URL url = null;
        try {
            if (charmap == null || charmap.equals(CHARMAP_QWERTY) || charmap.equals(CHARMAP_QWERTY2)) {
                url = EmulatorPlugin.getDefault().getBundle().getResource(SdkUtils.isOphoneSDK() ? CHARMAP_OPHONE_QWERTY_FILE : CHARMAP_QWERTY_FILE);
            } else if (charmap.equals(CHARMAP_AVRCP)) {
                url = EmulatorPlugin.getDefault().getBundle().getResource(SdkUtils.isOphoneSDK() ? CHARMAP_OPHONE_AVRCP_FILE : CHARMAP_AVRCP_FILE);
            } else {
                AndmoreLogger.warn((String)("The skin at " + skinFilesPath.getAbsolutePath() + " does not use a supported charmap"));
                Properties properties = keycodes;
                return properties;
            }
            try {
                is = url.openStream();
                keycodes.load(is);
            }
            catch (IOException iOException) {
                AndmoreLogger.error((String)("There was an error reading the file " + url));
                throw new SkinException(EmulatorNLS.ERR_AndroidSkinTranslator_ErrorReadingKeycodeFile);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                AndmoreLogger.error((String)"Could not close input stream: ", (String)e.getMessage());
            }
        }
        return keycodes;
    }

    public static Properties getQwertyKeyMap() {
        Properties keycodes = new Properties();
        URL url = EmulatorPlugin.getDefault().getBundle().getResource(SdkUtils.isOphoneSDK() ? CHARMAP_OPHONE_QWERTY_FILE : CHARMAP_QWERTY_FILE);
        try {
            InputStream in = url.openStream();
            keycodes.load(in);
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)("There was an error reading the file " + url));
        }
        return keycodes;
    }

    private static Point getLayoutOffset(LayoutFileModel layoutFile, String layoutName, File skinFilesPath) {
        int minX = 0;
        int minY = 0;
        Collection<String> partNames = layoutFile.getLayoutPartNames(layoutName);
        for (String partName : partNames) {
            if ((partName.equals("portrait") || partName.equals("landscape")) && !partName.equals(layoutName)) continue;
            Point offsetP = AndroidSkinTranslator.getPartOffset(layoutFile, partName);
            if (!layoutFile.partHasBg(partName)) continue;
            Point partSize = AndroidSkinTranslator.getPartImageSize(layoutFile, partName, skinFilesPath, offsetP);
            Point partPos = AndroidSkinTranslator.translatePartPosition(layoutFile, layoutName, partName, skinFilesPath, offsetP, partSize);
            if (partPos.x < minX) {
                minX = partPos.x;
            }
            if (partPos.y >= minY) continue;
            minY = partPos.y;
        }
        Point layoutOffset = new Point(Math.abs(minX), Math.abs(minY));
        return layoutOffset;
    }

    private static Point getPartOffset(LayoutFileModel layoutFile, String partName) {
        int minX = 0;
        int minY = 0;
        Collection<String> buttonNames = layoutFile.getButtonNames(partName);
        for (String buttonName : buttonNames) {
            Point buttonPos = layoutFile.getButtonPosition(partName, buttonName);
            if (buttonPos.x < minX) {
                minX = buttonPos.x;
            }
            if (buttonPos.y >= minY) continue;
            minY = buttonPos.y;
        }
        Point offset = new Point(Math.abs(minX), Math.abs(minY));
        return offset;
    }

    private static Point getLayoutImageSize(LayoutFileModel layoutFile, String layoutName, File skinFilesPath, Point layoutOffset) {
        int maxX = 0;
        int maxY = 0;
        Collection<String> partNames = layoutFile.getLayoutPartNames(layoutName);
        for (String partName : partNames) {
            if ((partName.equals("portrait") || partName.equals("landscape")) && !partName.equals(layoutName)) continue;
            Point offsetP = AndroidSkinTranslator.getPartOffset(layoutFile, partName);
            Point partSize = AndroidSkinTranslator.getPartImageSize(layoutFile, partName, skinFilesPath, offsetP);
            Point partPos = AndroidSkinTranslator.translatePartPosition(layoutFile, layoutName, partName, skinFilesPath, offsetP, partSize);
            if (layoutFile.isSwapWidthHeightNeededAtLayout(layoutName, partName)) {
                maxX = Math.max(maxX, layoutOffset.x + partPos.x + partSize.y);
                maxY = Math.max(maxY, layoutOffset.y + partPos.y + partSize.x);
                continue;
            }
            maxX = Math.max(maxX, layoutOffset.x + partPos.x + partSize.x);
            maxY = Math.max(maxY, layoutOffset.y + partPos.y + partSize.y);
        }
        Point imgSize = new Point(maxX, maxY);
        return imgSize;
    }

    private static Point getPartImageSize(LayoutFileModel layoutFile, String partName, File skinFilesPath, Point partOffset) {
        int bgWidth = layoutFile.getBackgroundWidth(partName, skinFilesPath);
        int bgHeight = layoutFile.getBackgroundHeight(partName, skinFilesPath);
        Point bgPos = layoutFile.getBackgroundPosition(partName);
        int maxX = partOffset.x + bgPos.x + bgWidth;
        int maxY = partOffset.y + bgPos.y + bgHeight;
        Collection<String> buttonNames = layoutFile.getButtonNames(partName);
        for (String buttonName : buttonNames) {
            int btWidth = layoutFile.getButtonWidth(partName, buttonName, skinFilesPath);
            int btHeight = layoutFile.getButtonHeight(partName, buttonName, skinFilesPath);
            Point buttonPos = layoutFile.getButtonPosition(partName, buttonName);
            maxX = Math.max(maxX, partOffset.x + buttonPos.x + btWidth);
            maxY = Math.max(maxY, partOffset.y + buttonPos.y + btHeight);
        }
        Point imgSize = new Point(maxX, maxY);
        return imgSize;
    }

    private static ImageData getImageData(LayoutFileModel layoutFile, String partName, String buttonName, File skinFilesPath) {
        File f = buttonName == null ? layoutFile.getBackgroundImage(partName, skinFilesPath) : new File(skinFilesPath, layoutFile.getButtonImage(partName, buttonName).getName());
        return new ImageData(f.getAbsolutePath());
    }

    private static ImageData generateExpandedPartImageData(LayoutFileModel layoutFile, String layoutName, String partName, Point offset, File skinFilesPath, Point partOffset, Point partSize) {
        ImageData img = null;
        if (partName != null) {
            ImageData bgImg = AndroidSkinTranslator.getImageData(layoutFile, partName, null, skinFilesPath);
            img = AndroidSkinTranslator.generateImageDataWithBackground(layoutFile, layoutName, partSize.x, partSize.y, bgImg, skinFilesPath);
            int[] row = new int[bgImg.width];
            int i = 0;
            while (i < bgImg.height) {
                bgImg.getPixels(0, i, bgImg.width, row, 0);
                img.setPixels(offset.x, offset.y + i, bgImg.width, row, 0);
                ++i;
            }
        }
        return img;
    }

    private static ImageData generateImageDataWithBackground(LayoutFileModel layoutFile, String layoutName, int width, int height, ImageData srcImg, File skinFilesPath) {
        ImageData img = new ImageData(width, height, srcImg.depth, srcImg.palette);
        RGB bgColor = layoutFile.getLayoutColor(layoutName, skinFilesPath);
        int bgPixel = srcImg.palette.getPixel(bgColor);
        int i = 0;
        while (i < img.width) {
            int j = 0;
            while (j < img.height) {
                img.setPixel(i, j, bgPixel);
                ++j;
            }
            ++i;
        }
        return img;
    }

    private static ImageData generateRotatedImage(ImageData imageToRotate, int rotation) {
        ImageData rotated;
        switch (rotation % 4) {
            case 1: {
                rotated = new ImageData(imageToRotate.height, imageToRotate.width, imageToRotate.depth, imageToRotate.palette);
                int i = 0;
                while (i < imageToRotate.width) {
                    int j = 0;
                    while (j < imageToRotate.height) {
                        rotated.setPixel(imageToRotate.height - j - 1, i, imageToRotate.getPixel(i, j));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                rotated = new ImageData(imageToRotate.width, imageToRotate.height, imageToRotate.depth, imageToRotate.palette);
                int i = 0;
                while (i < imageToRotate.width) {
                    int j = 0;
                    while (j < imageToRotate.height) {
                        rotated.setPixel(imageToRotate.width - i - 1, imageToRotate.height - j - 1, imageToRotate.getPixel(i, j));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 3: {
                rotated = new ImageData(imageToRotate.height, imageToRotate.width, imageToRotate.depth, imageToRotate.palette);
                int i = 0;
                while (i < imageToRotate.width) {
                    int j = 0;
                    while (j < imageToRotate.height) {
                        rotated.setPixel(j, imageToRotate.width - i - 1, imageToRotate.getPixel(i, j));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            default: {
                rotated = imageToRotate;
            }
        }
        return rotated;
    }

    private static ImageData generateMergedWithButtonsImage(LayoutFileModel layoutFile, ImageData baseImage, String partName, File skinFilesPath, Point partOffset, boolean isEnter) {
        Collection<String> buttonNames = layoutFile.getButtonNames(partName);
        for (String buttonName : buttonNames) {
            ImageData buttonID = AndroidSkinTranslator.getImageData(layoutFile, partName, buttonName, skinFilesPath);
            Point buttonPos = layoutFile.getButtonPosition(partName, buttonName);
            buttonPos.x += partOffset.x;
            buttonPos.y += partOffset.y;
            AndroidSkinTranslator.mergeButtonData(baseImage, buttonID, buttonPos, isEnter);
        }
        return baseImage;
    }

    private static void mergeButtonData(ImageData baseImage, ImageData buttonImage, Point buttonPos, boolean isEnter) {
        int[] baseImgPixels = new int[buttonImage.width];
        int[] buttonImgPixels = new int[buttonImage.width];
        byte[] buttonAlphas = new byte[buttonImage.width];
        int[] intButtonAlphas = new int[buttonImage.width];
        int i = 0;
        while (i < buttonImage.height) {
            baseImage.getPixels(buttonPos.x, buttonPos.y + i, buttonImage.width, baseImgPixels, 0);
            buttonImage.getPixels(0, i, buttonImage.width, buttonImgPixels, 0);
            buttonImage.getAlphas(0, i, buttonImage.width, buttonAlphas, 0);
            int j = 0;
            while (j < buttonAlphas.length) {
                intButtonAlphas[j] = buttonAlphas[j] >= 0 ? buttonAlphas[j] : (buttonAlphas[j] & 0x7F) + 128;
                ++j;
            }
            if (!isEnter) {
                j = 0;
                while (j < buttonAlphas.length) {
                    if (intButtonAlphas[j] > 0) {
                        int n = j;
                        intButtonAlphas[n] = intButtonAlphas[n] + (255 - intButtonAlphas[j]) / 4;
                    }
                    ++j;
                }
            }
            AndroidSkinTranslator.addTransparency(baseImgPixels, buttonImgPixels, intButtonAlphas, baseImage.palette, buttonImage.palette);
            baseImage.setPixels(buttonPos.x, buttonPos.y + i, buttonImage.width, baseImgPixels, 0);
            ++i;
        }
    }

    private static void addTransparency(int[] basePixels, int[] buttonPixels, int[] buttonAlphas, PaletteData basePalette, PaletteData buttonPalette) {
        int i = 0;
        while (i < buttonPixels.length) {
            RGB buttonRgb = buttonPalette.getRGB(buttonPixels[i]);
            RGB baseRgb = basePalette.getRGB(basePixels[i]);
            RGB newRgb = new RGB(AndroidSkinTranslator.calculateMerge(baseRgb.red, buttonRgb.red, buttonAlphas[i]), AndroidSkinTranslator.calculateMerge(baseRgb.green, buttonRgb.green, buttonAlphas[i]), AndroidSkinTranslator.calculateMerge(baseRgb.blue, buttonRgb.blue, buttonAlphas[i]));
            basePixels[i] = basePalette.getPixel(newRgb);
            ++i;
        }
    }

    private static int calculateMerge(int background, int foreground, int alpha) {
        return (foreground * alpha + background * (255 - alpha)) / 255;
    }

    private static Point translatePartPosition(LayoutFileModel layoutFile, String layoutName, String partName, File skinFilesPath, Point partOffset, Point partSize) {
        int bgHeight;
        int bgWidth;
        int rotation = layoutFile.getPartRotationAtLayout(layoutName, partName);
        Point partPos = layoutFile.getPartPositionAtLayout(layoutName, partName, skinFilesPath);
        if (layoutFile.partHasBg(partName)) {
            bgWidth = layoutFile.getBackgroundWidth(partName, skinFilesPath);
            bgHeight = layoutFile.getBackgroundHeight(partName, skinFilesPath);
        } else {
            bgWidth = layoutFile.getBackgroundWidth(layoutName, skinFilesPath);
            bgHeight = layoutFile.getBackgroundHeight(layoutName, skinFilesPath);
        }
        int extraOnEndW = partSize.x - bgWidth - partOffset.x;
        int extraOnEndH = partSize.y - bgHeight - partOffset.y;
        switch (rotation % 4) {
            case 1: {
                partPos.x = partPos.x - partOffset.y - bgHeight;
                partPos.y -= extraOnEndW;
                break;
            }
            case 2: {
                partPos.x -= bgWidth;
                partPos.y -= bgHeight;
                break;
            }
            case 3: {
                partPos.x -= extraOnEndH;
                partPos.y = partPos.y - partOffset.x - bgWidth;
                break;
            }
        }
        return partPos;
    }

    private static Point translateButtonPosition(LayoutFileModel layoutFile, String layoutName, String partName, String buttonName, File skinFilesPath, Point partOffset, Point partSize) {
        Point buttonPos = layoutFile.getButtonPosition(partName, buttonName);
        int buttonW = layoutFile.getButtonWidth(partName, buttonName, skinFilesPath);
        int buttonH = layoutFile.getButtonHeight(partName, buttonName, skinFilesPath);
        buttonPos = AndroidSkinTranslator.translatePartElementPosition(layoutFile, layoutName, partName, skinFilesPath, buttonPos, buttonW, buttonH, partOffset, partSize);
        return buttonPos;
    }

    private static Point translatePartElementPosition(LayoutFileModel layoutFile, String layoutName, String partName, File skinFilesPath, Point partElementPos, int partElementWidth, int partElementHeight, Point partOffset, Point partSize) {
        Point translated = new Point(0, 0);
        int rotation = layoutFile.getPartRotationAtLayout(layoutName, partName);
        Point partPos = AndroidSkinTranslator.translatePartPosition(layoutFile, layoutName, partName, skinFilesPath, partOffset, partSize);
        switch (rotation % 4) {
            case 1: {
                translated.x = partPos.x - partOffset.x + (partSize.y - partOffset.y) - partElementPos.y - partElementHeight;
                translated.y = partPos.y - partOffset.y + partOffset.x + partElementPos.x;
                break;
            }
            case 2: {
                translated.x = partPos.x + (partSize.x - partOffset.x) - partOffset.x - partElementPos.x - partElementWidth;
                translated.y = partPos.y + (partSize.y - partOffset.y) - partOffset.y - partElementPos.y - partElementHeight;
                break;
            }
            case 3: {
                translated.x = partPos.x - partOffset.x + partOffset.y + partElementPos.y;
                translated.y = partPos.y - partOffset.y + (partSize.x - partOffset.x) - partElementPos.x - partElementWidth;
                break;
            }
            default: {
                translated.x = partElementPos.x + partPos.x;
                translated.y = partElementPos.y + partPos.y;
            }
        }
        return translated;
    }
}

