/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.controls.skin;

import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.skin.AndroidSkinBean;
import org.eclipse.andmore.android.emulator.ui.controls.RemoteCLIDisplay;
import org.eclipse.andmore.android.emulator.ui.controls.UIHelper;
import org.eclipse.andmore.android.emulator.ui.controls.skin.SkinComposite;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class AndroidSkinLayout
extends Layout {
    private final AndroidSkinBean skin;
    private RemoteCLIDisplay cliDisplayChild = null;
    private SWTRemoteDisplay mainDisplayChild = null;
    private final boolean openExternalDisplayAvailable;
    private final boolean externalDisplayAvailable;
    private final boolean isFlipSupported;

    AndroidSkinLayout(AndroidSkinBean skin, boolean isFlipSupported) {
        this.skin = skin;
        this.isFlipSupported = isFlipSupported;
        this.openExternalDisplayAvailable = skin.isOpenExternalDisplayAvailable();
        this.externalDisplayAvailable = skin.isExternalDisplayAvailable();
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (!(composite instanceof SkinComposite)) {
            throw new IllegalArgumentException();
        }
        IAndroidEmulatorInstance instance = UIHelper.getInstanceAssociatedToControl((Control)composite);
        boolean flipSlideClosed = false;
        if (instance != null) {
            flipSlideClosed = false;
        }
        double zoomFactor = ((SkinComposite)composite).getZoomFactor();
        Point size = this.externalDisplayAvailable ? (this.openExternalDisplayAvailable ? (!flipSlideClosed ? this.allAvailable(zoomFactor) : this.flipClosed(zoomFactor)) : (!flipSlideClosed ? this.openExternalUnavailable(zoomFactor) : this.openExternalUnavailableAndFlipClosed(zoomFactor))) : this.onlyInternal(zoomFactor);
        return size;
    }

    private Point allAvailable(double zoomFactor) {
        int x1 = this.skin.getSkinPropertyValue("internalViewX");
        int y1 = Math.min(this.skin.getSkinPropertyValue("internalViewY"), this.skin.getSkinPropertyValue("openExternalViewY"));
        int x2 = this.skin.getSkinPropertyValue("openExternalViewX") + this.skin.getSkinPropertyValue("openExternalViewWidth");
        int y2 = Math.max(this.skin.getSkinPropertyValue("internalViewY") + this.skin.getSkinPropertyValue("internalViewHeight"), this.skin.getSkinPropertyValue("openExternalViewY") + this.skin.getSkinPropertyValue("openExternalViewHeight"));
        Point size = new Point((int)((double)(x2 - x1) * zoomFactor), (int)((double)(y2 - y1) * zoomFactor));
        return size;
    }

    private Point flipClosed(double zoomFactor) {
        Point size = new Point((int)((double)this.skin.getSkinPropertyValue("externalViewWidth") * zoomFactor), (int)((double)this.skin.getSkinPropertyValue("externalViewHeight") * zoomFactor));
        return size;
    }

    private Point openExternalUnavailable(double zoomFactor) {
        Point size = new Point((int)((double)this.skin.getSkinPropertyValue("internalViewWidth") * zoomFactor), (int)((double)this.skin.getSkinPropertyValue("internalViewHeight") * zoomFactor));
        return size;
    }

    private Point openExternalUnavailableAndFlipClosed(double zoomFactor) {
        Point size = new Point((int)((double)this.skin.getSkinPropertyValue("externalViewWidth") * zoomFactor), (int)((double)this.skin.getSkinPropertyValue("externalViewHeight") * zoomFactor));
        return size;
    }

    private Point onlyInternal(double zoomFactor) {
        Point size = new Point((int)((double)this.skin.getSkinPropertyValue("internalViewWidth") * zoomFactor), (int)((double)this.skin.getSkinPropertyValue("internalViewHeight") * zoomFactor));
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (!(composite instanceof SkinComposite)) {
            return;
        }
        boolean canProceed = true;
        if (flushCache || this.mainDisplayChild == null || this.cliDisplayChild == null) {
            Control[] children = composite.getChildren();
            canProceed = this.checkChidren(children);
        }
        if (canProceed) {
            SkinComposite skinComposite = (SkinComposite)composite;
            IAndroidEmulatorInstance instance = UIHelper.getInstanceAssociatedToControl((Control)composite);
            boolean flipSlideClosed = false;
            if (instance != null) {
                flipSlideClosed = false;
            }
            skinComposite.recalculateZoomFactor();
            skinComposite.updateDisplayRectangle();
            double zoomFactor = skinComposite.getZoomFactor();
            Rectangle displayRectangle = skinComposite.getDisplayRectangle();
            if (this.mainDisplayChild != null) {
                this.layoutMainDisplay(zoomFactor, displayRectangle);
                if (this.isFlipSupported && flipSlideClosed) {
                    this.mainDisplayChild.setVisible(false);
                } else {
                    this.mainDisplayChild.setVisible(true);
                }
            }
            if (this.cliDisplayChild != null) {
                this.layoutCliDisplay(zoomFactor, displayRectangle, flipSlideClosed);
                if (this.externalDisplayAvailable && !flipSlideClosed || this.openExternalDisplayAvailable && flipSlideClosed) {
                    this.cliDisplayChild.setVisible(true);
                } else {
                    this.cliDisplayChild.setVisible(false);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkChidren(Control[] children) {
        RemoteCLIDisplay cliDisplayInstance = null;
        SWTRemoteDisplay mainDisplayInstance = null;
        boolean childrenOk = true;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof SWTRemoteDisplay) {
                if (mainDisplayInstance != null) return false;
                this.mainDisplayChild = mainDisplayInstance = (SWTRemoteDisplay)child;
            } else {
                if (!(child instanceof RemoteCLIDisplay)) return false;
                if (cliDisplayInstance != null) return false;
                this.cliDisplayChild = cliDisplayInstance = (RemoteCLIDisplay)child;
            }
            ++n2;
        }
        return childrenOk;
    }

    private void layoutMainDisplay(double zoomFactor, Rectangle displayRectangle) {
        int x = (int)((double)this.skin.getSkinPropertyValue("internalViewX") * zoomFactor) - displayRectangle.x;
        int y = (int)((double)this.skin.getSkinPropertyValue("internalViewY") * zoomFactor) - displayRectangle.y;
        int width = (int)((double)this.skin.getSkinPropertyValue("internalViewWidth") * zoomFactor * this.skin.getEmbeddedViewScale());
        int height = (int)((double)this.skin.getSkinPropertyValue("internalViewHeight") * zoomFactor * this.skin.getEmbeddedViewScale());
        this.mainDisplayChild.setZoomFactor(zoomFactor * this.skin.getEmbeddedViewScale());
        this.mainDisplayChild.setBounds(x, y, width, height);
    }

    private void layoutCliDisplay(double zoomFactor, Rectangle displayRectangle, boolean flipSlideClosed) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (!flipSlideClosed && this.openExternalDisplayAvailable) {
            x = (int)((double)this.skin.getSkinPropertyValue("openExternalViewX") * zoomFactor) - displayRectangle.x;
            y = (int)((double)this.skin.getSkinPropertyValue("openExternalViewY") * zoomFactor) - displayRectangle.y;
            width = (int)((double)this.skin.getSkinPropertyValue("openExternalViewWidth") * zoomFactor * 0.5);
            height = (int)((double)this.skin.getSkinPropertyValue("openExternalViewHeight") * zoomFactor * 0.5);
        } else if (flipSlideClosed && this.externalDisplayAvailable) {
            x = (int)((double)this.skin.getSkinPropertyValue("externalViewX") * zoomFactor - (double)displayRectangle.x);
            y = (int)((double)this.skin.getSkinPropertyValue("externalViewY") * zoomFactor - (double)displayRectangle.y);
            width = (int)((double)this.skin.getSkinPropertyValue("externalViewWidth") * zoomFactor * 0.5);
            height = (int)((double)this.skin.getSkinPropertyValue("externalViewHeight") * zoomFactor * 0.5);
        }
        this.cliDisplayChild.setZoomFactor(zoomFactor * 0.5);
        this.cliDisplayChild.setBounds(x, y, width, height);
    }

    void dispose() {
        this.cliDisplayChild = null;
        this.mainDisplayChild = null;
    }
}

