/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.handlers;

import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.ui.handlers.IHandlerConstants;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.andmore.android.emulator.ui.view.AndroidViewData;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public abstract class AbstractZoomHandler
extends AbstractHandler
implements IHandlerConstants,
IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String viewId = event.getParameter("activeViewId");
        double zoomFactor = this.getZoomFactor(event.getParameters());
        AndmoreLogger.info((String)("Setting zoom factor for " + viewId + " = " + zoomFactor));
        IAndroidEmulatorInstance instance = AbstractAndroidView.getActiveInstance();
        if (instance != null) {
            AbstractAndroidView view;
            IViewPart viewPart = EclipseUtils.getActiveView((String)viewId);
            if (viewPart instanceof AbstractAndroidView && (view = (AbstractAndroidView)viewPart).getZoomFactor(instance) != zoomFactor) {
                view.setZoomFactor(instance, zoomFactor);
                view.updateActiveViewer();
            }
        } else {
            AndmoreLogger.error((String)"The host being presented at the viewer is not available");
            EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_AbstractZoomHandler_InstanceNotFound);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        double actualZoomFactor;
        AbstractAndroidView view;
        AndroidViewData viewData;
        IViewPart viewPart;
        boolean checked = false;
        IAndroidEmulatorInstance instance = AbstractAndroidView.getActiveInstance();
        String viewId = (String)parameters.get("activeViewId");
        if (instance != null && viewId != null && (viewPart = EclipseUtils.getActiveView((String)viewId)) instanceof AbstractAndroidView && this.testZoomFactor(viewData = (view = (AbstractAndroidView)viewPart).getViewData(instance), parameters, actualZoomFactor = view.getZoomFactor(instance))) {
            checked = true;
        }
        element.setChecked(checked);
    }

    public boolean isEnabled() {
        return AbstractAndroidView.getActiveInstance() != null;
    }

    protected abstract double getZoomFactor(Map var1);

    protected abstract boolean testZoomFactor(AndroidViewData var1, Map var2, double var3);
}

