/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.PluginUtils;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.exception.StartCancelledException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.model.IEmulatorView;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.logic.AbstractStartAndroidEmulatorLogic;
import org.eclipse.andmore.android.emulator.logic.IAndroidLogicInstance;
import org.eclipse.andmore.android.emulator.logic.StartVncServerLogic;
import org.eclipse.andmore.android.emulator.logic.stop.AndroidEmulatorStopper;
import org.eclipse.andmore.android.emulator.ui.controls.IAndroidComposite;
import org.eclipse.andmore.android.emulator.ui.controls.RemoteCLIDisplay;
import org.eclipse.andmore.android.emulator.ui.controls.nativewindow.NativeWindowComposite;
import org.eclipse.andmore.android.emulator.ui.view.AndroidViewData;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractAndroidView
extends ViewPart
implements IEmulatorView {
    private final MenuManager menuManager;
    public static final String POPUP_MENU_ID = "org.eclipse.andmore.android.emulator.view.popup";
    private MouseListener mouseClickListener;
    private static String STOP_BY_CLOSING_VIEW_KEY_PREFERENCE = "stop.by.closing.view";
    private static String SHOW_EMULATOR_IN_THE_IDE_KEY_PREFERENCE = "show.view.for.started.emulators";
    private static String STOP_ALL_EMULATORS_IN_SHUTDOWN_KEY_PREFERENCE = "stop.all.emulators.in.shutdown";
    public static final int[] SWT_EVENT_TYPES = new int[]{1, 2, 3, 4, 5, 8};
    private TabFolder tabFolder;
    Listener listener = new Listener(){

        public void handleEvent(Event event) {
            TabItem activeTabItem;
            if (AbstractAndroidView.this.tabFolder.getItemCount() > 0 && (activeTabItem = AbstractAndroidView.this.getActiveTabItem()) != null && activeTabItem.getControl() != null) {
                AndmoreLogger.info((String)("Setting focus to Android Emulator " + activeTabItem.getData()));
                activeTabItem.getControl().setFocus();
            }
        }
    };
    private final Map<IAndroidEmulatorInstance, AndroidViewData> instanceDataMap = new LinkedHashMap<IAndroidEmulatorInstance, AndroidViewData>();
    private PerspectiveListenerImpl perspectiveListenerImpl;
    private PartListenerImpl partListenerImpl;
    private static WorkbenchListenerImpl workbenchListenerImpl;
    private boolean closingOnShutdown = false;
    private static final List<String> childrenIDs;
    private static IAndroidEmulatorInstance activeInstance;
    private static final Collection<Listener> tabSwitchListeners;
    private static Lock showViewLock;

    static {
        childrenIDs = new ArrayList<String>();
        tabSwitchListeners = new ArrayList<Listener>();
        showViewLock = new ReentrantReadWriteLock().writeLock();
    }

    public static void addTabSwitchListener(Listener listener) {
        tabSwitchListeners.add(listener);
    }

    public static void removeTabSwitchListener(Listener listener) {
        tabSwitchListeners.remove(listener);
    }

    protected void handleTabSwitchEvent() {
        for (Listener listener : tabSwitchListeners) {
            listener.handleEvent(null);
        }
    }

    protected abstract String getViewId();

    protected abstract void createWidgets(TabItem var1, IAndroidEmulatorInstance var2, AndroidViewData var3) throws SkinException;

    protected abstract void refreshMenuElements();

    public static IAndroidEmulatorInstance getActiveInstance() {
        return activeInstance;
    }

    public static void setInstance(IAndroidEmulatorInstance emulatorInstance) {
        AbstractAndroidView view;
        if (!childrenIDs.isEmpty() && (view = (AbstractAndroidView)EclipseUtils.getActiveView((String)childrenIDs.get(0))) != null) {
            view.setActiveInstanceId(emulatorInstance.getInstanceIdentifier());
            activeInstance = emulatorInstance;
        }
    }

    public AndroidViewData getViewData(IAndroidEmulatorInstance instance) {
        AndroidViewData viewData = this.instanceDataMap.get(instance);
        return viewData;
    }

    public IAndroidSkin getSkin(IAndroidEmulatorInstance instance) {
        IAndroidSkin skin = null;
        AndroidViewData viewData = this.getViewData(instance);
        if (viewData != null) {
            skin = viewData.getSkin();
        }
        return skin;
    }

    public static String getPreviousOrNextLayout(String viewId, LayoutOpp opp) {
        String prevNextLayout = null;
        AbstractAndroidView view = (AbstractAndroidView)EclipseUtils.getActiveView((String)viewId);
        if (view != null) {
            prevNextLayout = view.getPreviousOrNextLayout(opp);
        }
        return prevNextLayout;
    }

    private String getPreviousOrNextLayout(LayoutOpp opp) {
        String prevNextLayout = null;
        if (activeInstance != null) {
            IAndroidSkin androidSkin;
            IAndroidComposite androidComposite;
            String referenceLayout = activeInstance.getCurrentLayout();
            AndroidViewData viewData = this.instanceDataMap.get(activeInstance);
            if (viewData != null && (androidComposite = viewData.getComposite()) != null && (androidSkin = viewData.getSkin()) != null) {
                switch (opp) {
                    case NEXT: {
                        prevNextLayout = androidSkin.getNextLayout(referenceLayout);
                    }
                }
            }
        }
        return prevNextLayout;
    }

    public static void changeLayout(String layoutName) {
        for (String viewId : childrenIDs) {
            AbstractAndroidView view = (AbstractAndroidView)EclipseUtils.getActiveView((String)viewId);
            if (view == null) continue;
            view.updateActiveViewer(layoutName);
        }
    }

    protected String getHelpId() {
        return "org.eclipse.andmore.android.emulator.emulator";
    }

    public void createPartControl(Composite parent) {
        IMenuManager menuManager;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
        this.tabFolder = new TabFolder(parent, 2056);
        IViewSite viewSite = this.getViewSite();
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractAndroidView.this.setActiveInstanceId();
                AbstractAndroidView.this.updateMenuAndToolbars();
                AbstractAndroidView.this.handleTabSwitchEvent();
            }
        });
        this.tabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AbstractAndroidView.this.handleTabSwitchEvent();
            }
        });
        this.perspectiveListenerImpl = new PerspectiveListenerImpl();
        viewSite.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.perspectiveListenerImpl);
        this.partListenerImpl = new PartListenerImpl();
        viewSite.getPage().addPartListener((IPartListener2)this.partListenerImpl);
        if (workbenchListenerImpl == null) {
            workbenchListenerImpl = new WorkbenchListenerImpl();
            viewSite.getWorkbenchWindow().getWorkbench().addWorkbenchListener((IWorkbenchListener)workbenchListenerImpl);
        }
        this.refreshView();
        IActionBars actionBars = viewSite.getActionBars();
        if (actionBars != null && (menuManager = actionBars.getMenuManager()) != null) {
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    if (manager != null) {
                        manager.update(true);
                    }
                    AbstractAndroidView.this.updateMenuAndToolbars();
                }
            });
        }
        viewSite.registerContextMenu(POPUP_MENU_ID, this.menuManager, null);
        this.mouseClickListener = Platform.getOS().contains("macosx") ? new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1 && e.stateMask == 262144) {
                    AbstractAndroidView.this.menuManager.getMenu().setVisible(true);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        } : new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    AbstractAndroidView.this.menuManager.getMenu().setVisible(true);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        };
    }

    public AbstractAndroidView() {
        childrenIDs.add(this.getViewId());
        this.menuManager = new MenuManager("", POPUP_MENU_ID);
        AbstractAndroidView.addTabSwitchListener(this.listener);
    }

    public void setFocus() {
        if (this.tabFolder.getItemCount() > 0) {
            TabItem activeTabItem = this.getActiveTabItem();
            if (activeTabItem != null && activeTabItem.getControl() != null) {
                AndmoreLogger.info((String)("Setting focus to Android Emulator " + activeTabItem.getData()));
                activeTabItem.getControl().setFocus();
            } else {
                AndmoreLogger.info((String)"Setting focus to Android Emulator View");
                this.tabFolder.setFocus();
            }
        } else {
            AndmoreLogger.info((String)"Setting focus to Android Emulator View");
            this.tabFolder.setFocus();
        }
        this.updateMenuAndToolbars();
    }

    public void dispose() {
        AbstractAndroidView.removeTabSwitchListener(this.listener);
        AndmoreLogger.debug((String)("Disposing View: " + this.getClass()));
        this.getViewSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.perspectiveListenerImpl);
        this.getViewSite().getPage().removePartListener((IPartListener2)this.partListenerImpl);
        this.perspectiveListenerImpl = null;
        this.partListenerImpl = null;
        this.instanceDataMap.clear();
        this.tabFolder.dispose();
        childrenIDs.remove(this.getViewId());
        super.dispose();
    }

    @Override
    public void refreshView() {
        Job refreshViews = new Job("Refresh Emulator View"){

            protected IStatus run(IProgressMonitor monitor) {
                AndmoreLogger.info((String)"Updating Android Emulator viewers");
                final DeviceFrameworkManager framework = DeviceFrameworkManager.getInstance();
                Collection<IAndroidEmulatorInstance> startedInstances = framework.getAllStartedInstances();
                for (final IAndroidEmulatorInstance instance : startedInstances) {
                    if (!instance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).equals("true") || instance.isConnected()) continue;
                    IStatus returnStatus = null;
                    returnStatus = AbstractAndroidView.this.connectVNC(instance, monitor);
                    if (!returnStatus.isOK()) continue;
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractAndroidView.this.createViewer(instance);
                        }
                    });
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Collection<IAndroidEmulatorInstance> connectedInstances = framework.getAllConnectedInstances();
                        Collection instancesWithViewerCollection = AbstractAndroidView.this.getInstancesWithViewer();
                        for (IAndroidEmulatorInstance instance : connectedInstances) {
                            if (!instancesWithViewerCollection.contains(instance)) {
                                AbstractAndroidView.this.createViewer(instance);
                                continue;
                            }
                            instancesWithViewerCollection.remove(instance);
                        }
                        for (IAndroidEmulatorInstance instance : instancesWithViewerCollection) {
                            AbstractAndroidView.this.disposeViewer(instance);
                            AndmoreLogger.info((String)("Disposed viewer of " + instance));
                        }
                        activeInstance = AbstractAndroidView.this.getActiveInstanceFromCurrentView();
                        if (activeInstance != null) {
                            AbstractAndroidView.this.setActiveInstanceId();
                            AbstractAndroidView.this.handleTabSwitchEvent();
                        }
                        AbstractAndroidView.this.updateMenuAndToolbars();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        refreshViews.setRule((ISchedulingRule)new RefreshRule());
        refreshViews.schedule();
    }

    public void updateActiveViewer() {
        this.updateActiveViewer(null);
    }

    public void updateActiveViewer(String layoutName) {
        IAndroidComposite androidComposite;
        AndroidViewData viewData;
        AndmoreLogger.info((String)"Updating Android Emulator view");
        if (activeInstance != null && (viewData = this.instanceDataMap.get(activeInstance)) != null && (androidComposite = viewData.getComposite()) != null) {
            IAndroidSkin androidSkin;
            if (activeInstance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).equals("true") && (androidSkin = viewData.getSkin()) != null) {
                boolean isNeeded;
                if (layoutName != null) {
                    activeInstance.setCurrentLayout(layoutName);
                }
                IRemoteDisplay.Rotation rotation = (isNeeded = androidSkin.isSwapWidthHeightNeededAtLayout(activeInstance.getCurrentLayout())) ? IRemoteDisplay.Rotation.ROTATION_90DEG_COUNTERCLOCKWISE : IRemoteDisplay.Rotation.ROTATION_0DEG;
                viewData.getMainDisplay().setRotation(rotation);
                androidComposite.applyLayout(activeInstance.getCurrentLayout());
            }
            androidComposite.applyZoomFactor();
        }
        this.updateMenuAndToolbars();
        AndmoreLogger.info((String)"Updated Android Emulator view");
    }

    public void changeToNextLayout() {
        AndroidViewData viewData = this.instanceDataMap.get(activeInstance);
        IAndroidComposite androidComposite = viewData.getComposite();
        if (androidComposite instanceof NativeWindowComposite) {
            ((NativeWindowComposite)androidComposite).changeToNextLayout();
        }
    }

    private IAndroidEmulatorInstance getActiveInstanceFromCurrentView() {
        TabItem activeInstanceItem = this.getActiveTabItem();
        IAndroidEmulatorInstance instance = null;
        if (activeInstanceItem != null) {
            instance = (IAndroidEmulatorInstance)activeInstanceItem.getData();
        } else {
            AndmoreLogger.debug((String)"No active instance being shown at emulator view");
        }
        return instance;
    }

    public IStatus connectVNC(IAndroidEmulatorInstance instance, IProgressMonitor monitor) {
        IStatus statusToReturn = Status.OK_STATUS;
        try {
            IAndroidLogicInstance logicInstance = (IAndroidLogicInstance)instance;
            AbstractStartAndroidEmulatorLogic startLogic = logicInstance.getStartLogic();
            startLogic.execute(logicInstance, AbstractStartAndroidEmulatorLogic.LogicMode.TRANSFER_AND_CONNECT_VNC, logicInstance.getTimeout(), monitor);
        }
        catch (StartCancelledException startCancelledException) {
            AndmoreLogger.info((String)"The user canceled the transfer/connect to VNC phase.");
            statusToReturn = Status.CANCEL_STATUS;
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)("Could not establish VNC Connection to " + instance));
            statusToReturn = new Status(4, "org.eclipse.andmore.android.emulator", NLS.bind((String)EmulatorNLS.ERR_CannotConnectToVNC, (Object)instance.getName()));
        }
        return statusToReturn;
    }

    private void createViewer(IAndroidEmulatorInstance instance) {
        if (instance != null) {
            AndmoreLogger.info((String)("Creating tab for " + instance + " on " + this.getClass()));
            Set<IAndroidEmulatorInstance> currentInstancesWithTab = AbstractAndroidView.getInstancesWithAtLeastOneViewer();
            TabItem newTabItem = new TabItem(this.tabFolder, 0);
            newTabItem.setText(instance.getFullName());
            newTabItem.setData((Object)instance);
            AndroidViewData emulatorData = new AndroidViewData();
            this.instanceDataMap.put(instance, emulatorData);
            try {
                IAndroidSkin skin;
                this.createWidgets(newTabItem, instance, emulatorData);
                this.tabFolder.setSelection(newTabItem);
                this.setActiveInstanceId();
                if (newTabItem.getControl() != null) {
                    this.menuManager.createContextMenu(newTabItem.getControl());
                    newTabItem.getControl().addMouseListener(this.mouseClickListener);
                }
                ProtocolMessage setEncodingMsg = new ProtocolMessage(2L);
                setEncodingMsg.setFieldValue("padding", (Object)0);
                setEncodingMsg.setFieldValue("number-of-encodings", (Object)1);
                setEncodingMsg.setFieldValue("encoding-type", "encoding-types", 0, (Object)0);
                PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)instance.getProtocolHandle(), (ProtocolMessage)setEncodingMsg);
                AndmoreLogger.info((String)("Created tab for " + instance));
                if (instance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).toString().equals("true")) {
                    this.startVncDisplays(instance);
                    AndmoreLogger.info((String)("Started displays for " + instance));
                    this.addListenersToMainDisplay(emulatorData);
                } else {
                    IAndroidComposite parentComposite = emulatorData.getComposite();
                    ((NativeWindowComposite)parentComposite).addMouseListener(this.mouseClickListener);
                }
                IAndroidComposite androidComposite = emulatorData.getComposite();
                if (androidComposite != null) {
                    androidComposite.applyZoomFactor();
                }
                if (!currentInstancesWithTab.contains(instance) && instance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).toString().equals("true") && (skin = this.getSkin(instance)) != null) {
                    instance.changeOrientation(skin.getLayoutScreenCommand(instance.getCurrentLayout()));
                }
                this.updateActiveViewer();
                AndmoreLogger.info((String)("Created tab for Android Emulator " + instance));
            }
            catch (SkinException e) {
                AndmoreLogger.error((String)("The skin associated to this instance (" + instance.getName() + ") is not installed or is corrupted."));
                EclipseUtils.showErrorDialog((AndroidException)e);
                try {
                    instance.stop(true);
                    this.disposeViewer(instance);
                }
                catch (InstanceStopException instanceStopException) {
                    AndmoreLogger.error((String)"Error while running service for stopping virtual machine");
                    EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_General_CannotRunStopService);
                }
            }
        }
    }

    private void addListenersToMainDisplay(AndroidViewData emulatorData) {
        SWTRemoteDisplay remoteDisplay = emulatorData.getMainDisplay();
        final Canvas canvas = remoteDisplay.getCanvas();
        IAndroidComposite parentComposite = emulatorData.getComposite();
        int[] nArray = SWT_EVENT_TYPES;
        int n = SWT_EVENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            Listener[] listenerArray = canvas.getListeners(eventType);
            int n3 = listenerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Listener listener = listenerArray[n4];
                canvas.removeListener(eventType, listener);
                ++n4;
            }
            ++n2;
        }
        KeyListener keyListener = parentComposite.getKeyListener();
        final MouseListener mouseListener = parentComposite.getMouseListener();
        MouseMoveListener mouseMoveListener = parentComposite.getMouseMoveListener();
        canvas.addKeyListener(keyListener);
        canvas.addMouseListener(mouseListener);
        canvas.addMouseMoveListener(mouseMoveListener);
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                canvas.removeMouseListener(mouseListener);
                canvas.removeMouseListener(AbstractAndroidView.this.mouseClickListener);
            }
        };
        emulatorData.setDisposeListener(disposeListener);
        canvas.addDisposeListener(disposeListener);
        canvas.addMouseListener(this.mouseClickListener);
    }

    private void disposeViewer(IAndroidEmulatorInstance instance) {
        AndmoreLogger.info((String)("Disposing tab of Android Emulator at " + instance));
        TabItem item = this.getTabItem(instance);
        if (item != null) {
            Control c;
            Canvas canvas;
            SWTRemoteDisplay mainDisplay;
            AndroidViewData data;
            this.stopVncDisplays(instance);
            if (childrenIDs.size() == 1 && instance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).toString().equals("true")) {
                AndmoreLogger.info((String)"There is only one view opened, stop VNC protocol and VNC Server");
                this.stopVncProtocol((IAndroidLogicInstance)instance);
                this.stopVncServer(instance);
            }
            if ((data = this.instanceDataMap.get(instance)) != null && (mainDisplay = data.getMainDisplay()) != null && (canvas = mainDisplay.getCanvas()) != null) {
                canvas.removeDisposeListener(data.getDisposeListener());
            }
            if ((c = item.getControl()) != null) {
                c.dispose();
            }
            item.setControl(null);
            item.dispose();
            this.instanceDataMap.remove(instance);
            this.updateMenuAndToolbars();
            AndmoreLogger.info((String)("Disposed tab of Android Emulator at " + instance));
        }
    }

    private Collection<IAndroidEmulatorInstance> getInstancesWithViewer() {
        LinkedHashSet<IAndroidEmulatorInstance> instancesWithViewer = new LinkedHashSet<IAndroidEmulatorInstance>();
        if (!this.tabFolder.isDisposed()) {
            TabItem[] allItems;
            TabItem[] tabItemArray = allItems = this.tabFolder.getItems();
            int n = allItems.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem item = tabItemArray[n2];
                if (!item.isDisposed()) {
                    instancesWithViewer.add((IAndroidEmulatorInstance)item.getData());
                }
                ++n2;
            }
        }
        return instancesWithViewer;
    }

    private static Set<IAndroidEmulatorInstance> getInstancesWithAtLeastOneViewer() {
        HashSet<IAndroidEmulatorInstance> instancesSet = new HashSet<IAndroidEmulatorInstance>();
        for (String viewId : childrenIDs) {
            AbstractAndroidView view = (AbstractAndroidView)EclipseUtils.getActiveView((String)viewId);
            if (view == null) continue;
            instancesSet.addAll(view.getInstancesWithViewer());
        }
        return instancesSet;
    }

    private TabItem getTabItem(IAndroidEmulatorInstance instance) {
        TabItem result = null;
        if (!this.tabFolder.isDisposed()) {
            TabItem[] allItems;
            TabItem[] tabItemArray = allItems = this.tabFolder.getItems();
            int n = allItems.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem item = tabItemArray[n2];
                if (instance.equals(item.getData())) {
                    result = item;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private TabItem getTabItem(IInstance instance) {
        TabItem result = null;
        if (!this.tabFolder.isDisposed()) {
            TabItem[] allItems;
            TabItem[] tabItemArray = allItems = this.tabFolder.getItems();
            int n = allItems.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem item = tabItemArray[n2];
                if (instance.getName().equals(((IAndroidEmulatorInstance)item.getData()).getName())) {
                    result = item;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    private TabItem getActiveTabItem() {
        int activeInstanceIndex = this.tabFolder.getSelectionIndex();
        TabItem activeTabItem = null;
        if (activeInstanceIndex >= 0) {
            activeTabItem = this.tabFolder.getItem(activeInstanceIndex);
        }
        return activeTabItem;
    }

    private void updateMenuAndToolbars() {
        IViewSite viewSite = this.getViewSite();
        if (viewSite != null) {
            IActionBars actionBars = viewSite.getActionBars();
            if (actionBars != null) {
                IMenuManager menuManager = actionBars.getMenuManager();
                this.updateMenuManager(menuManager, viewSite);
                IToolBarManager toolbarManager = actionBars.getToolBarManager();
                if (toolbarManager != null) {
                    IContributionItem[] items;
                    IContributionItem[] iContributionItemArray = items = toolbarManager.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem item = iContributionItemArray[n2];
                        item.update();
                        ++n2;
                    }
                }
            }
            this.refreshMenuElements();
        }
    }

    private void updateMenuManager(IMenuManager manager, IViewSite viewSite) {
        if (manager != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof IMenuManager) {
                    this.updateMenuManager((IMenuManager)item, viewSite);
                } else {
                    item.update();
                }
                ++n2;
            }
        }
    }

    private void stopEmulatorInstances() {
        final IRunnableWithProgress stopRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                Collection<IAndroidEmulatorInstance> startedInstances = DeviceFrameworkManager.getInstance().getAllStartedInstances();
                boolean errorsHappened = false;
                for (IAndroidEmulatorInstance instance : startedInstances) {
                    try {
                        instance.stop(true);
                    }
                    catch (InstanceStopException instanceStopException) {
                        errorsHappened = true;
                    }
                }
                if (AbstractAndroidView.this.closingOnShutdown) {
                    Job[] jobs;
                    monitor.beginTask("", -1);
                    Job[] jobArray = jobs = Job.getJobManager().find(null);
                    int n = jobs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Job job = jobArray[n2];
                        if (job.getName().equals(EmulatorNLS.UI_AbstractAndroidView_StopInstanceJob)) {
                            while (job.getResult() == null) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        ++n2;
                    }
                }
                if (errorsHappened) {
                    EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_AncroidView_CannotRunMultipleStopServices);
                }
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell currentShell = AbstractAndroidView.this.getViewSite().getShell();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(currentShell);
                try {
                    dialog.run(true, false, stopRunnable);
                }
                catch (Exception e) {
                    AndmoreLogger.error((String)("Runtime exception was thrown: " + e.getClass().getSimpleName()));
                }
            }
        });
    }

    private void setActiveInstanceId(String activeHost) {
        for (String viewId : childrenIDs) {
            Collection viewsToUpdateMenu = EclipseUtils.getAllOpenedViewsWithId((String)viewId);
            for (IViewPart view : viewsToUpdateMenu) {
                AbstractAndroidView emulatorView = (AbstractAndroidView)view;
                emulatorView.setSelection(activeHost);
            }
        }
    }

    private void setActiveInstanceId() {
        TabItem activeInstanceItem = this.getActiveTabItem();
        if (activeInstanceItem != null && activeInstanceItem.getData() != null) {
            activeInstance = (IAndroidEmulatorInstance)activeInstanceItem.getData();
            String activeId = ((IAndroidEmulatorInstance)activeInstanceItem.getData()).getInstanceIdentifier();
            this.setActiveInstanceId(activeId);
        } else {
            AndmoreLogger.debug((String)"No active instance being shown at emulator view");
        }
    }

    private void startDisplay(ProtocolHandle handle, SWTRemoteDisplay mainDisplay) {
        if (mainDisplay.isActive() && !mainDisplay.isDisposed()) {
            mainDisplay.stop();
        }
        try {
            AndmoreLogger.info((String)"Starting main display refresh");
            mainDisplay.start(handle);
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)"Viewers could not be started.");
            EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_AndroidView_ErrorStartingScreens);
            GC gc = new GC((Drawable)mainDisplay.getCanvas());
            gc.fillRectangle(0, 0, mainDisplay.getScreenWidth(), mainDisplay.getScreenHeight());
            gc.dispose();
        }
    }

    protected void startVncDisplays(IAndroidEmulatorInstance instance) {
        AndroidViewData viewData = this.instanceDataMap.get(instance);
        if (viewData != null) {
            if (viewData.getMainDisplay() != null) {
                this.startDisplay(instance.getProtocolHandle(), viewData.getMainDisplay());
            }
            if (viewData.getCliDisplay() != null && instance.getHasCli()) {
                viewData.getCliDisplay().start();
            }
        }
    }

    private void stopVncDisplays(IAndroidEmulatorInstance instance) {
        AndmoreLogger.info((String)("Stop the VNC Display " + this.getViewId() + " for " + instance));
        AndroidViewData viewData = this.instanceDataMap.get(instance);
        if (viewData != null) {
            RemoteCLIDisplay cliDisplay;
            SWTRemoteDisplay mainDisplay = viewData.getMainDisplay();
            if (mainDisplay != null && mainDisplay.isActive() && !mainDisplay.isDisposed()) {
                mainDisplay.stop();
                if (mainDisplay.getBackground() != null && !mainDisplay.getBackground().isDisposed()) {
                    mainDisplay.getBackground().dispose();
                }
            }
            if ((cliDisplay = viewData.getCliDisplay()) != null && cliDisplay.isDisplayActive() && !cliDisplay.isDisposed()) {
                cliDisplay.stop();
                if (cliDisplay.getBackground() != null && !cliDisplay.getBackground().isDisposed()) {
                    cliDisplay.getBackground().dispose();
                }
            }
        }
    }

    private void stopVncProtocol(IAndroidLogicInstance instance) {
        AndroidEmulatorStopper.stopInstance(instance, true, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private void stopVncServer(IAndroidEmulatorInstance instance) {
        StartVncServerLogic.cancelCurrentVncServerJobs(instance);
    }

    private void setSelection(final String host) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TabItem[] tabArray;
                TabItem selectedTab = null;
                TabItem[] tabItemArray = tabArray = AbstractAndroidView.this.tabFolder.getItems();
                int n = tabArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem tabItem = tabItemArray[n2];
                    String tabItemHost = ((IAndroidEmulatorInstance)tabItem.getData()).getInstanceIdentifier();
                    if (host != null && host.equals(tabItemHost)) {
                        selectedTab = tabItem;
                        break;
                    }
                    ++n2;
                }
                if (selectedTab != null) {
                    AbstractAndroidView.this.tabFolder.setSelection(selectedTab);
                    AbstractAndroidView.this.updateMenuAndToolbars();
                }
            }
        });
    }

    public static void updateInstanceName(final IInstance instance) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TabItem tabItem;
                AbstractAndroidView view;
                if (!childrenIDs.isEmpty() && (view = (AbstractAndroidView)EclipseUtils.getActiveView((String)((String)childrenIDs.get(0)))) != null && instance != null && (tabItem = view.getTabItem(instance)) != null) {
                    tabItem.setText(((IAndroidEmulatorInstance)tabItem.getData()).getFullName());
                }
            }
        });
    }

    public final void setZoomFactor(IAndroidEmulatorInstance instance, double zoom) {
        try {
            IAndroidComposite composite;
            AndroidViewData viewData = this.instanceDataMap.get(instance);
            if (viewData != null && (composite = viewData.getComposite()) != null) {
                composite.setZoomFactor(zoom);
            }
        }
        catch (Exception exception) {
            AndmoreLogger.error((String)"Detached zoom could not be set.");
        }
    }

    public final double getZoomFactor(IAndroidEmulatorInstance instance) {
        IAndroidComposite composite;
        double zoomFactor = 0.0;
        AndroidViewData viewData = this.instanceDataMap.get(instance);
        if (viewData != null && (composite = viewData.getComposite()) != null) {
            zoomFactor = composite.getZoomFactor();
        }
        return zoomFactor;
    }

    public static enum LayoutOpp {
        KEEP,
        NEXT;

    }

    private class PartListenerImpl
    implements IPartListener2 {
        private PartListenerImpl() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(final IWorkbenchPartReference partRef) {
            if (!partRef.getId().equals(AbstractAndroidView.this.getViewId())) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean openedViewsExist = false;
                    for (String viewId : childrenIDs) {
                        if (AbstractAndroidView.this.getViewId().equals(viewId) || partRef.getPage().findView(viewId) == null) continue;
                        openedViewsExist = true;
                        break;
                    }
                    Collection instances = AbstractAndroidView.this.getInstancesWithViewer();
                    for (IAndroidEmulatorInstance instance : instances) {
                        AbstractAndroidView.this.disposeViewer(instance);
                    }
                    if (!AbstractAndroidView.this.closingOnShutdown && !openedViewsExist) {
                        boolean oneInstanceStarted;
                        Collection<IAndroidEmulatorInstance> startedInstances = DeviceFrameworkManager.getInstance().getAllStartedInstances();
                        boolean bl = oneInstanceStarted = startedInstances.size() > 0;
                        if (oneInstanceStarted && DialogWithToggleUtils.showQuestion((String)STOP_BY_CLOSING_VIEW_KEY_PREFERENCE, (String)EmulatorNLS.QUESTION_AndroidView_StopAllInstancesOnDisposeTitle, (String)EmulatorNLS.QUESTION_AndroidView_StopAllInstancesOnDisposeMessage)) {
                            AbstractAndroidView.this.stopEmulatorInstances();
                        }
                    }
                }
            });
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals(AbstractAndroidView.this.getViewId())) {
                AbstractAndroidView.this.refreshView();
            }
        }
    }

    private class PerspectiveListenerImpl
    implements IPerspectiveListener {
        private PerspectiveListenerImpl() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            if (changeId.equals("viewHide") && page.findView(AbstractAndroidView.this.getViewId()) == null) {
                IPerspectiveDescriptor[] iPerspectiveDescriptorArray = page.getOpenPerspectives();
                int n = iPerspectiveDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPerspectiveDescriptor pd = iPerspectiveDescriptorArray[n2];
                    if (!pd.equals(perspective)) {
                        page.setPerspective(pd);
                    }
                    ++n2;
                }
                page.setPerspective(perspective);
            }
        }
    }

    class RefreshRule
    implements ISchedulingRule {
        RefreshRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof RefreshRule;
        }
    }

    private class WorkbenchListenerImpl
    implements IWorkbenchListener {
        private WorkbenchListenerImpl() {
        }

        public void postShutdown(IWorkbench workbench) {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            AbstractAndroidView.this.closingOnShutdown = true;
            Collection<IAndroidEmulatorInstance> startedInstances = DeviceFrameworkManager.getInstance().getAllStartedInstances();
            if (startedInstances.size() > 0) {
                boolean stopEmulatorInstances = false;
                if (PluginUtils.getOS() != 1) {
                    stopEmulatorInstances = DialogWithToggleUtils.showQuestion((String)STOP_ALL_EMULATORS_IN_SHUTDOWN_KEY_PREFERENCE, (String)EmulatorNLS.QUESTION_RunningInstancesOnClose_Title, (String)EmulatorNLS.QUESTION_RunningInstancesOnClose_Text);
                } else {
                    DialogWithToggleUtils.showWarning((String)STOP_ALL_EMULATORS_IN_SHUTDOWN_KEY_PREFERENCE, (String)EmulatorNLS.WARN_RunningInstancesOnClose_Linux_Title, (String)EmulatorNLS.WARN_RunningInstancesOnClose_Linux_Text);
                }
                if (stopEmulatorInstances) {
                    AbstractAndroidView.this.stopEmulatorInstances();
                }
            }
            return true;
        }
    }
}

