/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.view;

import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.emulator.core.exception.InstanceStopException;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.andmore.android.emulator.ui.controls.maindisplay.MainDisplayComposite;
import org.eclipse.andmore.android.emulator.ui.controls.nativewindow.NativeWindowComposite;
import org.eclipse.andmore.android.emulator.ui.controls.skin.SkinComposite;
import org.eclipse.andmore.android.emulator.ui.view.AbstractAndroidView;
import org.eclipse.andmore.android.emulator.ui.view.AndroidViewData;
import org.eclipse.andmore.android.nativeos.NativeUIUtils;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.sequoyah.vnc.vncviewer.config.VNCConfiguration;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.img.SWTRemoteDisplayImg;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocolData;
import org.eclipse.sequoyah.vnc.vncviewer.registry.VNCProtocolRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.commands.ICommandService;

public class AndroidView
extends AbstractAndroidView {
    public static final String ANDROID_VIEW_ID = "org.eclipse.andmore.android.emulator.androidView";

    @Override
    protected String getViewId() {
        return ANDROID_VIEW_ID;
    }

    @Override
    protected void createWidgets(TabItem tab, IAndroidEmulatorInstance instance, AndroidViewData tabData) throws SkinException {
        tabData.loadSkin(instance);
        IAndroidSkin skin = tabData.getSkin();
        ProtocolHandle handle = instance.getProtocolHandle();
        VNCProtocolData data = VNCProtocolRegistry.getInstance().get(handle);
        if (instance.getProperties().getProperty("UseVnc", NativeUIUtils.getDefaultUseVnc()).toString().equals("true")) {
            if (data != null) {
                if (instance.getProperties().getProperty("Command_Line").contains("-no-skin")) {
                    int baseWidth = skin.getSkinBean(instance.getCurrentLayout()).getSkinPropertyValue("internalViewWidth");
                    int baseHeight = skin.getSkinBean(instance.getCurrentLayout()).getSkinPropertyValue("internalViewHeight");
                    ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tab.getParent(), 776);
                    final MainDisplayComposite composite = new MainDisplayComposite((Composite)scrolledComposite, 8, baseWidth, baseHeight, instance);
                    composite.setLayout((Layout)new FillLayout());
                    SWTRemoteDisplay mainDisplay = this.createMainDisplay(composite, skin, instance, (ISWTPainter)data.getVncPainter());
                    composite.setSize(baseWidth, baseHeight);
                    scrolledComposite.setContent((Control)composite);
                    tab.setControl((Control)scrolledComposite);
                    scrolledComposite.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            composite.dispose();
                        }
                    });
                    tabData.setCliDisplay(null);
                    tabData.setComposite(composite);
                    tabData.setMainDisplay(mainDisplay);
                } else {
                    SkinComposite parentComposite = this.createSkinComposite((Composite)tab.getParent(), skin, instance);
                    SWTRemoteDisplay mainDisplay = this.createMainDisplay(parentComposite, skin, instance, (ISWTPainter)data.getVncPainter());
                    tabData.setComposite(parentComposite);
                    tabData.setMainDisplay(mainDisplay);
                    tab.setControl((Control)parentComposite);
                }
            } else {
                AndmoreLogger.error((String)"The protocol object set in the device instance is not supported. Stopping the emulator instance...");
                EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.ERR_AndroidView_ProtocolImplementerNotSupported);
                try {
                    instance.stop(true);
                }
                catch (InstanceStopException instanceStopException) {
                    AndmoreLogger.error((String)"Error while running service for stopping virtual machine");
                    EclipseUtils.showErrorDialog((String)EmulatorNLS.GEN_Error, (String)EmulatorNLS.EXC_General_CannotRunStopService);
                }
            }
        } else {
            NativeWindowComposite parentComposite = this.createNativeWindowComposite((Composite)tab.getParent(), skin, instance);
            tabData.setComposite(parentComposite);
            tab.setControl((Control)parentComposite);
        }
    }

    private SkinComposite createSkinComposite(Composite parent, IAndroidSkin skin, IAndroidEmulatorInstance instance) {
        SkinComposite skinComposite = new SkinComposite(parent, skin, instance);
        skinComposite.setBackground(new Color((Device)skinComposite.getDisplay(), 255, 255, 255));
        return skinComposite;
    }

    private NativeWindowComposite createNativeWindowComposite(Composite parent, IAndroidSkin skin, IAndroidEmulatorInstance instance) {
        NativeWindowComposite nativeWindowComposite = new NativeWindowComposite(parent, skin, instance);
        return nativeWindowComposite;
    }

    private SWTRemoteDisplay createMainDisplay(Composite parent, IAndroidSkin skin, IAndroidEmulatorInstance instance, ISWTPainter painter) {
        IPropertiesFileHandler handler = IAndroidSkin.DEFAULT_PROPS_HANDLER;
        String configFile = "resources/vnc_viewer.conf";
        VNCConfiguration config = new VNCConfiguration(configFile, handler);
        SWTRemoteDisplayImg mainDisplay = new SWTRemoteDisplayImg(parent, config.getConfigurationProperties(), handler, painter);
        mainDisplay.setBackground(new Color((Device)mainDisplay.getDisplay(), 0, 0, 0));
        mainDisplay.setLayout((Layout)new FillLayout());
        return mainDisplay;
    }

    @Override
    protected void refreshMenuElements() {
        IViewSite viewSite = this.getViewSite();
        ICommandService service = (ICommandService)viewSite.getService(ICommandService.class);
        service.refreshElements("org.eclipse.andmore.android.emulator.ui.change.layout", null);
        service.refreshElements("org.eclipse.andmore.android.emulator.ui.change.zoom", null);
    }
}

