/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.ui.view;

import java.io.File;
import java.util.Collection;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.exception.SkinException;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.core.skin.IAndroidSkin;
import org.eclipse.andmore.android.emulator.core.skin.SkinFramework;
import org.eclipse.andmore.android.emulator.ui.controls.IAndroidComposite;
import org.eclipse.andmore.android.emulator.ui.controls.RemoteCLIDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.swt.events.DisposeListener;

public class AndroidViewData {
    private IAndroidSkin skin;
    private SWTRemoteDisplay mainDisplay;
    private RemoteCLIDisplay cliDisplay;
    private IAndroidComposite composite;
    private DisposeListener disposeListener;

    public synchronized void loadSkin(IAndroidEmulatorInstance instance) throws SkinException {
        String skinId = instance.getSkinId();
        SkinFramework skinFw = new SkinFramework();
        File skinPath = instance.getSkinPath();
        this.skin = skinFw.getSkinById(skinId, skinPath);
        Collection<String> layoutNames = this.skin.getAvailableLayouts();
        String currentLayout = instance.getCurrentLayout();
        if (currentLayout == null && !layoutNames.isEmpty()) {
            String firstLayout = layoutNames.iterator().next();
            instance.setCurrentLayout(firstLayout);
            AndmoreLogger.debug((String)("The skin has multiple layouts. Setting " + firstLayout + " as the current one."));
        }
    }

    public synchronized IAndroidSkin getSkin() {
        return this.skin;
    }

    DisposeListener getDisposeListener() {
        return this.disposeListener;
    }

    void setDisposeListener(DisposeListener disposeListener) {
        this.disposeListener = disposeListener;
    }

    public SWTRemoteDisplay getMainDisplay() {
        return this.mainDisplay;
    }

    void setMainDisplay(SWTRemoteDisplay mainDisplay) {
        this.mainDisplay = mainDisplay;
    }

    RemoteCLIDisplay getCliDisplay() {
        return this.cliDisplay;
    }

    void setCliDisplay(RemoteCLIDisplay cliDisplay) {
        this.cliDisplay = cliDisplay;
    }

    public IAndroidComposite getComposite() {
        return this.composite;
    }

    void setComposite(IAndroidComposite composite) {
        this.composite = composite;
    }
}

