/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.nativeos.linux.gtk;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Point;
import org.osgi.framework.Bundle;

public class GtkBridge {
    private static final String EXEC = GtkBridge.getExecCommad();
    private static final String DISPLAY = GtkBridge.getDisplayNum();

    public static String getDisplayNum() {
        String display = System.getenv("DISPLAY");
        return display;
    }

    public static String getExecCommad() {
        String absoluteFile = "";
        try {
            Bundle bundle = AndroidPlugin.getDefault().getBundle();
            URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("gtk_bridge_app"), null);
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            File file = new File(fileUrl.getFile());
            absoluteFile = file.getAbsolutePath();
            AndmoreLogger.info(GtkBridge.class, (String)("Using gtk bridge app at: " + absoluteFile));
            GtkBridge.checkExecutionPermission(absoluteFile);
        }
        catch (Exception e) {
            AndmoreLogger.error(GtkBridge.class, (String)"Failed to retrieve gtk bridge app", (Throwable)e);
        }
        return absoluteFile;
    }

    private static void checkExecutionPermission(String executable) throws IOException {
        String[] command = new String[]{"chmod", "+x", executable};
        Runtime.getRuntime().exec(command);
    }

    public static synchronized String exec(String[] command) {
        String lastline;
        block37: {
            lastline = "";
            Process p = null;
            BufferedReader reader = null;
            try {
                try {
                    p = Runtime.getRuntime().exec(command);
                    reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String returnedValue = "";
                    do {
                        if ((returnedValue = reader.readLine()) == null) continue;
                        lastline = returnedValue;
                    } while (returnedValue != null);
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        AndmoreLogger.debug(GtkBridge.class, (String)("Command " + Arrays.toString(command) + " finished with error code:" + exitCode));
                    }
                }
                catch (Exception e) {
                    AndmoreLogger.error(GtkBridge.class, (String)("Failed to execute command :" + Arrays.toString(command)), (Throwable)e);
                    if (p != null) {
                        try {
                            p.getInputStream().close();
                        }
                        catch (IOException iOException) {}
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        try {
                            p.getErrorStream().close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block37;
                }
            }
            catch (Throwable throwable) {
                if (p != null) {
                    try {
                        p.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        p.getErrorStream().close();
                    }
                    catch (IOException iOException) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (p != null) {
                try {
                    p.getInputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    p.getOutputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    p.getErrorStream().close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lastline;
    }

    private static long exec_toLong(String[] command) {
        long response = 0L;
        try {
            String returnedValue = GtkBridge.exec(command);
            if (!"".equals(command)) {
                response = Long.parseLong(returnedValue);
            }
        }
        catch (Exception e) {
            AndmoreLogger.error(GtkBridge.class, (String)"Failed to execute command", (Throwable)e);
        }
        return response;
    }

    public static long getWindowHandle(String windowName) {
        AndmoreLogger.debug(GtkBridge.class, (String)("getWindowHandle " + windowName));
        String[] command = new String[]{EXEC, "getWindowHandler", DISPLAY, windowName};
        long handle = GtkBridge.exec_toLong(command);
        AndmoreLogger.debug(GtkBridge.class, (String)("getWindowHandle handle=" + handle));
        return handle;
    }

    public static long embedNativeWindow(long parentHandle, long windowHandle) {
        AndmoreLogger.debug(GtkBridge.class, (String)("embedNativeWindow parent=" + parentHandle + " window=" + windowHandle));
        String[] arguments = new String[]{EXEC, "embedWindow", DISPLAY, Long.toString(parentHandle), Long.toString(windowHandle)};
        long handle = GtkBridge.exec_toLong(arguments);
        return handle;
    }

    public static void unembedNativeWindow(long parentHandle, long formerParentHandle) {
        AndmoreLogger.debug(GtkBridge.class, (String)("unembedNativeWindow " + parentHandle));
        String[] arguments = new String[]{EXEC, "unembedWindow", DISPLAY, Long.toString(parentHandle), Long.toString(formerParentHandle)};
        GtkBridge.exec(arguments);
    }

    public static Point getWindowSize(long handle) {
        Point point;
        String[] arguments = new String[]{EXEC, "getWindowSize", DISPLAY, Long.toString(handle)};
        String size = GtkBridge.exec(arguments);
        try {
            String[] pointStr = size.split(",");
            int x = Integer.parseInt(pointStr[0]);
            int y = Integer.parseInt(pointStr[1]);
            point = new Point(x, y);
        }
        catch (Exception exception) {
            point = new Point(0, 0);
        }
        return point;
    }

    public static void pressKey(long windowHandle, int key) {
        String[] arguments = new String[]{EXEC, "pressKey", DISPLAY, Long.toString(windowHandle), Integer.toString(key)};
        GtkBridge.exec(arguments);
    }

    public static void releaseKey(long windowHandle, int key) {
        String[] arguments = new String[]{EXEC, "releaseKey", DISPLAY, Long.toString(windowHandle), Integer.toString(key)};
        GtkBridge.exec(arguments);
    }

    public static void showWindow(long windowHandle) {
        AndmoreLogger.debug(GtkBridge.class, (String)("showWindow " + windowHandle));
        String[] arguments = new String[]{EXEC, "showWindow", DISPLAY, Long.toString(windowHandle)};
        GtkBridge.exec(arguments);
    }

    public static void hideWindow(long windowHandle) {
        AndmoreLogger.debug(GtkBridge.class, (String)("hideWindow " + windowHandle));
        String[] arguments = new String[]{EXEC, "hideWindow", DISPLAY, Long.toString(windowHandle)};
        GtkBridge.exec(arguments);
    }

    public static void restoreWindow(long windowHandle) {
        AndmoreLogger.debug(GtkBridge.class, (String)("restoreWindow " + windowHandle));
        String[] arguments = new String[]{EXEC, "restoreWindow", DISPLAY, Long.toString(windowHandle)};
        GtkBridge.exec(arguments);
    }
}

