/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.collector.ui.wizard;

import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.andmore.android.logger.collector.ui.LogFileColumn;
import org.eclipse.andmore.android.logger.collector.util.LoggerCollectorMessages;
import org.eclipse.andmore.android.logger.collector.util.WidgetsFactory;
import org.eclipse.andmore.android.logger.collector.util.WidgetsUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoggerCollectorWizardPage
extends WizardPage {
    private DirectoryFieldEditor logDirecotryField = null;
    private Text filenameText = null;
    public static final String LOGGER_COLLECTOR_HELP_ID = "org.eclipse.andmore.platform.logger.collector.collectlogs";
    private LogFileColumn logFileColumn = null;
    private Button selectAll = null;
    private Button unselectAll = null;
    private Composite composite;
    private boolean userChangedWizard = false;
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            LoggerCollectorWizardPage.this.userChangedWizard = true;
            LoggerCollectorWizardPage.this.setPageComplete(LoggerCollectorWizardPage.this.isPageComplete());
            LoggerCollectorWizardPage.this.setErrorMessage(LoggerCollectorWizardPage.this.getErrorMessage());
        }
    };

    protected LoggerCollectorWizardPage(String pageName) {
        super(pageName);
        this.setTitle(LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.title"));
        this.setDescription(LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.description"));
    }

    public void createControl(Composite parent) {
        this.composite = this.getComposite(parent);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setLayoutData((Object)new GridData(1168));
        Composite compositeTop = WidgetsFactory.createComposite(this.composite, 3);
        this.logDirecotryField = new DirectoryFieldEditor("logFileNameField", String.valueOf(LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.directory")) + ":", compositeTop);
        this.logDirecotryField.getTextControl(compositeTop).addListener(24, this.listener);
        this.logDirecotryField.getTextControl(compositeTop).setTextLimit(200);
        Label filenameLabel = new Label(compositeTop, 0);
        filenameLabel.setText(LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.file"));
        GridData layoutData = new GridData(16384, 0x1000000, false, false);
        filenameLabel.setLayoutData((Object)layoutData);
        this.filenameText = new Text(compositeTop, 2048);
        layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.filenameText.setLayoutData((Object)layoutData);
        Composite compositeBottom = WidgetsFactory.createComposite(this.composite, 2);
        Label l = new Label(compositeBottom, 0);
        l.setText(LoggerCollectorMessages.getInstance().getString("logger.collector.tableview.root"));
        GridData d = new GridData(16384, 0, true, false, 2, 1);
        l.setLayoutData((Object)d);
        this.logFileColumn = new LogFileColumn(compositeBottom, 0);
        this.logFileColumn.addTableListener(13, this.listener);
        Composite buttons = new Composite(compositeBottom, 0);
        d = new GridData(0, 128, false, true, 1, 1);
        buttons.setLayoutData((Object)d);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 2;
        buttons.setLayout((Layout)layout);
        this.selectAll = new Button(buttons, 8);
        this.selectAll.setText(LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.selectAll"));
        this.selectAll.addSelectionListener((SelectionListener)new ButtonSelectionListener(true));
        this.selectAll.addListener(13, this.listener);
        this.unselectAll = new Button(buttons, 8);
        this.unselectAll.setText(LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.unselectAll"));
        this.unselectAll.addSelectionListener((SelectionListener)new ButtonSelectionListener(false));
        this.unselectAll.addListener(13, this.listener);
        this.setControl((Control)this.composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), LOGGER_COLLECTOR_HELP_ID);
        this.logDirecotryField.setStringValue(System.getProperty("user.home"));
        Calendar c = Calendar.getInstance();
        this.filenameText.setText("studio_andr_" + c.get(1) + c.get(2) + c.get(5) + c.get(10) + c.get(12) + "." + "zip");
        this.setErrorMessage(null);
    }

    protected Composite getComposite(Composite parent) {
        if (this.composite == null) {
            this.composite = WidgetsFactory.createComposite(parent);
        }
        return this.composite;
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && !WidgetsUtil.isNullOrEmpty((StringFieldEditor)this.logDirecotryField) && this.logFileColumn.hasNodeSelected();
    }

    public String getErrorMessage() {
        String message = null;
        String outputDir = Path.fromOSString((String)this.logDirecotryField.getStringValue()).toOSString();
        ArrayList<String> notFoundLogs = null;
        if (this.userChangedWizard) {
            if (WidgetsUtil.isNullOrEmpty((StringFieldEditor)this.logDirecotryField)) {
                message = LoggerCollectorMessages.getInstance().getString("error.logger.collector.directory.empty");
            } else if (!WidgetsUtil.fileExist(outputDir)) {
                message = LoggerCollectorMessages.getInstance().getString("error.logger.collector.directory.not.found");
            } else if (this.logFileColumn != null && !this.logFileColumn.hasNodeSelected()) {
                message = LoggerCollectorMessages.getInstance().getString("error.logger.collector.log.not.selected");
            } else if (this.logFileColumn != null && (notFoundLogs = this.logFileColumn.selectedLogFilesExist()).size() > 0) {
                StringBuilder messageBuilder = new StringBuilder(LoggerCollectorMessages.getInstance().getString("error.logger.collector.log.not.found"));
                messageBuilder.append(": ");
                for (String log : notFoundLogs) {
                    messageBuilder.append(log);
                    messageBuilder.append(",");
                }
                messageBuilder.deleteCharAt(messageBuilder.length() - 1);
                message = messageBuilder.toString();
            }
        }
        return message;
    }

    public LogFileColumn getLogFileColumn() {
        return this.logFileColumn;
    }

    public String getFilename() {
        Path fileName = new Path(this.filenameText.getText());
        if (fileName.getFileExtension() == null || !fileName.getFileExtension().equalsIgnoreCase("zip")) {
            fileName.addFileExtension("zip");
        }
        return new Path(this.logDirecotryField.getStringValue()).append((IPath)fileName).toOSString();
    }

    final class ButtonSelectionListener
    implements SelectionListener {
        private final boolean selectionValue;

        public ButtonSelectionListener(boolean selectionValue) {
            this.selectionValue = selectionValue;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            LoggerCollectorWizardPage.this.logFileColumn.checkAll(this.selectionValue);
        }
    }
}

