/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger;

import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.andmore.android.logger.internal.EclipseEnvironmentManager;

public class Logger {
    private static HashMap<String, Logger> pool;
    private final org.apache.log4j.Logger logger;

    static {
        EclipseEnvironmentManager envManager = new EclipseEnvironmentManager();
        envManager.logEnvironment();
    }

    private Logger(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public static synchronized Logger getLogger(String name) {
        Logger logger = null;
        if (pool == null) {
            pool = new HashMap();
        }
        if (pool.containsKey(name)) {
            logger = pool.get(name);
        } else {
            logger = new Logger(name);
            pool.put(name, logger);
        }
        return logger;
    }

    public void log(int level, String message) {
        boolean key = true;
        if (level == Integer.MAX_VALUE || level == Integer.MIN_VALUE) {
            key = false;
        }
        if (key) {
            this.logger.log((Priority)Level.toLevel((int)level), (Object)message);
        }
    }

    public void log(int level, String message, Throwable exception) {
        boolean key = true;
        if (level == Integer.MAX_VALUE || level == Integer.MIN_VALUE) {
            key = false;
        }
        if (key) {
            this.logger.log((Priority)Level.toLevel((int)level), (Object)message, exception);
        }
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable exception) {
        if (exception == null) {
            this.logger.debug((Object)message);
        } else {
            this.logger.debug((Object)message, exception);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable exception) {
        if (exception == null) {
            this.logger.info((Object)message);
        } else {
            this.logger.info((Object)message, exception);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable exception) {
        if (exception == null) {
            this.logger.warn((Object)message);
        } else {
            this.logger.warn((Object)message, exception);
        }
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable exception) {
        if (exception == null) {
            this.logger.error((Object)message);
        } else {
            this.logger.error((Object)message, exception);
        }
    }

    public void fatal(String message) {
        this.fatal(message, null);
    }

    public void fatal(String message, Throwable exception) {
        if (exception == null) {
            this.logger.fatal((Object)message);
        } else {
            this.logger.fatal((Object)message, exception);
        }
    }

    public void setLevel(int level) {
        this.logger.setLevel(Level.toLevel((int)level));
    }
}

