/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.SyncService;
import com.android.ddmuilib.SyncProgressMonitor;
import com.android.ddmuilib.handler.BaseFileHandler;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.ddms.DdmsPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class AndmoreHProfDumpHandler
extends BaseFileHandler
implements ClientData.IHprofDumpHandler {
    public static final String SAVE_ACTION = "hprof.save";
    public static final String OPEN_ACTION = "hprof.open";
    public static final String HPROF_FILE_EXTENSION = ".hprof";
    private static final String FORMATTED_ERROR_STRING = " '%1$s'.\n\n%2$s";
    private static final String FORMATTED_ERROR_STRING_2 = " '%1$s'.";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH-mm-ss";
    private String selectedApp;
    private final IProgressMonitor progressMonitor;

    public String getSelectedApp() {
        return this.selectedApp;
    }

    public void setSelectedApp(String selectedApp) {
        this.selectedApp = selectedApp;
    }

    public AndmoreHProfDumpHandler(Shell parentShell, IProgressMonitor monitor) {
        super(parentShell);
        this.progressMonitor = monitor;
    }

    protected String getDialogTitle() {
        return AndroidNLS.UI_Hprof_Handler_Dialog_Error_Title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEndFailure(final Client client, final String message) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AndmoreHProfDumpHandler.this.displayErrorFromUiThread(String.valueOf(AndroidNLS.UI_Hprof_Handler_Dialog_Unable_to_create_Hprof) + AndmoreHProfDumpHandler.FORMATTED_ERROR_STRING + AndroidNLS.UI_Hprof_Handler_Dialog_Error_Check_Log_Cat, new Object[]{client.getClientData().getClientDescription(), message != null ? String.valueOf(message) + "\n\n" : ""});
            }
        });
        Class<DDMSFacade> clazz = DDMSFacade.class;
        synchronized (DDMSFacade.class) {
            DDMSFacade.class.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(final String remoteFilePath, final Client client) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AndmoreHProfDumpHandler.this.extractRemoteHprof(remoteFilePath, client);
            }
        });
        Class<DDMSFacade> clazz = DDMSFacade.class;
        synchronized (DDMSFacade.class) {
            DDMSFacade.class.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void extractRemoteHprof(String remoteFilePath, Client client) {
        block10: {
            this.progressMonitor.beginTask(AndroidNLS.DumpHprofFile_GeneratingMemoryAnalysisOutput, 100);
            IDevice targetDevice = client.getDevice();
            try {
                try {
                    SyncService syncService = client.getDevice().getSyncService();
                    if (syncService != null) {
                        IPreferenceStore preferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
                        String actionValue = preferenceStore.getString("org.eclipse.andmore.ddms.hprofAction");
                        if (SAVE_ACTION.equals(actionValue)) {
                            this.warnAboutSaveHprofPreference();
                        }
                        if (OPEN_ACTION.equals(actionValue = preferenceStore.getString("org.eclipse.andmore.ddms.hprofAction"))) {
                            this.progressMonitor.setTaskName(AndroidNLS.DumpHprofFile_CreatingTempFile);
                            File hprofTempFile = File.createTempFile(this.selectedApp, HPROF_FILE_EXTENSION);
                            this.progressMonitor.worked(25);
                            String tempHprofFilePath = hprofTempFile.getAbsolutePath();
                            this.progressMonitor.setTaskName(AndroidNLS.DumpHprofFile_GettingFileFromRemoteDevice);
                            this.progressMonitor.worked(50);
                            syncService.pullFile(remoteFilePath, tempHprofFilePath, (SyncService.ISyncProgressMonitor)new SyncProgressMonitor(this.progressMonitor, ""));
                            this.openHprofFileInEditor(tempHprofFilePath);
                            break block10;
                        }
                        this.progressMonitor.setTaskName(AndroidNLS.DumpHprofFile_SavingFile);
                        try {
                            this.promptAndPull(syncService, String.valueOf(client.getClientData().getClientDescription()) + HPROF_FILE_EXTENSION, remoteFilePath, AndroidNLS.AndmoreHProfDumpHandler_saveHProfFile);
                        }
                        catch (Exception e) {
                            this.displayErrorFromUiThread(String.valueOf(AndroidNLS.UI_Hprof_Handler_Dialog_Unable_to_download_Hprof) + FORMATTED_ERROR_STRING, new Object[]{targetDevice.getSerialNumber(), e.getLocalizedMessage()});
                        }
                        this.progressMonitor.worked(100);
                        break block10;
                    }
                    this.displayErrorFromUiThread(String.valueOf(AndroidNLS.UI_Hprof_Handler_Dialog_Unable_to_download_Hprof) + FORMATTED_ERROR_STRING_2, new Object[]{targetDevice.getSerialNumber()});
                }
                catch (Exception exception) {
                    this.displayErrorFromUiThread(String.valueOf(AndroidNLS.UI_Hprof_Handler_Dialog_Unable_to_download_Hprof) + FORMATTED_ERROR_STRING_2, new Object[]{targetDevice.getSerialNumber()});
                    this.progressMonitor.done();
                }
            }
            finally {
                this.progressMonitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(final byte[] data, final Client client) {
        this.mParentShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AndmoreHProfDumpHandler.this.extractLocalHprof(data, client, AndmoreHProfDumpHandler.this.progressMonitor);
            }
        });
        Class<DDMSFacade> clazz = DDMSFacade.class;
        synchronized (DDMSFacade.class) {
            DDMSFacade.class.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void extractLocalHprof(byte[] data, Client client, IProgressMonitor monitor) {
        monitor.beginTask(AndroidNLS.DumpHprofFile_GeneratingMemoryAnalysisOutput, 100);
        IPreferenceStore preferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        String value = preferenceStore.getString("org.eclipse.andmore.ddms.hprofAction");
        if (SAVE_ACTION.equals(value)) {
            this.warnAboutSaveHprofPreference();
        }
        if (OPEN_ACTION.equals(value = preferenceStore.getString("org.eclipse.andmore.ddms.hprofAction"))) {
            try {
                monitor.setTaskName(AndroidNLS.DumpHprofFile_SavingTempFile);
                File tempHprofFile = this.saveTempFile(data, HPROF_FILE_EXTENSION);
                monitor.worked(50);
                monitor.setTaskName(AndroidNLS.DumpHprofFile_OpeningMemoryAnalysisFile);
                this.openHprofFileInEditor(tempHprofFile.getAbsolutePath());
                monitor.worked(50);
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                this.displayErrorFromUiThread(String.valueOf(AndroidNLS.UI_Hprof_Handler_Dialog_Unable_to_Save_Hprof_Data) + FORMATTED_ERROR_STRING_2, new Object[]{errorMsg != null ? ":\n" + errorMsg : "."});
            }
        } else {
            monitor.setTaskName(AndroidNLS.DumpHprofFile_SavingFile);
            this.promptAndSave(String.valueOf(client.getClientData().getClientDescription()) + HPROF_FILE_EXTENSION, data, AndroidNLS.UI_Hprof_Handler_Save_Prompt);
            monitor.worked(100);
        }
        monitor.done();
    }

    private void warnAboutSaveHprofPreference() {
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean openPrefPage = DialogWithToggleUtils.showQuestion((String)"org.eclipse.andmore.android.warnAboutHprofSaveAction", (String)AndroidNLS.AndmoreHProfDumpHandler_warnAboutHprofSavePrefTitle, (String)AndroidNLS.AndmoreHProfDumpHandler_warnAboutHprofSavePrefMsg);
                if (openPrefPage) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                    EclipseUtils.openPreference((Shell)ww.getShell(), (String)"org.eclipe.andmore.ddms.preferences.PreferencePage");
                }
            }
        });
    }

    private void openHprofFileInEditor(String path) throws IOException, InterruptedException, PartInitException {
        String hprofPath = this.getHProfLocalFileName(path);
        String[] commands = new String[]{DdmsPlugin.getHprofConverter(), path, hprofPath};
        Process p = Runtime.getRuntime().exec(commands);
        p.waitFor();
        IFileStore fileSystemStore = EFS.getLocalFileSystem().getStore((IPath)new Path(hprofPath));
        if (!fileSystemStore.fetchInfo().isDirectory() && fileSystemStore.fetchInfo().exists()) {
            IWorkbenchPage workbenchPage = AndroidPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = IDE.openEditorOnFileStore((IWorkbenchPage)workbenchPage, (IFileStore)fileSystemStore);
            AndroidPlugin.getDefault().getPreferenceStore().setValue(editorPart.getEditorInput().getName(), this.selectedApp);
        }
    }

    private String getHProfLocalFileName(String path) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        File ddmsPath = new File(path);
        File hprofFileHandler = new File(ddmsPath.getParent(), String.valueOf(this.selectedApp) + " " + dateFormat.format(date) + HPROF_FILE_EXTENSION);
        String hprofPath = hprofFileHandler.getAbsolutePath();
        return hprofPath;
    }
}

