/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android;

import com.android.ddmlib.FileListingService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.IDatabaseListingListener;

class FileListingReceiver
implements FileListingService.IListingReceiver {
    private final List<String> availableSegments;
    private final FileListingService service;
    private final IDatabaseListingListener listener;
    private final List<String> databases;

    public FileListingReceiver(List<String> segments, FileListingService fileListingService, IDatabaseListingListener listener) {
        this.availableSegments = segments;
        this.service = fileListingService;
        this.listener = listener;
        this.databases = new ArrayList<String>();
    }

    public void refreshEntry(FileListingService.FileEntry fileentry) {
    }

    public void setChildren(FileListingService.FileEntry fileentry, FileListingService.FileEntry[] afileentry) {
        if (this.availableSegments.size() > 0) {
            String theSegment = this.availableSegments.remove(0);
            FileListingService.FileEntry entry = fileentry.findChild(theSegment);
            if (entry != null) {
                this.service.getChildren(entry, false, (FileListingService.IListingReceiver)new FileListingReceiver(this.availableSegments, this.service, this.listener));
            } else {
                this.notifyListeners();
            }
        } else {
            FileListingService.FileEntry[] fileEntryArray = afileentry;
            int n = afileentry.length;
            int n2 = 0;
            while (n2 < n) {
                FileListingService.FileEntry entry = fileEntryArray[n2];
                this.databases.add(entry.getName());
                ++n2;
            }
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        this.listener.databasesFound(this.databases);
    }
}

