/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.perspective;

import java.net.URL;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPerspectiveFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public class AndmorePerspective
extends JavaPerspectiveFactory {
    private static String VIEW_PACKAGE_EXPLORER = "org.eclipse.jdt.ui.PackageExplorer";
    private static String VIEW_PROBLEM = "org.eclipse.ui.views.ProblemView";
    private static String VIEW_CONSOLE = "org.eclipse.ui.console.ConsoleView";
    private static String VIEW_OUTLINE = "org.eclipse.ui.views.ContentOutline";
    private static String VIEW_ANDROID_EMULATOR = "org.eclipse.andmore.android.emulator.androidView";
    private static String VIEW_SNIPPETS = "org.eclipse.wst.common.snippets.internal.ui.SnippetsView";
    private static String DDMSVIEW_EMULATOR_CONTROL = "org.eclipse.andmore.ddms.views.EmulatorControlView";
    private static String DDMSVIEW_LOGCAT = "org.eclipse.andmore.ddms.views.LogCatView";
    private static String DDMSVIEW_FILE_EXPLORER = "org.eclipse.andmore.ddms.views.FileExplorerView";
    private static String PERSPECTIVE_ANDROID = "org.eclipse.andmore.android.perspective";
    private static String PERSPECTIVE_OPHONE = "org.eclipse.andmore.android.ophone.perspective";
    private static String PERSPECTIVE_DDMS = "org.eclipse.andmore.ddms.Perspective";
    private static String PERSPECTIVE_EMULATOR = "org.eclipse.andmore.android.emulator.perspective";
    private static String PERSPECTIVE_DEBUG = "org.eclipse.debug.ui.DebugPerspective";
    private static String LAUNCH_COOLBAR_SHORTCUT = "org.eclipse.debug.ui.launchActionSet";
    private static String VIEW_TML_DEV_MGT = "org.eclipse.sequoyah.device.framework.ui.InstanceMgtView";
    private static String WIZARD_PROJECT = "org.eclipse.andmore.android.wizards.newProjectWizard";
    private static String WIZARD_WIDGET_PROJECT = "org.eclipse.andmore.android.wizards.newWidgetProjectWizard";
    private static String WIZARD_ACTIVITY = "org.eclipse.andmore.android.wizards.newActivityWizard";
    private static String WIZARD_ACTIVITY_BASED_ON_TEMPLATE = "org.eclipse.andmore.android.wizards.newActivityBasedOnTemplateWizard";
    private static String WIZARD_RECEIVER = "org.eclipse.andmore.android.wizards.newReceiverWizard";
    private static String WIZARD_SERVICE = "org.eclipse.andmore.android.wizards.newServiceWizard";
    private static String WIZARD_PROVIDER = "org.eclipse.andmore.android.wizards.newProviderWizard";
    private static String WIZARD_ANDROID_XML = "org.eclipse.andmore.eclipse.editors.wizards.NewXmlFileWizard";
    private static String WIZARD_WIDGET_PROVIDER = "org.eclipse.andmore.android.wizard.newWidgetProviderWizard";
    private static String WIZARD_JAVA_PACKAGE = "org.eclipse.jdt.ui.wizards.NewPackageCreationWizard";
    private static String WIZARD_JAVA_CLASS = "org.eclipse.jdt.ui.wizards.NewClassCreationWizard";
    private static String WIZARD_JAVA_INTERFACE = "org.eclipse.jdt.ui.wizards.NewInterfaceCreationWizard";
    private static String WIZARD_NEW_FOLDER = "org.eclipse.ui.wizards.new.folder";
    private static String VIEW_APPLICATION_SIGNING_TOOL = "org.eclipse.andmore.android.packaging.ui.signingview";
    private static final String ANDMORE_INFO_INITIAL_PAGE_PROPERTY = "andmore.android.initial.page";
    private static final String ANDMORE_INFO_INITIAL_PAGE_FILE = "andmore/index.html";
    private static IPerspectiveListener perspectiveListener = null;

    public void createInitialLayout(final IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        layout.setEditorAreaVisible(true);
        IFolderLayout left = layout.createFolder("left", 1, 0.2f, editorArea);
        left.addView(VIEW_PACKAGE_EXPLORER);
        left.addView(DDMSVIEW_FILE_EXPLORER);
        IFolderLayout leftBottom = layout.createFolder("leftBottom", 4, 0.59f, "left");
        leftBottom.addView(VIEW_SNIPPETS);
        IFolderLayout right = layout.createFolder("right", 2, 0.6f, editorArea);
        right.addView(VIEW_OUTLINE);
        IFolderLayout bottomMiddle = layout.createFolder("bottomMiddle", 4, 0.59f, editorArea);
        bottomMiddle.addView(VIEW_TML_DEV_MGT);
        bottomMiddle.addView(DDMSVIEW_LOGCAT);
        bottomMiddle.addView(VIEW_CONSOLE);
        bottomMiddle.addView(VIEW_PROBLEM);
        bottomMiddle.addView(VIEW_APPLICATION_SIGNING_TOOL);
        layout.addShowViewShortcut(VIEW_TML_DEV_MGT);
        layout.addShowViewShortcut(VIEW_SNIPPETS);
        layout.addShowViewShortcut(VIEW_APPLICATION_SIGNING_TOOL);
        layout.addPerspectiveShortcut(PERSPECTIVE_ANDROID);
        layout.addPerspectiveShortcut(PERSPECTIVE_DDMS);
        layout.addPerspectiveShortcut(PERSPECTIVE_DEBUG);
        layout.addPerspectiveShortcut(PERSPECTIVE_EMULATOR);
        layout.addActionSet(LAUNCH_COOLBAR_SHORTCUT);
        layout.addNewWizardShortcut(WIZARD_PROJECT);
        layout.addNewWizardShortcut(WIZARD_WIDGET_PROJECT);
        layout.addNewWizardShortcut(WIZARD_ACTIVITY);
        layout.addNewWizardShortcut(WIZARD_ACTIVITY_BASED_ON_TEMPLATE);
        layout.addNewWizardShortcut(WIZARD_RECEIVER);
        layout.addNewWizardShortcut(WIZARD_SERVICE);
        layout.addNewWizardShortcut(WIZARD_PROVIDER);
        layout.addNewWizardShortcut(WIZARD_WIDGET_PROVIDER);
        layout.addNewWizardShortcut(WIZARD_JAVA_PACKAGE);
        layout.addNewWizardShortcut(WIZARD_JAVA_CLASS);
        layout.addNewWizardShortcut(WIZARD_JAVA_INTERFACE);
        layout.addNewWizardShortcut(WIZARD_ANDROID_XML);
        layout.addNewWizardShortcut(WIZARD_NEW_FOLDER);
        final IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = null;
        if (activeWindow != null) {
            activePage = activeWindow.getActivePage();
            AndmorePerspective.addPerspectiveListener(activeWindow);
            this.firePerspectiveInitActions(activePage, layout);
        }
        IPageListener pageListener = new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                AndmorePerspective.this.firePerspectiveInitActions(page, layout);
                Display disp = PlatformUI.getWorkbench().getDisplay();
                final 1 thisListener = this;
                disp.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (activeWindow != null) {
                            activeWindow.removePageListener(thisListener);
                        }
                    }
                });
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        };
        if (activeWindow != null) {
            activeWindow.addPageListener(pageListener);
        }
    }

    private static synchronized void addPerspectiveListener(IWorkbenchWindow activeWindow) {
        if (perspectiveListener == null) {
            perspectiveListener = new PerspectiveAdapter(){

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
                    if (PERSPECTIVE_ANDROID.equals(perspective.getId()) && "org.eclipse.ui.internal.introview".equals(partRef.getId()) && "viewHide".equals(changeId) && 1 == page.getPartState(partRef)) {
                        page.toggleZoom(partRef);
                    }
                }
            };
            activeWindow.addPerspectiveListener(perspectiveListener);
        }
    }

    private void firePerspectiveInitActions(IWorkbenchPage activePage, IPageLayout layout) {
    }

    public static void openAndmoreInfoOnWebBrowserEditor(IWorkbenchPage page) {
        URL initialPageURL = AndmorePerspective.getWebResourcesURL();
        if (initialPageURL != null && !Platform.getOS().equals("linux")) {
            EclipseUtils.openedWebEditor((IWorkbenchPage)page, (URL)initialPageURL);
        }
    }

    public static URL getWebResourcesURL() {
        URL initialPageURL = null;
        try {
            BundleContext context = AndroidPlugin.getDefault().getBundle().getBundleContext();
            String initialPage = context.getProperty(ANDMORE_INFO_INITIAL_PAGE_PROPERTY);
            AndmoreLogger.debug(AndmorePerspective.class, (String)("Read initial page property:andmore.android.initial.page = " + initialPage));
            if (initialPage != null) {
                AndmoreLogger.debug(AndmorePerspective.class, (String)("Using the customized URL to be opened in the Web Browser Editor:" + initialPage));
                initialPageURL = new URL(initialPage);
            }
        }
        catch (Exception e) {
            AndmoreLogger.error(AndmorePerspective.class, (String)("Unable to read customized URL to be opened in the Web Browser Editor..." + e.getMessage()));
        }
        if (initialPageURL == null) {
            try {
                AndmoreLogger.debug(AndmorePerspective.class, (String)"Use the default URL to be opened in the Web Browser Editor.");
                URL installDir = Platform.getInstallLocation().getURL();
                initialPageURL = new URL(installDir, ANDMORE_INFO_INITIAL_PAGE_FILE);
            }
            catch (Exception e) {
                AndmoreLogger.error(AndmorePerspective.class, (String)("Unable to show Web Browser Editor with URL: " + e.getMessage()));
            }
        }
        return initialPageURL;
    }
}

