/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.monkey;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.wizards.elements.sorting.TableItemSortStringSetActionListener;
import org.eclipse.andmore.android.wizards.monkey.DeviceSelectionDialog;
import org.eclipse.andmore.android.wizards.monkey.MonkeyConfigurationTabTable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.framework.events.IInstanceListener;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MonkeyConfigurationTab
extends AbstractLaunchConfigurationTab {
    private MonkeyConfigurationTabTable packageTable;
    private Map<String, String> availablePackages = null;
    private static final String contextId = "org.eclipse.andmore.android.monkey";
    private final boolean filterSystem;
    private static final Object UPDATE_WIDGETS_EVENT = new Object();
    private Text countCombo = null;
    private String deviceName = "";
    private String eventCount = "";
    private Button deviceNameBrowseButton = null;
    private final Button defaultLauncherButton = null;
    private Composite mainComposite;
    private List<String> selectedPackagesPreference = null;
    private boolean firstTime = false;
    private final IInstanceListener instanceListener = new IInstanceListener(){

        private void fireUpdate() {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MonkeyConfigurationTab.this.updateDeviceChooserButton();
                    MonkeyConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            });
        }

        public void instanceUpdated(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceUnloaded(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceTransitioned(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceLoaded(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceDeleted(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceCreated(InstanceEvent instanceevent) {
            this.fireUpdate();
        }

        public void instanceAboutToTransition(InstanceEvent instanceevent) {
            this.fireUpdate();
        }
    };

    boolean isFilterSystem() {
        return this.filterSystem;
    }

    List<?> getSelectedPackagesPreference() {
        return this.selectedPackagesPreference;
    }

    void callUpdateLaunchConfigurationDialog() {
        this.updateLaunchConfigurationDialog();
    }

    private void updateDeviceChooserButton() {
        this.deviceNameBrowseButton.setEnabled(true);
    }

    public MonkeyConfigurationTab(boolean filterSystem) {
        this.filterSystem = filterSystem;
    }

    public void createControl(Composite parent) {
        Composite mainComposite;
        this.mainComposite = mainComposite = new Composite(parent, 4);
        mainComposite.setLayout((Layout)new GridLayout(3, false));
        Label deviceNameLabel = new Label(mainComposite, 0);
        deviceNameLabel.setText(AndroidNLS.UI_MonkeyComposite_DeviceNameLabel);
        GridData deviceGridData = new GridData(16384, 0x1000000, false, false);
        deviceNameLabel.setLayoutData((Object)deviceGridData);
        final Text deviceNameText = new Text(mainComposite, 2052);
        deviceNameText.setText(this.deviceName);
        deviceGridData = new GridData(4, 0x1000000, true, false, 1, 1);
        deviceNameText.setLayoutData((Object)deviceGridData);
        this.addDeviceNameTextListeners(deviceNameText);
        this.deviceNameBrowseButton = new Button(mainComposite, 8);
        deviceGridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.deviceNameBrowseButton.setLayoutData((Object)deviceGridData);
        this.deviceNameBrowseButton.setText(AndroidNLS.UI_General_BrowseButtonLabel);
        this.deviceNameBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceSelectionDialog dialog = new DeviceSelectionDialog(MonkeyConfigurationTab.this.getShell(), AndroidNLS.UI_MonkeyComposite_SelectDeviceScreenMessage);
                dialog.setTitle(AndroidNLS.UI_MonkeyComposite_SelectDeviceScreenTitle);
                dialog.setMultipleSelection(false);
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        Status status = new Status(0, "org.eclipse.andmore.android", "");
                        if (selection.length == 0) {
                            status = new Status(4, "org.eclipse.andmore.android", "No selected instance");
                        }
                        return status;
                    }
                });
                int res = dialog.open();
                if (res == 0) {
                    ISerialNumbered serialNumbered = (ISerialNumbered)dialog.getFirstResult();
                    String selectedDevice = ((IInstance)serialNumbered).getName();
                    MonkeyConfigurationTab.this.packageTable.removeAllTableItems();
                    deviceNameText.setText(selectedDevice);
                }
            }
        });
        InstanceEventManager.getInstance().addInstanceListener(this.instanceListener);
        this.packageTable = new MonkeyConfigurationTabTable(mainComposite, 67586, AndroidNLS.UninstallAppWizardPage_Loading_Applications, this);
        this.packageTable.setTableHeaderVisible(true);
        GridData layoutData = new GridData(4, 4, true, true, 3, 1);
        this.packageTable.setLayoutData(layoutData);
        TableColumn packageNameColumn = this.packageTable.addTableColumn(16384);
        this.packageTable.getTable().setSortColumn(packageNameColumn);
        this.packageTable.getTable().setSortDirection(128);
        TableColumn isSystemColumn = this.packageTable.addTableColumn(16384);
        packageNameColumn.setText(AndroidNLS.UninstallAppWizardPage_ColumnPackageName);
        isSystemColumn.setText(AndroidNLS.UninstallAppWizardPage_ColumnPackageKiind);
        packageNameColumn.setWidth(400);
        isSystemColumn.setWidth(100);
        packageNameColumn.addSelectionListener((SelectionListener)new TableItemSortStringSetActionListener());
        isSystemColumn.addSelectionListener((SelectionListener)new TableItemSortStringSetActionListener());
        this.packageTable.setTableLinesVisible(false);
        this.packageTable.pack();
        this.packageTable.redraw();
        this.packageTable.addTableSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MonkeyConfigurationTab.this.firstTime = false;
                if (MonkeyConfigurationTab.this.packageTable != null && MonkeyConfigurationTab.this.packageTable.getTableItems().length > 0 && !MonkeyConfigurationTab.this.packageTable.getTableItem(0).getText(0).contains(AndroidNLS.UninstallAppWizardPage_Loading_Applications)) {
                    MonkeyConfigurationTab.this.selectedPackagesPreference = MonkeyConfigurationTab.this.getPackageList();
                    MonkeyConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        layoutData = new GridData(0, 0x1000000, false, false, 1, 1);
        layoutData.verticalIndent = 3;
        Label label = new Label(mainComposite, 16384);
        label.setText(AndroidNLS.MonkeyWizardPage_CountCommand);
        label.setLayoutData((Object)layoutData);
        layoutData = new GridData(4, 4, true, false, 2, 1);
        layoutData.verticalIndent = 3;
        this.countCombo = new Text(mainComposite, 2116);
        this.countCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    MonkeyConfigurationTab.this.countCombo.setText(MonkeyConfigurationTab.this.eventCount);
                } else {
                    MonkeyConfigurationTab.this.eventCount = MonkeyConfigurationTab.this.countCombo.getText();
                    MonkeyConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.countCombo.setLayoutData((Object)layoutData);
        mainComposite.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                MonkeyConfigurationTab.this.countCombo.notifyListeners(24, e);
                deviceNameText.notifyListeners(24, e);
                if (MonkeyConfigurationTab.this.defaultLauncherButton != null) {
                    MonkeyConfigurationTab.this.defaultLauncherButton.notifyListeners(13, e);
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, contextId);
        this.setControl((Control)mainComposite);
    }

    private void addDeviceNameTextListeners(final Text deviceNameText) {
        deviceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.data == UPDATE_WIDGETS_EVENT) {
                    if (MonkeyConfigurationTab.this.deviceName != null && !MonkeyConfigurationTab.this.deviceName.equals(deviceNameText.getText())) {
                        MonkeyConfigurationTab.this.firstTime = true;
                    }
                    deviceNameText.setText(MonkeyConfigurationTab.this.deviceName);
                } else {
                    if (!MonkeyConfigurationTab.this.deviceName.equals(deviceNameText.getText()) || MonkeyConfigurationTab.this.firstTime) {
                        String serialNumber;
                        ISerialNumbered serialNumbered;
                        DevicesManager deviceManager;
                        MonkeyConfigurationTab.this.deviceName = deviceNameText.getText();
                        MonkeyConfigurationTab.this.packageTable.removeAllTableItems();
                        if (!MonkeyConfigurationTab.this.deviceName.equals("") && (deviceManager = DevicesManager.getInstance()) != null && (serialNumbered = deviceManager.getDeviceByName(MonkeyConfigurationTab.this.deviceName)) != null && (serialNumber = serialNumbered.getSerialNumber()) != null) {
                            MonkeyConfigurationTab.this.packageTable.removeAllTableItems();
                            if (MonkeyConfigurationTab.this.availablePackages != null) {
                                MonkeyConfigurationTab.this.availablePackages.clear();
                            }
                            MonkeyConfigurationTab.this.packageTable.populateTableAsynchronously(serialNumber);
                        }
                    }
                    MonkeyConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    private boolean validDevice(String deviceName) {
        boolean valid = false;
        ISerialNumbered sequoyahInstance = DevicesManager.getInstance().getDeviceByName(deviceName);
        if (sequoyahInstance != null && DDMSFacade.isDeviceOnline(sequoyahInstance.getSerialNumber())) {
            valid = true;
        }
        return valid;
    }

    private boolean validatePage() {
        boolean complete = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.deviceName.equals("") && !this.validDevice(this.deviceName)) {
            this.setErrorMessage(AndroidNLS.ERR_MonkeyWizardPage_Device);
            this.packageTable.removeAllTableItems();
            complete = false;
        }
        if (complete && !this.countCombo.getText().equals("")) {
            try {
                int i = Integer.parseInt(this.countCombo.getText().toString());
                if (i <= 0) {
                    complete = false;
                }
            }
            catch (Exception exception) {
                complete = false;
            }
            if (!complete) {
                String msg = NLS.bind((String)AndroidNLS.ERR_PropertiesMainComposite_Monkey_NumberMustBePositiveInteger, (Object)AndroidNLS.MonkeyWizardPage_CountCommand);
                this.setErrorMessage(msg);
            }
        }
        if (complete) {
            if (this.deviceName.equals("")) {
                this.setMessage(AndroidNLS.UI_MonkeyComposite_SelectDeviceScreenMessage);
                complete = false;
            } else if (this.packageTable != null && this.packageTable.getTableSelectionCount() <= 0) {
                this.setMessage(AndroidNLS.ERR_MonkeyWizardPage_Package);
                complete = false;
            } else if (this.countCombo.getText().equals("")) {
                this.setMessage(AndroidNLS.ERR_MonkeyWizardPage_CountCommand);
                complete = false;
            }
        }
        return complete;
    }

    public String getCount() {
        return this.countCombo.getText().toString();
    }

    public List<String> getPackageList() {
        ArrayList<String> selectedPackages = new ArrayList<String>();
        if (this.packageTable != null) {
            TableItem[] tableItemArray = this.packageTable.getTableSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                selectedPackages.add(item.getText(0));
                ++n2;
            }
        }
        return selectedPackages;
    }

    public String getName() {
        return AndroidNLS.UI_MonkeyComposite_TabMainName;
    }

    public Image getImage() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android", (String)"icons/monkey/monkey_16.png").createImage();
    }

    public void dispose() {
        InstanceEventManager.getInstance().removeInstanceListener(this.instanceListener);
        super.dispose();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.firstTime = this.deviceName.equals("");
            this.deviceName = configuration.getAttribute("org.eclipse.andmore.android.monkey.instanceName", "");
            this.eventCount = configuration.getAttribute("", "50");
            List defaultValue = null;
            this.selectedPackagesPreference = configuration.getAttribute("org.eclipse.andmore.android.monkey.selectedPackages", defaultValue);
            if (this.packageTable != null && this.packageTable.getTableItems().length > 0 && !this.packageTable.getTableItem(0).getText(0).contains(AndroidNLS.UninstallAppWizardPage_Loading_Applications)) {
                List<String> selectedPackages = this.getPackageList();
                if (this.selectedPackagesPreference == null || !this.selectedPackagesPreference.containsAll(selectedPackages)) {
                    this.packageTable.deselectAllTableItems();
                    if (this.selectedPackagesPreference != null) {
                        TableItem[] itemsP = new TableItem[this.selectedPackagesPreference.size()];
                        int i = 0;
                        TableItem[] tableItemArray = this.packageTable.getTableItems();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem item = tableItemArray[n2];
                            if (this.selectedPackagesPreference.contains(item.getText(0))) {
                                itemsP[i] = item;
                                ++i;
                            }
                            ++n2;
                        }
                        this.packageTable.setTableSelection(itemsP);
                    }
                }
            }
            Event e = new Event();
            e.type = 24;
            e.data = UPDATE_WIDGETS_EVENT;
            this.mainComposite.notifyListeners(24, e);
        }
        catch (CoreException e) {
            AndmoreLogger.error(MonkeyConfigurationTab.class, (String)("Failed to initialize Monkey Launch Configuration:" + e.getMessage()));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.andmore.android.monkey.instanceName", this.deviceName);
        configuration.setAttribute("", this.eventCount);
        configuration.setAttribute("org.eclipse.andmore.android.monkey.selectedPackages", this.selectedPackagesPreference);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.andmore.android.monkey.instanceName", "");
        configuration.setAttribute("", "50");
        List defaultValue = null;
        configuration.setAttribute("org.eclipse.andmore.android.monkey.selectedPackages", defaultValue);
        if (this.mainComposite != null) {
            Event e = new Event();
            e.type = 24;
            e.data = UPDATE_WIDGETS_EVENT;
            this.mainComposite.notifyListeners(24, e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.validatePage();
    }
}

