/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.widget;

import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.andmore.android.wizards.elements.ApplicationGroup;
import org.eclipse.andmore.android.wizards.elements.ProjectNameGroup;
import org.eclipse.andmore.android.wizards.elements.SdkTargetSelector;
import org.eclipse.andmore.android.wizards.elements.WidgetLocationGroup;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class NewAndroidWidgetProjectMainPage
extends WizardPage {
    private static final String PAGE_NAME = "Main Page";
    private final AndroidProject project;
    private final String NEW_WIDGET_PROJECT_HELP = "org.eclipse.andmore.android.newwdgproj";
    private final Listener modelListener = new Listener(){

        public void handleEvent(Event arg0) {
            int msgType;
            IStatus status = NewAndroidWidgetProjectMainPage.this.project.getStatus();
            int severity = status.getSeverity();
            NewAndroidWidgetProjectMainPage.this.setPageComplete(severity != 4);
            switch (severity) {
                case 0: {
                    msgType = 0;
                    break;
                }
                case 4: {
                    msgType = 3;
                    break;
                }
                case 2: {
                    msgType = 2;
                    break;
                }
                default: {
                    msgType = 0;
                }
            }
            String defaultMessage = AndroidNLS.UI_NewAndroidWidgetProjectMainPage_SubtitleCreateProject;
            NewAndroidWidgetProjectMainPage.this.setMessage(status.isOK() ? defaultMessage : status.getMessage(), msgType);
        }
    };

    public NewAndroidWidgetProjectMainPage(AndroidProject project) {
        super(PAGE_NAME);
        this.project = project;
        this.setTitle(AndroidNLS.UI_NewAndroidWidgetProjectMainPage_TitleCreateProject);
        this.setDescription(AndroidNLS.UI_NewAndroidWidgetProjectMainPage_WizardProjectDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ProjectNameGroup projectNameGroup = new ProjectNameGroup(composite, this.project);
        projectNameGroup.setLayoutData(new GridData(4, 0, true, false));
        Group groupForLocation = new Group(composite, 16);
        groupForLocation.setLayout((Layout)new GridLayout());
        groupForLocation.setLayoutData((Object)new GridData(4, 0, true, false));
        groupForLocation.setFont(composite.getFont());
        groupForLocation.setText(AndroidNLS.UI_NewAndroidWidgetProjectMainPage_LabelContents);
        WidgetLocationGroup locationGroup = new WidgetLocationGroup((Composite)groupForLocation, this.project, this);
        Group groupForTarget = new Group(composite, 16);
        groupForTarget.setLayout((Layout)new GridLayout());
        groupForTarget.setLayoutData((Object)new GridData(4, 4, true, true));
        groupForTarget.setFont(composite.getFont());
        groupForTarget.setText(AndroidNLS.UI_NewAndroidProjectMainPage_LabelTarget);
        SdkTargetSelector mSdkTargetSelector = new SdkTargetSelector((Composite)groupForTarget, this.project);
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        group.setFont(composite.getFont());
        group.setText(AndroidNLS.UI_NewAndroidProjectMainPage_LabelApplication);
        final ApplicationGroup applicationGroup = new ApplicationGroup((Composite)group, this.project);
        Listener listener = new Listener(){

            public void handleEvent(Event arg0) {
                applicationGroup.updateDefaultName();
                applicationGroup.updateMinSdkVersion();
                NewAndroidWidgetProjectMainPage.this.getContainer().updateButtons();
            }
        };
        projectNameGroup.addListener(1546, this.modelListener);
        projectNameGroup.addListener(1546, listener);
        locationGroup.addListener(1546, listener);
        locationGroup.addListener(1546, this.modelListener);
        applicationGroup.addListener(1546, this.modelListener);
        mSdkTargetSelector.addListener(1546, this.modelListener);
        mSdkTargetSelector.addListener(1546, listener);
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        projectNameGroup.forceFocus();
        this.setControl((Control)composite);
        composite.layout(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.newwdgproj");
    }

    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

