/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace;

import java.io.IOException;
import java.text.DecimalFormat;
import org.eclipse.andmore.gltrace.TraceCommandWriter;
import org.eclipse.andmore.gltrace.TraceFileWriter;
import org.eclipse.andmore.gltrace.TraceOptions;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class GLTraceCollectorDialog
extends TitleAreaDialog {
    private static final String TITLE = "OpenGL ES Trace";
    private static final String DEFAULT_MESSAGE = "Trace collection in progress.";
    private static final DecimalFormat SIZE_FORMATTER = new DecimalFormat("#.##");
    private TraceOptions mTraceOptions;
    private final TraceFileWriter mTraceFileWriter;
    private final TraceCommandWriter mTraceCommandWriter;
    private Label mFramesCollectedLabel;
    private Label mTraceFileSizeLabel;
    private StatusRefreshTask mRefreshTask;

    protected GLTraceCollectorDialog(Shell parentShell, TraceFileWriter traceFileWriter, TraceCommandWriter traceCommandWriter, TraceOptions traceOptions) {
        super(parentShell);
        this.mTraceFileWriter = traceFileWriter;
        this.mTraceCommandWriter = traceCommandWriter;
        this.mTraceOptions = traceOptions;
    }

    protected Control createButtonBar(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(0, false));
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 2;
        c.setLayoutData((Object)gd);
        this.createButton(c, 0, "Stop Tracing", true);
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Group controlGroup = new Group(parent, 2048);
        controlGroup.setLayout((Layout)new GridLayout(2, false));
        controlGroup.setLayoutData((Object)new GridData(768));
        controlGroup.setForeground(Display.getDefault().getSystemColor(9));
        controlGroup.setText("Trace Options");
        this.createLabel((Composite)controlGroup, "Collect Framebuffer contents on eglSwapBuffers()");
        final Button eglSwapCheckBox = this.createButton((Composite)controlGroup, this.mTraceOptions.collectFbOnEglSwap);
        this.createLabel((Composite)controlGroup, "Collect Framebuffer contents on glDraw*()");
        final Button glDrawCheckBox = this.createButton((Composite)controlGroup, this.mTraceOptions.collectFbOnGlDraw);
        this.createLabel((Composite)controlGroup, "Collect texture data for glTexImage*()");
        final Button glTexImageCheckBox = this.createButton((Composite)controlGroup, this.mTraceOptions.collectTextureData);
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean eglSwap = eglSwapCheckBox.getSelection();
                boolean glDraw = glDrawCheckBox.getSelection();
                boolean glTexImage = glTexImageCheckBox.getSelection();
                try {
                    GLTraceCollectorDialog.this.mTraceCommandWriter.setTraceOptions(eglSwap, glDraw, glTexImage);
                }
                catch (IOException e) {
                    eglSwapCheckBox.setEnabled(false);
                    glDrawCheckBox.setEnabled(false);
                    glTexImageCheckBox.setEnabled(false);
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)GLTraceCollectorDialog.TITLE, (String)("Error while setting trace options: " + e.getMessage()));
                }
                if (!(event.getSource() instanceof Button)) {
                    return;
                }
                Button sourceButton = (Button)event.getSource();
                sourceButton.setText(GLTraceCollectorDialog.this.getToggleActionText(sourceButton.getSelection()));
                sourceButton.pack();
            }
        };
        eglSwapCheckBox.addSelectionListener((SelectionListener)l);
        glDrawCheckBox.addSelectionListener((SelectionListener)l);
        glTexImageCheckBox.addSelectionListener((SelectionListener)l);
        Group statusGroup = new Group(parent, 0);
        statusGroup.setLayout((Layout)new GridLayout(2, false));
        statusGroup.setLayoutData((Object)new GridData(768));
        statusGroup.setForeground(Display.getDefault().getSystemColor(9));
        statusGroup.setText("Trace Status");
        this.createLabel((Composite)statusGroup, "Frames Collected:");
        this.mFramesCollectedLabel = this.createLabel((Composite)statusGroup, "");
        this.createLabel((Composite)statusGroup, "Trace File Size:");
        this.mTraceFileSizeLabel = this.createLabel((Composite)statusGroup, "");
        ProgressBar pb = new ProgressBar((Composite)statusGroup, 2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        pb.setLayoutData((Object)gd);
        this.mRefreshTask = new StatusRefreshTask();
        new Thread((Runnable)this.mRefreshTask, "Trace Status Refresh Thread").start();
        return super.createDialogArea(parent);
    }

    private Button createButton(Composite controlComposite, boolean selection) {
        Button b = new Button(controlComposite, 2);
        b.setText(this.getToggleActionText(selection));
        b.setSelection(selection);
        return b;
    }

    private String getToggleActionText(boolean en) {
        return en ? "Disable" : "Enable";
    }

    private Label createLabel(Composite parent, String text) {
        Label l = new Label(parent, 0);
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        l.setLayoutData((Object)gd);
        return l;
    }

    protected void okPressed() {
        this.mRefreshTask.cancel();
        super.okPressed();
    }

    static /* synthetic */ TraceFileWriter access$0(GLTraceCollectorDialog gLTraceCollectorDialog) {
        return gLTraceCollectorDialog.mTraceFileWriter;
    }

    static /* synthetic */ DecimalFormat access$1() {
        return SIZE_FORMATTER;
    }

    private class StatusRefreshTask
    implements Runnable {
        private static final int REFRESH_INTERVAL = 1000;
        private volatile boolean mIsCancelled = false;

        private StatusRefreshTask() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (GLTraceCollectorDialog.access$0(GLTraceCollectorDialog.this) != null) ** GOTO lbl12
            return;
lbl-1000:
            // 1 sources

            {
                frameCount = Integer.toString(GLTraceCollectorDialog.access$0(GLTraceCollectorDialog.this).getCurrentFrameCount());
                fileSize = GLTraceCollectorDialog.access$0(GLTraceCollectorDialog.this).getCurrentFileSize();
                frameSize = String.valueOf(GLTraceCollectorDialog.access$1().format(fileSize /= 1048576.0)) + " MB";
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (GLTraceCollectorDialog.this.mFramesCollectedLabel.isDisposed()) {
                            return;
                        }
                        GLTraceCollectorDialog.this.mFramesCollectedLabel.setText(frameCount);
                        GLTraceCollectorDialog.this.mTraceFileSizeLabel.setText(frameSize);
                        GLTraceCollectorDialog.this.mFramesCollectedLabel.pack();
                        GLTraceCollectorDialog.this.mTraceFileSizeLabel.pack();
                    }
                });
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException v0) {
                    return;
                }
lbl12:
                // 2 sources

                ** while (!this.mIsCancelled)
            }
lbl13:
            // 1 sources

        }

        public void cancel() {
            this.mIsCancelled = true;
        }
    }
}

