/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenGLTraceAction
implements IWorkbenchWindowActionDelegate {
    private static String sLoadFromFolder = System.getProperty("user.home");

    public void run(IAction action) {
        this.openTrace();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    private void openTrace() {
        Shell shell = Display.getDefault().getActiveShell();
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText("Open Trace File");
        fd.setFilterPath(sLoadFromFolder);
        fd.setFilterExtensions(new String[]{"*.gltrace"});
        String fname = fd.open();
        if (fname == null || fname.trim().length() == 0) {
            return;
        }
        sLoadFromFolder = new File(fname).getParent().toString();
        this.openEditorFor(fname);
    }

    private void openEditorFor(String fname) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(fname));
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error opening GL Trace File", (String)("Unexpected error while opening GL Trace file: " + e.getMessage()));
        }
    }
}

