/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.andmore.gltrace.GLProtoBuf;
import org.eclipse.andmore.gltrace.model.GLCall;
import org.eclipse.andmore.gltrace.model.GLTrace;

public class GLCallGroups {
    public static List<GLCallNode> constructCallHierarchy(GLTrace trace, int start, int end, int contextToGroup) {
        if (trace == null) {
            return Collections.emptyList();
        }
        if (contextToGroup < 0 || contextToGroup > trace.getContexts().size()) {
            return GLCallGroups.flatHierarchy(trace, start, end);
        }
        List<GLCall> calls = trace.getGLCalls();
        Stack<GLTreeNode> hierarchyStack = new Stack<GLTreeNode>();
        ArrayList<GLCallNode> items = new ArrayList<GLCallNode>();
        int i = start;
        while (i < end) {
            GLCall c = calls.get(i);
            if (c.getContextId() == contextToGroup) {
                if (c.getFunction() == GLProtoBuf.GLMessage.Function.glPushGroupMarkerEXT) {
                    GLTreeNode group = new GLTreeNode(c);
                    if (hierarchyStack.size() > 0) {
                        ((GLTreeNode)hierarchyStack.peek()).addChild(group);
                    } else {
                        items.add(group);
                    }
                    hierarchyStack.push(group);
                } else if (c.getFunction() == GLProtoBuf.GLMessage.Function.glPopGroupMarkerEXT) {
                    if (hierarchyStack.size() > 0) {
                        hierarchyStack.pop();
                    } else {
                        items.add(new GLLeafNode(c));
                    }
                } else {
                    GLLeafNode leaf = new GLLeafNode(c);
                    if (hierarchyStack.size() > 0) {
                        ((GLTreeNode)hierarchyStack.peek()).addChild(leaf);
                    } else {
                        items.add(leaf);
                    }
                }
            }
            ++i;
        }
        return items;
    }

    private static List<GLCallNode> flatHierarchy(GLTrace trace, int start, int end) {
        ArrayList<GLCallNode> items = new ArrayList<GLCallNode>();
        List<GLCall> calls = trace.getGLCalls();
        int i = start;
        while (i < end) {
            items.add(new GLLeafNode(calls.get(i)));
            ++i;
        }
        return items;
    }

    public static interface GLCallNode {
        public boolean hasChildren();

        public List<GLCallNode> getChildren();

        public GLCall getCall();

        public GLCallNode getParent();

        public void setParent(GLCallNode var1);
    }

    private static class GLLeafNode
    implements GLCallNode {
        private final GLCall mCall;
        private GLCallNode mParent;

        public GLLeafNode(GLCall call) {
            this.mCall = call;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        @Override
        public List<GLCallNode> getChildren() {
            return null;
        }

        @Override
        public GLCallNode getParent() {
            return this.mParent;
        }

        @Override
        public void setParent(GLCallNode parent) {
            this.mParent = parent;
        }

        @Override
        public GLCall getCall() {
            return this.mCall;
        }
    }

    private static class GLTreeNode
    implements GLCallNode {
        private final GLCall mCall;
        private GLCallNode mParent;
        private List<GLCallNode> mGLCallNodes;

        public GLTreeNode(GLCall call) {
            this.mCall = call;
            this.mGLCallNodes = new ArrayList<GLCallNode>();
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public GLCallNode getParent() {
            return this.mParent;
        }

        @Override
        public void setParent(GLCallNode parent) {
            this.mParent = parent;
        }

        @Override
        public List<GLCallNode> getChildren() {
            return this.mGLCallNodes;
        }

        public void addChild(GLCallNode n) {
            this.mGLCallNodes.add(n);
            n.setParent(this);
        }

        @Override
        public GLCall getCall() {
            return this.mCall;
        }
    }
}

