/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state;

import org.eclipse.andmore.gltrace.state.DisplayRadix;
import org.eclipse.andmore.gltrace.state.GLAbstractAtomicProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;

public class GLIntegerProperty
extends GLAbstractAtomicProperty {
    private final Integer mDefaultValue;
    private Integer mCurrentValue;
    private final DisplayRadix mRadix;

    public GLIntegerProperty(GLStateType name, Integer defaultValue, DisplayRadix radix) {
        super(name);
        this.mDefaultValue = this.mCurrentValue = defaultValue;
        this.mRadix = radix;
    }

    public GLIntegerProperty(GLStateType name, Integer defaultValue) {
        this(name, defaultValue, DisplayRadix.DECIMAL);
    }

    @Override
    public boolean isDefault() {
        return this.mDefaultValue != null & this.mDefaultValue.equals(this.mCurrentValue);
    }

    public void setValue(Integer newValue) {
        this.mCurrentValue = newValue;
    }

    @Override
    public String getStringValue() {
        if (this.mRadix == DisplayRadix.HEX) {
            return String.format("0x%08x", (int)this.mCurrentValue);
        }
        return this.mCurrentValue.toString();
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "=" + this.getStringValue();
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Attempt to set non-integer value for " + (Object)((Object)this.getType()));
        }
        this.mCurrentValue = (Integer)value;
    }

    @Override
    public Object getValue() {
        return this.mCurrentValue;
    }
}

