/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state;

import com.android.utils.SparseArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.andmore.gltrace.state.GLStateType;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.state.StatePrettyPrinter;

public class GLSparseArrayProperty
implements IGLProperty {
    private final GLStateType mType;
    private final IGLProperty mDefaultValue;
    private final boolean mCreateOnAccess;
    private final SparseArray<IGLProperty> mSparseArray;
    private IGLProperty mParent;

    public GLSparseArrayProperty(GLStateType type, IGLProperty defaultValue) {
        this(type, defaultValue, false);
    }

    public GLSparseArrayProperty(GLStateType type, IGLProperty defaultValue, boolean createOnAccess) {
        this.mType = type;
        this.mDefaultValue = defaultValue;
        this.mCreateOnAccess = createOnAccess;
        this.mSparseArray = new SparseArray(20);
    }

    private GLSparseArrayProperty(GLStateType type, IGLProperty defaultValue, boolean createOnAccess, SparseArray<IGLProperty> contents) {
        this.mType = type;
        this.mDefaultValue = defaultValue;
        this.mCreateOnAccess = createOnAccess;
        this.mSparseArray = contents;
    }

    public List<IGLProperty> getValues() {
        ArrayList<IGLProperty> values = new ArrayList<IGLProperty>(this.mSparseArray.size());
        int i = 0;
        while (i < this.mSparseArray.size()) {
            values.add((IGLProperty)this.mSparseArray.valueAt(i));
            ++i;
        }
        return values;
    }

    public IGLProperty getProperty(int key) {
        IGLProperty p = (IGLProperty)this.mSparseArray.get(key);
        if (p == null && this.mCreateOnAccess) {
            this.add(key);
            p = (IGLProperty)this.mSparseArray.get(key);
        }
        return p;
    }

    public int keyFor(IGLProperty element) {
        int index = this.mSparseArray.indexOfValue((Object)element);
        return this.mSparseArray.keyAt(index);
    }

    public void put(int key, IGLProperty element) {
        element.setParent(this);
        this.mSparseArray.put(key, (Object)element);
    }

    public void add(int key) {
        IGLProperty prop = this.mDefaultValue.clone();
        prop.setParent(this);
        this.mSparseArray.put(key, (Object)prop);
    }

    public void delete(int key) {
        this.mSparseArray.delete(key);
    }

    @Override
    public GLStateType getType() {
        return this.mType;
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public IGLProperty getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(IGLProperty parent) {
        this.mParent = parent;
    }

    @Override
    public GLSparseArrayProperty clone() {
        SparseArray copy = new SparseArray(this.mSparseArray.size());
        int i = 0;
        while (i < this.mSparseArray.size()) {
            int key = this.mSparseArray.keyAt(i);
            IGLProperty value = (IGLProperty)this.mSparseArray.get(key);
            copy.put(key, (Object)value);
            ++i;
        }
        return new GLSparseArrayProperty(this.mType, this.mDefaultValue, this.mCreateOnAccess, (SparseArray<IGLProperty>)copy);
    }

    @Override
    public String getStringValue() {
        return "";
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("Values cannot be set for composite properties.");
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("Values cannot be obtained for composite properties.");
    }

    @Override
    public void prettyPrint(StatePrettyPrinter pp) {
        pp.prettyPrint(this.mType, null);
        pp.incrementIndentLevel();
        int i = 0;
        while (i < this.mSparseArray.size()) {
            int key = this.mSparseArray.keyAt(i);
            pp.prettyPrint(String.format(Locale.US, "Index %d:", key));
            IGLProperty prop = (IGLProperty)this.mSparseArray.get(key);
            assert (prop != null);
            if (prop != null) {
                prop.prettyPrint(pp);
            }
            ++i;
        }
        pp.decrementIndentLevel();
    }
}

