/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state;

import org.eclipse.andmore.gltrace.state.GLAbstractAtomicProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;

public class GLStringProperty
extends GLAbstractAtomicProperty {
    private final String mDefaultValue;
    private String mCurrentValue;

    public GLStringProperty(GLStateType type, String defaultValue) {
        super(type);
        this.mDefaultValue = this.mCurrentValue = defaultValue;
    }

    @Override
    public boolean isDefault() {
        return this.mDefaultValue.equalsIgnoreCase(this.mCurrentValue);
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Attempt to set non-string value for " + (Object)((Object)this.getType()));
        }
        this.mCurrentValue = (String)value;
    }

    public void setValue(String value) {
        this.mCurrentValue = value;
    }

    @Override
    public Object getValue() {
        return this.mCurrentValue;
    }

    @Override
    public String getStringValue() {
        return this.mCurrentValue;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "=" + this.getStringValue();
    }
}

