/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state.transforms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.gltrace.state.GLCompositeProperty;
import org.eclipse.andmore.gltrace.state.GLListProperty;
import org.eclipse.andmore.gltrace.state.GLSparseArrayProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.state.transforms.IGLPropertyAccessor;

public class GLPropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final List<GLPropertyExtractor> mExtractors;

    private GLPropertyAccessor(int contextId, List<GLPropertyExtractor> extractors) {
        this.mContextId = contextId;
        this.mExtractors = extractors;
    }

    @Override
    public IGLProperty getProperty(IGLProperty state) {
        IGLProperty root = ((GLListProperty)state).get(this.mContextId);
        for (GLPropertyExtractor e : this.mExtractors) {
            IGLProperty successor = e.getProperty(root);
            if (successor == null) {
                root = null;
                break;
            }
            root = successor;
        }
        return root;
    }

    public static IGLPropertyAccessor makeAccessor(int contextId, Object ... accessors) {
        ArrayList<GLPropertyExtractor> extractors = new ArrayList<GLPropertyExtractor>();
        Object[] objectArray = accessors;
        int n = accessors.length;
        int n2 = 0;
        while (n2 < n) {
            Object accessor = objectArray[n2];
            if (accessor instanceof GLStateType) {
                extractors.add(new GLNamePropertyExtractor((GLStateType)((Object)accessor)));
            } else if (accessor instanceof Integer) {
                extractors.add(new GLIndexPropertyExtractor((Integer)accessor));
            } else {
                throw new IllegalArgumentException("Unknown property (" + accessor + ") used to access members of IGLProperty");
            }
            ++n2;
        }
        return new GLPropertyAccessor(contextId, extractors);
    }

    @Override
    public String getPath() {
        StringBuilder sb = new StringBuilder(this.mExtractors.size() * 10);
        for (GLPropertyExtractor e : this.mExtractors) {
            if (e instanceof GLNamePropertyExtractor) {
                sb.append((Object)((GLNamePropertyExtractor)e).mType);
            } else {
                sb.append(((GLIndexPropertyExtractor)e).mIndex);
            }
            sb.append('/');
        }
        return sb.toString();
    }

    private static class GLIndexPropertyExtractor
    implements GLPropertyExtractor {
        private final int mIndex;

        public GLIndexPropertyExtractor(int index) {
            this.mIndex = index;
        }

        @Override
        public IGLProperty getProperty(IGLProperty p) {
            if (p instanceof GLListProperty && this.mIndex >= 0) {
                return ((GLListProperty)p).get(this.mIndex);
            }
            if (p instanceof GLSparseArrayProperty) {
                return ((GLSparseArrayProperty)p).getProperty(this.mIndex);
            }
            return null;
        }
    }

    private static class GLNamePropertyExtractor
    implements GLPropertyExtractor {
        private final GLStateType mType;

        public GLNamePropertyExtractor(GLStateType type) {
            this.mType = type;
        }

        @Override
        public IGLProperty getProperty(IGLProperty p) {
            if (p instanceof GLCompositeProperty) {
                return ((GLCompositeProperty)p).getProperty(this.mType);
            }
            return null;
        }
    }

    private static interface GLPropertyExtractor {
        public IGLProperty getProperty(IGLProperty var1);
    }
}

