/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.views;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.gltrace.GLProtoBuf;
import org.eclipse.andmore.gltrace.model.GLCall;
import org.eclipse.andmore.gltrace.model.GLTrace;
import org.eclipse.andmore.gltrace.views.FitToCanvasAction;
import org.eclipse.andmore.gltrace.views.SaveImageAction;
import org.eclipse.andmore.gltrace.widgets.ImageCanvas;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.Page;

public class FrameSummaryViewPage
extends Page {
    private GLTrace mTrace;
    private final Object mLock = new Object();
    private Job mRefresherJob;
    private int mCurrentFrame;
    private SashForm mSash;
    private ImageCanvas mImageCanvas;
    private Label mWallClockTimeLabel;
    private Label mThreadTimeLabel;
    private TableViewer mStatsTableViewer;
    private StatsLabelProvider mStatsLabelProvider;
    private StatsTableComparator mStatsTableComparator;
    private FitToCanvasAction mFitToCanvasAction;
    private SaveImageAction mSaveImageAction;
    private static final String[] STATS_TABLE_PROPERTIES = new String[]{"Function", "Count", "Wall Time (ns)", "Thread Time (ns)"};
    private static final float[] STATS_TABLE_COLWIDTH_RATIOS = new float[]{0.4f, 0.1f, 0.25f, 0.25f};
    private static final int[] STATS_TABLE_COL_ALIGNMENT = new int[]{16384, 16384, 131072, 131072};

    public FrameSummaryViewPage(GLTrace trace) {
        this.mTrace = trace;
    }

    public void setInput(GLTrace trace) {
        this.mTrace = trace;
    }

    public void createControl(Composite parent) {
        this.mSash = new SashForm(parent, 512);
        this.mImageCanvas = new ImageCanvas((Composite)this.mSash);
        this.createFrameStatisticsPart((Composite)this.mSash);
        this.mSash.setWeights(new int[]{70, 30});
        this.mFitToCanvasAction = new FitToCanvasAction(true, this.mImageCanvas);
        this.mSaveImageAction = new SaveImageAction(this.mImageCanvas);
        IToolBarManager toolbarManager = this.getSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.mFitToCanvasAction);
        toolbarManager.add((IAction)this.mSaveImageAction);
    }

    private void createFrameStatisticsPart(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
        Label l = new Label(c, 0);
        l.setText("Cumulative call duration of all OpenGL Calls in this frame:");
        l.setForeground(Display.getDefault().getSystemColor(16));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)l);
        l = new Label(c, 0);
        l.setText("Wall Clock Time: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)l);
        this.mWallClockTimeLabel = new Label(c, 0);
        GridDataFactory.defaultsFor((Control)this.mWallClockTimeLabel).grab(true, false).applyTo((Control)this.mWallClockTimeLabel);
        l = new Label(c, 0);
        l.setText("Thread Time: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)l);
        this.mThreadTimeLabel = new Label(c, 0);
        GridDataFactory.defaultsFor((Control)this.mThreadTimeLabel).grab(true, false).applyTo((Control)this.mThreadTimeLabel);
        l = new Label(c, 258);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)l);
        l = new Label(c, 0);
        l.setText("Per OpenGL Function Statistics:");
        l.setForeground(Display.getDefault().getSystemColor(16));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)l);
        final Table table = new Table(c, 67584);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.mStatsTableViewer = new TableViewer(table);
        this.mStatsLabelProvider = new StatsLabelProvider();
        this.mStatsTableComparator = new StatsTableComparator(1);
        SelectionAdapter columnSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn tc = (TableColumn)e.widget;
                String colText = tc.getText();
                int i = 0;
                while (i < STATS_TABLE_PROPERTIES.length) {
                    if (STATS_TABLE_PROPERTIES[i].equals(colText)) {
                        FrameSummaryViewPage.this.mStatsTableComparator.setSortColumn(i);
                        table.setSortColumn(tc);
                        table.setSortDirection(FrameSummaryViewPage.this.mStatsTableComparator.getDirection());
                        FrameSummaryViewPage.this.mStatsTableViewer.refresh();
                        break;
                    }
                    ++i;
                }
            }
        };
        int i = 0;
        while (i < STATS_TABLE_PROPERTIES.length) {
            TableViewerColumn tvc = new TableViewerColumn(this.mStatsTableViewer, 0);
            tvc.getColumn().setText(STATS_TABLE_PROPERTIES[i]);
            tvc.setLabelProvider((CellLabelProvider)this.mStatsLabelProvider);
            tvc.getColumn().setAlignment(STATS_TABLE_COL_ALIGNMENT[i]);
            tvc.getColumn().addSelectionListener((SelectionListener)columnSelectionListener);
            ++i;
        }
        this.mStatsTableViewer.setContentProvider((IContentProvider)new StatsContentProvider());
        this.mStatsTableViewer.setInput(null);
        this.mStatsTableViewer.setComparator((ViewerComparator)this.mStatsTableComparator);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int w = table.getClientArea().width;
                int i = 0;
                while (i < STATS_TABLE_COLWIDTH_RATIOS.length) {
                    table.getColumn(i).setWidth((int)((float)w * STATS_TABLE_COLWIDTH_RATIOS[i]));
                    ++i;
                }
            }
        });
    }

    public Control getControl() {
        return this.mSash;
    }

    public void setFocus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFrame(int frame) {
        if (this.mTrace == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentFrame = frame;
            if (this.mRefresherJob != null) {
                return;
            }
            this.mRefresherJob = new Job("Update Frame Summary Task"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    int currentFrame;
                    Object object = FrameSummaryViewPage.this.mLock;
                    synchronized (object) {
                        currentFrame = FrameSummaryViewPage.this.mCurrentFrame;
                        FrameSummaryViewPage.this.mRefresherJob = null;
                    }
                    FrameSummaryViewPage.this.updateImageCanvas(currentFrame);
                    FrameSummaryViewPage.this.updateFrameStats(currentFrame);
                    return Status.OK_STATUS;
                }
            };
            this.mRefresherJob.setPriority(20);
            this.mRefresherJob.schedule(500L);
        }
    }

    private void updateFrameStats(int frame) {
        final List<GLCall> calls = this.mTrace.getGLCallsForFrame(frame);
        Job job = new Job("Update Frame Statistics"){

            protected IStatus run(IProgressMonitor monitor) {
                long wallClockDuration = 0L;
                long threadDuration = 0L;
                final EnumMap<GLProtoBuf.GLMessage.Function, PerCallStats> cumulativeStats = new EnumMap<GLProtoBuf.GLMessage.Function, PerCallStats>(GLProtoBuf.GLMessage.Function.class);
                for (GLCall c : calls) {
                    wallClockDuration += (long)c.getWallDuration();
                    threadDuration += (long)c.getThreadDuration();
                    PerCallStats stats = (PerCallStats)cumulativeStats.get((Object)c.getFunction());
                    if (stats == null) {
                        stats = new PerCallStats();
                    }
                    ++stats.count;
                    stats.threadDuration += (long)c.getThreadDuration();
                    stats.wallDuration += (long)c.getWallDuration();
                    cumulativeStats.put(c.getFunction(), stats);
                }
                final String wallTime = FrameSummaryViewPage.this.formatMilliSeconds(wallClockDuration);
                final String threadTime = FrameSummaryViewPage.this.formatMilliSeconds(threadDuration);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        FrameSummaryViewPage.this.mWallClockTimeLabel.setText(wallTime);
                        FrameSummaryViewPage.this.mThreadTimeLabel.setText(threadTime);
                        FrameSummaryViewPage.this.mStatsTableViewer.setInput((Object)cumulativeStats);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private String formatMilliSeconds(long nanoSeconds) {
        double milliSeconds = (double)nanoSeconds / 1000000.0;
        return String.format("%.2f ms", milliSeconds);
    }

    private void updateImageCanvas(int frame) {
        int lastCallIndex = this.mTrace.getFrame(frame).getEndIndex() - 1;
        if (lastCallIndex >= 0 && lastCallIndex < this.mTrace.getGLCalls().size()) {
            GLCall call = this.mTrace.getGLCalls().get(lastCallIndex);
            final Image image = this.mTrace.getImage(call);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FrameSummaryViewPage.this.mImageCanvas.setImage(image);
                    FrameSummaryViewPage.this.mFitToCanvasAction.setEnabled(image != null);
                    FrameSummaryViewPage.this.mSaveImageAction.setEnabled(image != null);
                }
            });
        }
    }

    private static class PerCallStats {
        public int count;
        public long wallDuration;
        public long threadDuration;

        private PerCallStats() {
        }
    }

    private static class StatsContentProvider
    implements IStructuredContentProvider {
        private StatsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            return null;
        }
    }

    private static class StatsLabelProvider
    extends ColumnLabelProvider {
        private StatsLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (!(element instanceof Map.Entry)) {
                return;
            }
            GLProtoBuf.GLMessage.Function f = (GLProtoBuf.GLMessage.Function)((Object)((Map.Entry)element).getKey());
            PerCallStats stats = (PerCallStats)((Map.Entry)element).getValue();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(f.toString());
                    break;
                }
                case 1: {
                    cell.setText(Integer.toString(stats.count));
                    break;
                }
                case 2: {
                    cell.setText(this.formatDuration(stats.wallDuration));
                    break;
                }
                case 3: {
                    cell.setText(this.formatDuration(stats.threadDuration));
                    break;
                }
                default: {
                    cell.setText("??");
                }
            }
        }

        private String formatDuration(long time) {
            return String.format("%,10d", time);
        }
    }

    private static class StatsTableComparator
    extends ViewerComparator {
        private int mSortColumn;
        private boolean mDescending = true;

        private StatsTableComparator(int defaultSortColIndex) {
            this.mSortColumn = defaultSortColIndex;
        }

        public void setSortColumn(int index) {
            if (index == this.mSortColumn) {
                this.mDescending = !this.mDescending;
            } else {
                this.mSortColumn = index;
                this.mDescending = true;
            }
        }

        public int getDirection() {
            return this.mDescending ? 128 : 1024;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Map.Entry entry2;
            Map.Entry entry1;
            if (this.mDescending) {
                entry1 = (Map.Entry)e1;
                entry2 = (Map.Entry)e2;
            } else {
                entry1 = (Map.Entry)e2;
                entry2 = (Map.Entry)e1;
            }
            String k1 = entry1.getKey().toString();
            String k2 = entry2.getKey().toString();
            PerCallStats stats1 = (PerCallStats)entry1.getValue();
            PerCallStats stats2 = (PerCallStats)entry2.getValue();
            switch (this.mSortColumn) {
                case 0: {
                    return String.CASE_INSENSITIVE_ORDER.compare(k1, k2);
                }
                case 1: {
                    return stats1.count - stats2.count;
                }
                case 2: {
                    return (int)(stats1.wallDuration - stats2.wallDuration);
                }
                case 3: {
                    return (int)(stats1.threadDuration - stats2.threadDuration);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

