/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.views.detail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.gltrace.GLEnum;
import org.eclipse.andmore.gltrace.GLUtils;
import org.eclipse.andmore.gltrace.state.GLCompositeProperty;
import org.eclipse.andmore.gltrace.state.GLStateType;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.views.detail.IStateDetailProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VboDetailProvider
implements IStateDetailProvider {
    private Composite mComposite;
    private Label mSizeLabel;
    private Label mUsageLabel;
    private Label mTypeLabel;
    private Combo mDisplayFormatCombo;
    private Text mTextControl;
    private byte[] mBufferData;

    @Override
    public boolean isApplicable(IGLProperty state) {
        return this.getVboProperty(state) != null;
    }

    @Override
    public void createControl(Composite parent) {
        this.mComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mComposite);
        Label l = new Label(this.mComposite, 0);
        l.setText("Size: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)l);
        this.mSizeLabel = new Label(this.mComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mSizeLabel);
        l = new Label(this.mComposite, 0);
        l.setText("Usage: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)l);
        this.mUsageLabel = new Label(this.mComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mUsageLabel);
        l = new Label(this.mComposite, 0);
        l.setText("Type: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)l);
        this.mTypeLabel = new Label(this.mComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mTypeLabel);
        l = new Label(this.mComposite, 0);
        l.setText("Format Data As: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)l);
        DisplayFormat[] values = DisplayFormat.values();
        ArrayList<String> formats = new ArrayList<String>(values.length);
        DisplayFormat[] displayFormatArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayFormat format = displayFormatArray[n2];
            formats.add(format.name());
            ++n2;
        }
        this.mDisplayFormatCombo = new Combo(this.mComposite, 12);
        this.mDisplayFormatCombo.setItems(formats.toArray(new String[formats.size()]));
        this.mDisplayFormatCombo.select(0);
        this.mDisplayFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VboDetailProvider.this.updateContents();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mDisplayFormatCombo);
        this.mTextControl = new Text(this.mComposite, 2890);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.mTextControl);
        this.mTextControl.setEditable(false);
    }

    @Override
    public void disposeControl() {
    }

    @Override
    public Control getControl() {
        return this.mComposite;
    }

    @Override
    public void updateControl(IGLProperty state) {
        IGLProperty vbo = this.getVboProperty(state);
        if (vbo instanceof GLCompositeProperty) {
            GLCompositeProperty vboProperty = (GLCompositeProperty)vbo;
            IGLProperty sizeProperty = vboProperty.getProperty(GLStateType.BUFFER_SIZE);
            this.mSizeLabel.setText(String.valueOf(sizeProperty.getStringValue()) + " bytes");
            IGLProperty usageProperty = vboProperty.getProperty(GLStateType.BUFFER_USAGE);
            this.mUsageLabel.setText(usageProperty.getStringValue());
            IGLProperty typeProperty = vboProperty.getProperty(GLStateType.BUFFER_TYPE);
            this.mTypeLabel.setText(typeProperty.getStringValue());
            IGLProperty dataProperty = vboProperty.getProperty(GLStateType.BUFFER_DATA);
            this.mBufferData = (byte[])dataProperty.getValue();
        } else {
            this.mBufferData = null;
        }
        this.updateContents();
    }

    private void updateContents() {
        if (this.mBufferData != null) {
            this.mTextControl.setText(GLUtils.formatData(this.mBufferData, GLEnum.valueOf(this.mDisplayFormatCombo.getText())));
            this.mTextControl.setEnabled(true);
            this.mDisplayFormatCombo.setEnabled(true);
        } else {
            this.mTextControl.setText("");
            this.mTextControl.setEnabled(false);
            this.mDisplayFormatCombo.setEnabled(false);
        }
    }

    @Override
    public List<IContributionItem> getToolBarItems() {
        return Collections.emptyList();
    }

    private IGLProperty getVboProperty(IGLProperty state) {
        if (state.getType() == GLStateType.VBO_COMPOSITE) {
            return state;
        }
        if ((state = state.getParent()) != null && state.getType() == GLStateType.VBO_COMPOSITE) {
            return state;
        }
        return null;
    }

    private static enum DisplayFormat {
        GL_FLOAT,
        GL_BYTE,
        GL_UNSIGNED_BYTE,
        GL_SHORT,
        GL_UNSIGNED_SHORT,
        GL_FIXED;

    }
}

