/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ndk.internal.launch;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.xml.ManifestData;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.launch.AndroidLaunchController;
import org.eclipse.andmore.internal.launch.DeviceChooserDialog;
import org.eclipse.andmore.internal.project.AndroidManifestHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.ndk.internal.NativeAbi;
import org.eclipse.andmore.ndk.internal.NdkHelper;
import org.eclipse.andmore.ndk.internal.launch.GdbServerTask;
import org.eclipse.andmore.ndk.internal.launch.Messages;
import org.eclipse.andmore.ndk.internal.launch.NdkLaunchConstants;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class NdkGdbLaunchDelegate
extends GdbLaunchDelegate {
    public static final String LAUNCH_TYPE_ID = "org.eclipse.andmore.ndk.debug.LaunchConfigType";
    private static final Joiner JOINER = Joiner.on((String)", ").skipNulls();
    private static final String DEBUG_SOCKET = "debugsock";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean launched = this.doLaunch(config, mode, launch, monitor);
        if (!launched) {
            if (launch.canTerminate()) {
                launch.terminate();
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
    }

    public boolean doLaunch(final ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project = null;
        ICProject cProject = CDebugUtils.getCProject((ILaunchConfiguration)config);
        if (cProject != null) {
            project = cProject.getProject();
        }
        if (project == null) {
            AndmoreAndroidPlugin.printErrorToConsole((String)Messages.NdkGdbLaunchDelegate_LaunchError_CouldNotGetProject, (Object[])new Object[0]);
            return false;
        }
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_PerformIncrementalBuild);
        ProjectHelper.doFullIncrementalDebugBuild((IProject)project, (IProgressMonitor)monitor);
        if (ProjectHelper.hasError((IProject)project, (boolean)true)) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_ProjectHasErrors});
            return false;
        }
        final ManifestData manifestData = AndroidManifestHelper.parseForData((IProject)project);
        ManifestInfo manifestInfo = ManifestInfo.get((IProject)project);
        final AndroidVersion minSdkVersion = new AndroidVersion(manifestInfo.getMinSdkVersion(), manifestInfo.getMinSdkCodeName());
        String activityName = this.getActivityToLaunch(this.getActivityNameInLaunchConfig(config), manifestData.getLauncherActivity(), manifestData.getActivities(), project);
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_ObtainAppAbis);
        Collection<NativeAbi> appAbis = NdkHelper.getApplicationAbis(project, monitor);
        if (appAbis.size() == 0) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_UnableToDetectAppAbi});
            return false;
        }
        config.getName();
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_ObtainDevice);
        IDevice device = null;
        IDevice[] devices = AndroidDebugBridge.getBridge().getDevices();
        if (devices.length == 1) {
            device = devices[0];
        } else {
            device = this.getLastUsedDevice(config, devices);
            if (device == null) {
                final IAndroidTarget projectTarget = Sdk.getCurrent().getTarget(project);
                final DeviceChooserDialog.DeviceChooserResponse response = new DeviceChooserDialog.DeviceChooserResponse();
                final boolean[] continueLaunch = new boolean[1];
                AndmoreAndroidPlugin.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DeviceChooserDialog dialog = new DeviceChooserDialog(AndmoreAndroidPlugin.getDisplay().getActiveShell(), response, manifestData.getPackage(), projectTarget, minSdkVersion, false);
                        if (dialog.open() == 0) {
                            AndroidLaunchController.updateLaunchConfigWithLastUsedDevice((ILaunchConfiguration)config, (DeviceChooserDialog.DeviceChooserResponse)response);
                            continueLaunch[0] = true;
                        }
                    }
                });
                if (!continueLaunch[0]) {
                    return false;
                }
                device = response.getDeviceToUse();
            }
        }
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_CheckAndroidDeviceVersion);
        AndroidVersion deviceVersion = Sdk.getDeviceVersion((IDevice)device);
        if (deviceVersion == null) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_UnknownAndroidDeviceVersion});
            return false;
        }
        if (!deviceVersion.isGreaterOrEqualThan(8)) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_Api8Needed});
            return false;
        }
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_ObtainDeviceABI);
        String deviceAbi1 = device.getProperty("ro.product.cpu.abi");
        String deviceAbi2 = device.getProperty("ro.product.cpu.abi2");
        NativeAbi compatAbi = this.getCompatibleAbi(deviceAbi1, deviceAbi2, appAbis);
        if (compatAbi == null) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_NoCompatibleAbi});
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{String.format("ABI's supported by the application: %s", JOINER.join(appAbis))});
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{String.format("ABI's supported by the device: %s, %s", deviceAbi1, deviceAbi2)});
            return false;
        }
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_SyncAppToDevice);
        IFile apk = ProjectHelper.getApplicationPackage((IProject)project);
        if (apk == null) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_NullApk});
            return false;
        }
        try {
            device.installPackage(apk.getLocation().toOSString(), true, new String[0]);
        }
        catch (InstallException e1) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_InstallError, e1});
            return false;
        }
        monitor.setTaskName(String.valueOf(Messages.NdkGdbLaunchDelegate_Action_ActivityLaunch) + activityName);
        String command = String.format("am start -n %s/%s", manifestData.getPackage(), activityName);
        try {
            CountDownLatch launchedLatch = new CountDownLatch(1);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver(launchedLatch);
            device.executeShellCommand(command, (IShellOutputReceiver)receiver);
            launchedLatch.await(5L, TimeUnit.SECONDS);
            String shellOutput = receiver.getOutput();
            if (shellOutput.contains("Error type")) {
                throw new RuntimeException(receiver.getOutput());
            }
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_ActivityLaunchError, e});
            return false;
        }
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_KillExistingGdbServer);
        Client[] clientArray = device.getClients();
        int shellOutput = clientArray.length;
        int receiver = 0;
        while (receiver < shellOutput) {
            Client c = clientArray[receiver];
            String description = c.getClientData().getClientDescription();
            if (description != null && description.contains("gdbserver")) {
                c.kill();
            }
            ++receiver;
        }
        IPath solibFolder = project.getLocation().append("obj/local").append(compatAbi.getAbi());
        try {
            this.pull(device, "/system/bin/app_process", solibFolder);
            this.pull(device, "/system/lib/libc.so", solibFolder);
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_PullFileError, e});
            return false;
        }
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_WaitingForActivity);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        Client app = device.getClient(manifestData.getPackage());
        int pid = app.getClientData().getPid();
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_LaunchingGdbServer);
        CountDownLatch attachLatch = new CountDownLatch(1);
        GdbServerTask gdbServer = new GdbServerTask(device, manifestData.getPackage(), DEBUG_SOCKET, pid, attachLatch);
        new Thread((Runnable)gdbServer, String.format("gdbserver for %s", manifestData.getPackage())).start();
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_WaitGdbServerAttach);
        boolean attached = false;
        try {
            attached = attachLatch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_InterruptedWaitingForGdbserver});
            return false;
        }
        if (!attached) {
            if (gdbServer.getLaunchException() != null) {
                AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_gdbserverLaunchException, gdbServer.getLaunchException()});
            } else {
                AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_gdbserverOutput, gdbServer.getShellOutput()});
            }
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_VerifyIfDebugBuild});
            gdbServer.setCancelled();
            return false;
        }
        String appDir = null;
        try {
            appDir = this.getAppDirectory(device, manifestData.getPackage(), 5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_ObtainingAppFolder, e});
            return false;
        }
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_SettingUpPortForward);
        String localport = config.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "5039");
        try {
            device.createForward(Integer.parseInt(localport), String.format("%s/%s", appDir, DEBUG_SOCKET), IDevice.DeviceUnixSocketNamespace.FILESYSTEM);
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_PortForwarding, e});
            return false;
        }
        ILaunchConfiguration config2 = this.performVariableSubstitutions(config, project, compatAbi, monitor);
        monitor.setTaskName(Messages.NdkGdbLaunchDelegate_Action_LaunchHostGdb);
        super.launch(config2, mode, launch, monitor);
        return true;
    }

    private IDevice getLastUsedDevice(ILaunchConfiguration config, IDevice[] devices) {
        block3: {
            try {
                boolean reuse = config.getAttribute("org.eclipse.andmore.reuse.last.used.device", false);
                if (reuse) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        String serial = config.getAttribute("org.eclipse.andmore.last.used.device", null);
        return AndroidLaunchController.getDeviceIfOnline((String)serial, (IDevice[])devices);
    }

    private void pull(IDevice device, String remote, IPath solibFolder) throws SyncException, IOException, AdbCommandRejectedException, TimeoutException {
        String remoteFileName = new Path(remote).toFile().getName();
        String targetFile = solibFolder.append(remoteFileName).toString();
        device.pullFile(remote, targetFile);
    }

    private ILaunchConfiguration performVariableSubstitutions(ILaunchConfiguration config, IProject project, NativeAbi compatAbi, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy wcopy = config.getWorkingCopy();
        String toolchainPrefix = NdkHelper.getToolchainPrefix(project, compatAbi, monitor);
        String gdb = String.valueOf(toolchainPrefix) + "gdb";
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable ndkGdb = manager.newValueVariable("NdkGdb", "NdkGdb", true, gdb);
        IValueVariable ndkProject = manager.newValueVariable("NdkProject", "NdkProject", true, project.getLocation().toOSString());
        IValueVariable ndkCompatAbi = manager.newValueVariable("NdkCompatAbi", "NdkCompatAbi", true, compatAbi.getAbi());
        IValueVariable[] ndkVars = new IValueVariable[]{ndkGdb, ndkProject, ndkCompatAbi};
        manager.addVariables(ndkVars);
        String userGdbPath = wcopy.getAttribute("org.eclipse.andmore.ndk.ndklaunch.gdb", NdkLaunchConstants.DEFAULT_GDB);
        wcopy.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.elaborateExpression(manager, userGdbPath));
        wcopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.elaborateExpression(manager, NdkLaunchConstants.DEFAULT_PROGRAM));
        List solibPaths = wcopy.getAttribute("org.eclipse.andmore.ndk.ndklaunch.solib", Collections.singletonList(NdkLaunchConstants.DEFAULT_SOLIB_PATH));
        ArrayList<String> fixedSolibPaths = new ArrayList<String>(solibPaths.size());
        for (String u : solibPaths) {
            fixedSolibPaths.add(this.elaborateExpression(manager, u));
        }
        wcopy.setAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", fixedSolibPaths);
        manager.removeVariables(ndkVars);
        return wcopy.doSave();
    }

    private String elaborateExpression(IStringVariableManager manager, String expr) throws CoreException {
        boolean DEBUG = true;
        String eval = manager.performStringSubstitution(expr);
        if (DEBUG) {
            AndmoreAndroidPlugin.printToConsole((String)"Substitute: ", (Object[])new Object[]{expr, " --> ", eval});
        }
        return eval;
    }

    private String getActivityToLaunch(String activityNameInLaunchConfig, ManifestData.Activity launcherActivity, ManifestData.Activity[] activities, IProject project) {
        if (activities.length == 0) {
            AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_NoActivityInManifest});
            return null;
        }
        if (activityNameInLaunchConfig == null && launcherActivity != null) {
            return launcherActivity.getName();
        }
        ManifestData.Activity[] activityArray = activities;
        int n = activities.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestData.Activity a = activityArray[n2];
            if (a != null && a.getName().equals(activityNameInLaunchConfig)) {
                return activityNameInLaunchConfig;
            }
            ++n2;
        }
        AndmoreAndroidPlugin.printErrorToConsole((IProject)project, (Object[])new Object[]{Messages.NdkGdbLaunchDelegate_LaunchError_NoSuchActivity});
        if (launcherActivity != null) {
            return launcherActivity.getName();
        }
        AndmoreAndroidPlugin.printErrorToConsole((String)Messages.NdkGdbLaunchDelegate_LaunchError_NoLauncherActivity, (Object[])new Object[0]);
        return null;
    }

    private NativeAbi getCompatibleAbi(String deviceAbi1, String deviceAbi2, Collection<NativeAbi> appAbis) {
        for (NativeAbi abi : appAbis) {
            if (!abi.getAbi().equals(deviceAbi1) && !abi.getAbi().equals(deviceAbi2)) continue;
            return abi;
        }
        return null;
    }

    private String getActivityNameInLaunchConfig(ILaunchConfiguration configuration) {
        String activityName;
        String empty = "";
        try {
            activityName = configuration.getAttribute("org.eclipse.andmore.activity", empty);
        }
        catch (CoreException coreException) {
            return null;
        }
        return activityName != empty ? activityName : null;
    }

    private String getAppDirectory(IDevice device, String app, long timeout, TimeUnit timeoutUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InterruptedException {
        String command = String.format("run-as %s /system/bin/sh -c pwd", app);
        CountDownLatch commandCompleteLatch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(commandCompleteLatch);
        device.executeShellCommand(command, (IShellOutputReceiver)receiver);
        commandCompleteLatch.await(timeout, timeoutUnit);
        return receiver.getOutput().trim();
    }
}

