/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.common.layout.grid;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.IViewMetadata;
import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.SegmentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.andmore.common.layout.BaseLayoutRule;
import org.eclipse.andmore.common.layout.GravityHelper;
import org.eclipse.andmore.common.layout.GridLayoutRule;
import org.eclipse.andmore.common.layout.grid.GridMatch;
import org.eclipse.andmore.common.layout.grid.GridModel;

public class GridDropHandler {
    private final GridModel mGrid;
    private final GridLayoutRule mRule;
    private GridMatch mColumnMatch;
    private GridMatch mRowMatch;

    public GridDropHandler(GridLayoutRule gridLayoutRule, INode layout, Object view) {
        this.mRule = gridLayoutRule;
        this.mGrid = GridModel.get(this.mRule.getRulesEngine(), layout, view);
    }

    public void computeMatches(DropFeedback feedback, Point p) {
        int h;
        this.mColumnMatch = null;
        this.mRowMatch = null;
        feedback.tooltip = null;
        Rect bounds = this.mGrid.layout.getBounds();
        int x1 = p.x;
        int y1 = p.y;
        Rect dragBounds = feedback.dragBounds;
        int w = dragBounds != null ? dragBounds.w : 0;
        int n = h = dragBounds != null ? dragBounds.h : 0;
        if (!GridLayoutRule.sGridMode) {
            if (dragBounds != null) {
                x1 += dragBounds.x;
                y1 += dragBounds.y;
            }
            int x2 = x1 + w;
            int y2 = y1 + h;
            if (x2 < bounds.x || y2 < bounds.y || x1 > bounds.x2() || y1 > bounds.y2()) {
                return;
            }
            ArrayList<GridMatch> columnMatches = new ArrayList<GridMatch>();
            ArrayList<GridMatch> rowMatches = new ArrayList<GridMatch>();
            int max = BaseLayoutRule.getMaxMatchDistance();
            this.addLeftSideMatch(x1, columnMatches, max);
            this.addRightSideMatch(x2, columnMatches, max);
            this.addCenterColumnMatch(bounds, x1, y1, x2, y2, columnMatches, max);
            int row = this.mGrid.getViewCount() == 0 ? 0 : this.mGrid.getClosestRow(y1);
            int rowY = this.mGrid.getRowY(row);
            this.addTopMatch(y1, rowMatches, max, row, rowY);
            this.addBaselineMatch(feedback.dragBaseline, y1, rowMatches, max, row, rowY);
            this.addBottomMatch(y2, rowMatches, max);
            this.addColumnGapMatch(bounds, x1, x2, columnMatches, max);
            this.addRowGapMatch(bounds, y1, y2, rowMatches, max);
            if (GridLayoutRule.sSnapToGrid) {
                x1 = (x1 - 32 - bounds.x) / 16 * 16 + 32 + bounds.x;
                y1 = (y1 - 32 - bounds.y) / 16 * 16 + 32 + bounds.y;
                x2 = x1 + w;
                y2 = y1 + h;
            }
            if (columnMatches.size() == 0 && x1 >= bounds.x) {
                columnMatches.add(new GridMatch(SegmentType.LEFT, 0, x1, this.mGrid.getColumn(x1), true, Integer.MIN_VALUE));
            }
            if (rowMatches.size() == 0 && y1 >= bounds.y) {
                rowMatches.add(new GridMatch(SegmentType.TOP, 0, y1, this.mGrid.getRow(y1), true, Integer.MIN_VALUE));
            }
            Collections.sort(rowMatches);
            Collections.sort(columnMatches);
            this.mColumnMatch = null;
            this.mRowMatch = null;
            String columnDescription = null;
            String rowDescription = null;
            if (columnMatches.size() > 0) {
                this.mColumnMatch = (GridMatch)columnMatches.get(0);
                columnDescription = this.mColumnMatch.getDisplayName(this.mGrid.layout);
            }
            if (rowMatches.size() > 0) {
                this.mRowMatch = (GridMatch)rowMatches.get(0);
                rowDescription = this.mRowMatch.getDisplayName(this.mGrid.layout);
            }
            if (columnDescription != null && rowDescription != null) {
                feedback.tooltip = String.valueOf(columnDescription) + '\n' + rowDescription;
            }
            feedback.invalidTarget = this.mColumnMatch == null || this.mRowMatch == null;
        } else {
            int centerDistance;
            boolean createRow;
            int column = this.mGrid.getColumn(x1);
            int row = this.mGrid.getRow(y1);
            int leftDistance = this.mGrid.getColumnDistance(column, x1);
            int rightDistance = this.mGrid.getColumnDistance(column + 1, x1);
            int topDistance = this.mGrid.getRowDistance(row, y1);
            int bottomDistance = this.mGrid.getRowDistance(row + 1, y1);
            int SLOP = 2;
            int radius = this.mRule.getNewCellSize();
            if (rightDistance < radius + SLOP) {
                column = Math.min(column + 1, this.mGrid.actualColumnCount);
                leftDistance = rightDistance;
            }
            if (bottomDistance < radius + SLOP) {
                row = Math.min(row + 1, this.mGrid.actualRowCount);
                topDistance = bottomDistance;
            }
            boolean createColumn = leftDistance < radius + SLOP;
            boolean bl = createRow = topDistance < radius + SLOP;
            if (x1 >= bounds.x2()) {
                createColumn = true;
            }
            if (y1 >= bounds.y2()) {
                createRow = true;
            }
            int cellWidth = leftDistance + rightDistance;
            int cellHeight = topDistance + bottomDistance;
            SegmentType horizontalType = SegmentType.LEFT;
            SegmentType verticalType = SegmentType.TOP;
            int minDistance = 10;
            if (!createColumn && leftDistance > minDistance && dragBounds != null && dragBounds.w < cellWidth - 10) {
                if (rightDistance < leftDistance) {
                    horizontalType = SegmentType.RIGHT;
                }
                if ((centerDistance = Math.abs(cellWidth / 2 - leftDistance)) < leftDistance / 2 && centerDistance < rightDistance / 2) {
                    horizontalType = SegmentType.CENTER_HORIZONTAL;
                }
            }
            if (!createRow && topDistance > minDistance && dragBounds != null && dragBounds.h < cellHeight - 10) {
                if (bottomDistance < topDistance) {
                    verticalType = SegmentType.BOTTOM;
                }
                if ((centerDistance = Math.abs(cellHeight / 2 - topDistance)) < topDistance / 2 && centerDistance < bottomDistance / 2) {
                    verticalType = SegmentType.CENTER_VERTICAL;
                }
            }
            this.mColumnMatch = new GridMatch(horizontalType, 0, x1, column, createColumn, 0);
            this.mRowMatch = new GridMatch(verticalType, 0, y1, row, createRow, 0);
            StringBuilder description = new StringBuilder(50);
            String rowString = Integer.toString(this.mColumnMatch.cellIndex + 1);
            String columnString = Integer.toString(this.mRowMatch.cellIndex + 1);
            if (this.mRowMatch.createCell && this.mRowMatch.cellIndex < this.mGrid.actualRowCount) {
                description.append(String.format("Shift row %1$d down", this.mRowMatch.cellIndex + 1));
                description.append('\n');
            }
            if (this.mColumnMatch.createCell && this.mColumnMatch.cellIndex < this.mGrid.actualColumnCount) {
                description.append(String.format("Shift column %1$d right", this.mColumnMatch.cellIndex + 1));
                description.append('\n');
            }
            description.append(String.format("Insert into cell (%1$s,%2$s)", rowString, columnString));
            description.append('\n');
            description.append(String.format("Align %1$s, %2$s", horizontalType.name().toLowerCase(Locale.US), verticalType.name().toLowerCase(Locale.US)));
            feedback.tooltip = description.toString();
        }
    }

    private void addLeftSideMatch(int x1, List<GridMatch> columnMatches, int max) {
        int column = this.mGrid.getViewCount() == 0 ? 0 : this.mGrid.getClosestColumn(x1);
        int columnX = this.mGrid.getColumnX(column);
        int distance = Math.abs(columnX - x1);
        if (distance <= max) {
            columnMatches.add(new GridMatch(SegmentType.LEFT, distance, columnX, column, false, Integer.MIN_VALUE));
        }
    }

    private void addRightSideMatch(int x2, List<GridMatch> columnMatches, int max) {
        int columnX;
        int columnRight = this.mGrid.getViewCount() == 0 ? 0 : this.mGrid.getClosestColumn(x2);
        int rightDistance = this.mGrid.getColumnDistance(columnRight, x2);
        if (rightDistance < max && (columnX = this.mGrid.getColumnX(columnRight)) > this.mGrid.layout.getBounds().x) {
            columnMatches.add(new GridMatch(SegmentType.RIGHT, rightDistance, columnX, columnRight, false, Integer.MIN_VALUE));
        }
    }

    private void addCenterColumnMatch(Rect bounds, int x1, int y1, int x2, int y2, List<GridMatch> columnMatches, int max) {
        int matchedLine;
        int distance;
        Collection<INode> intersectsRow = this.mGrid.getIntersectsRow(y1, y2);
        if (intersectsRow.size() == 0 && (distance = Math.abs((x1 + x2) / 2 - (matchedLine = bounds.centerX()))) <= 2 * max) {
            boolean createCell = false;
            columnMatches.add(new GridMatch(SegmentType.CENTER_HORIZONTAL, distance, matchedLine, 0, createCell, Integer.MIN_VALUE));
        }
    }

    private void addTopMatch(int y1, List<GridMatch> rowMatches, int max, int row, int rowY) {
        int distance = this.mGrid.getRowDistance(row, y1);
        if (distance <= max) {
            rowMatches.add(new GridMatch(SegmentType.TOP, distance, rowY, row, false, Integer.MIN_VALUE));
        }
    }

    private void addBottomMatch(int y2, List<GridMatch> rowMatches, int max) {
        int rowY;
        int rowBottom = this.mGrid.getViewCount() == 0 ? 0 : this.mGrid.getClosestRow(y2);
        int distance = this.mGrid.getRowDistance(rowBottom, y2);
        if (distance < max && (rowY = this.mGrid.getRowY(rowBottom)) > this.mGrid.layout.getBounds().y) {
            rowMatches.add(new GridMatch(SegmentType.BOTTOM, distance, rowY, rowBottom, false, Integer.MIN_VALUE));
        }
    }

    private void addBaselineMatch(int dragBaseline, int y1, List<GridMatch> rowMatches, int max, int row, int rowY) {
        int rowBaselineY;
        int distance;
        int dragBaselineY = y1 + dragBaseline;
        int rowBaseline = this.mGrid.getBaseline(row);
        if (rowBaseline != -1 && (distance = Math.abs(dragBaselineY - (rowBaselineY = rowY + rowBaseline))) < max) {
            rowMatches.add(new GridMatch(SegmentType.BASELINE, distance, rowBaselineY, row, false, Integer.MIN_VALUE));
        }
    }

    private void addColumnGapMatch(Rect bounds, int x1, int x2, List<GridMatch> columnMatches, int max) {
        if (x1 < bounds.x + 32 + max) {
            int matchedLine = bounds.x + 32;
            int distance = Math.abs(matchedLine - x1);
            if (distance <= max) {
                boolean createCell = this.mGrid.getColumnX(this.mGrid.getColumn(matchedLine)) != matchedLine;
                columnMatches.add(new GridMatch(SegmentType.LEFT, distance, matchedLine, 0, createCell, 32));
            }
        } else if (x2 > bounds.x2() - 32 - max) {
            int matchedLine = bounds.x2() - 32;
            int distance = Math.abs(matchedLine - x2);
        } else {
            boolean createCell;
            int columnRight = this.mGrid.getColumn(x1 - 16);
            int columnX = this.mGrid.getColumnMaxX(columnRight);
            int matchedLine = columnX + 16;
            int distance = Math.abs(matchedLine - x1);
            if (distance <= max) {
                createCell = this.mGrid.getColumnX(this.mGrid.getColumn(matchedLine)) != matchedLine;
                columnMatches.add(new GridMatch(SegmentType.LEFT, distance, matchedLine, columnRight, createCell, 16));
            }
            columnRight = this.mGrid.getColumn(x1);
            matchedLine = columnX = this.mGrid.getColumnMaxX(columnRight);
            distance = Math.abs(matchedLine - x1);
            if ((distance += 2) <= max) {
                createCell = this.mGrid.getColumnX(this.mGrid.getColumn(matchedLine)) != matchedLine;
                columnMatches.add(new GridMatch(SegmentType.LEFT, distance, matchedLine, columnRight, createCell, 0));
            }
        }
    }

    private void addRowGapMatch(Rect bounds, int y1, int y2, List<GridMatch> rowMatches, int max) {
        if (y1 < bounds.y + 32 + max) {
            int matchedLine = bounds.y + 32;
            int distance = Math.abs(matchedLine - y1);
            if (distance <= max) {
                boolean createCell = this.mGrid.getRowY(this.mGrid.getRow(matchedLine)) != matchedLine;
                rowMatches.add(new GridMatch(SegmentType.TOP, distance, matchedLine, 0, createCell, 32));
            }
        } else if (y2 > bounds.y2() - 32 - max) {
            int matchedLine = bounds.y2() - 32;
            int distance = Math.abs(matchedLine - y2);
        } else {
            boolean createCell;
            int rowBottom = this.mGrid.getRow(y1 - 16);
            int rowY = this.mGrid.getRowMaxY(rowBottom);
            int matchedLine = rowY + 16;
            int distance = Math.abs(matchedLine - y1);
            if (distance <= max) {
                createCell = this.mGrid.getRowY(this.mGrid.getRow(matchedLine)) != matchedLine;
                rowMatches.add(new GridMatch(SegmentType.TOP, distance, matchedLine, rowBottom, createCell, 16));
            }
            rowBottom = this.mGrid.getRow(y1);
            matchedLine = rowY = this.mGrid.getRowMaxY(rowBottom);
            distance = Math.abs(matchedLine - y1);
            if ((distance += 2) <= max) {
                createCell = this.mGrid.getRowY(this.mGrid.getRow(matchedLine)) != matchedLine;
                rowMatches.add(new GridMatch(SegmentType.TOP, distance, matchedLine, rowBottom, createCell, 0));
            }
        }
    }

    public INode handleFreeFormDrop(INode targetNode, IDragElement element) {
        int index;
        int margin;
        int distance;
        int endY;
        int endX;
        assert (this.mRowMatch != null);
        assert (this.mColumnMatch != null);
        String fqcn = element.getFqcn();
        INode newChild = null;
        Rect bounds = element.getBounds();
        int row = this.mRowMatch.cellIndex;
        int column = this.mColumnMatch.cellIndex;
        if (targetNode.getChildren().length == 0) {
            this.mGrid.setGridAttribute(targetNode, "columnCount", 2);
        }
        if (this.mColumnMatch.type == SegmentType.RIGHT) {
            endX = this.mColumnMatch.matchedLine - 1;
            int startX = endX - bounds.w;
            column = this.mGrid.getColumn(startX);
        } else {
            int startX = this.mColumnMatch.matchedLine;
            endX = startX + bounds.w;
        }
        if (this.mRowMatch.type == SegmentType.BOTTOM) {
            endY = this.mRowMatch.matchedLine - 1;
            int startY = endY - bounds.h;
            row = this.mGrid.getRow(startY);
        } else if (this.mRowMatch.type == SegmentType.BASELINE) {
            int startY = endY = this.mRowMatch.matchedLine;
        } else {
            int startY = this.mRowMatch.matchedLine;
            endY = startY + bounds.h;
        }
        int endColumn = this.mGrid.getColumn(endX);
        int endRow = this.mGrid.getRow(endY);
        int columnSpan = endColumn - column + 1;
        int rowSpan = endRow - row + 1;
        assert (this.mRowMatch.type != SegmentType.BASELINE || rowSpan == 1) : rowSpan;
        if (!this.mRowMatch.createCell) {
            double d = bounds.h;
            int n = this.mRowMatch.type == SegmentType.BOTTOM ? endRow : row;
            if (d <= 1.2 * (double)this.mGrid.getRowHeight(n, 1)) {
                if (this.mRowMatch.type == SegmentType.BOTTOM) {
                    row += rowSpan - 1;
                }
                rowSpan = 1;
            }
        }
        if (!this.mColumnMatch.createCell) {
            double d = bounds.w;
            int n = this.mColumnMatch.type == SegmentType.RIGHT ? endColumn : column;
            if (d <= 1.2 * (double)this.mGrid.getColumnWidth(n, 1)) {
                if (this.mColumnMatch.type == SegmentType.RIGHT) {
                    column += columnSpan - 1;
                }
                columnSpan = 1;
            }
        }
        if (this.mColumnMatch.type == SegmentType.CENTER_HORIZONTAL) {
            column = 0;
            columnSpan = this.mGrid.actualColumnCount;
        }
        this.mGrid.applyPositionAttributes();
        if (this.mColumnMatch.createCell) {
            int columnWidthPx = this.mGrid.getColumnDistance(column, this.mColumnMatch.matchedLine);
            int columnWidthDp = this.mRule.getRulesEngine().pxToDp(columnWidthPx);
            int maxX = this.mGrid.getColumnMaxX(column);
            boolean insertMarginColumn = false;
            if (this.mColumnMatch.margin == 0) {
                columnWidthDp = 0;
            } else if (this.mColumnMatch.margin != Integer.MIN_VALUE) {
                distance = Math.abs(this.mColumnMatch.matchedLine - (maxX + this.mColumnMatch.margin));
                boolean bl = insertMarginColumn = column > 0 && distance < 2;
                if (insertMarginColumn) {
                    margin = this.mColumnMatch.margin;
                    columnWidthDp = this.mRule.getRulesEngine().pxToDp(margin);
                }
            }
            this.mGrid.splitColumn(++column, insertMarginColumn, columnWidthDp, this.mColumnMatch.matchedLine);
            if (insertMarginColumn) {
                ++column;
            }
        }
        if (this.mRowMatch.createCell) {
            int rowHeightPx = this.mGrid.getRowDistance(row, this.mRowMatch.matchedLine);
            int rowHeightDp = this.mRule.getRulesEngine().pxToDp(rowHeightPx);
            int maxY = this.mGrid.getRowMaxY(row);
            boolean insertMarginRow = false;
            if (this.mRowMatch.margin == 0) {
                rowHeightDp = 0;
            } else if (this.mRowMatch.margin != Integer.MIN_VALUE) {
                distance = Math.abs(this.mRowMatch.matchedLine - (maxY + this.mRowMatch.margin));
                boolean bl = insertMarginRow = row > 0 && distance < 2;
                if (insertMarginRow) {
                    Margins insets;
                    margin = this.mRowMatch.margin;
                    IViewMetadata metadata = this.mRule.getRulesEngine().getMetadata(element.getFqcn());
                    if (metadata != null && (insets = metadata.getInsets()) != null) {
                        margin -= insets.top;
                    }
                    rowHeightDp = this.mRule.getRulesEngine().pxToDp(margin);
                }
            }
            this.mGrid.splitRow(++row, insertMarginRow, rowHeightDp, this.mRowMatch.matchedLine);
            if (insertMarginRow) {
                ++row;
            }
        }
        if ((index = this.mGrid.getInsertIndex(row, column)) == -1) {
            newChild = targetNode.appendChild(fqcn);
        } else {
            GridModel.ViewData next = this.mGrid.getView(index);
            newChild = targetNode.insertChildAt(fqcn, index);
            next.applyPositionAttributes();
        }
        int gravity = 0;
        if (this.mColumnMatch.type == SegmentType.RIGHT) {
            gravity |= 2;
        } else if (this.mColumnMatch.type == SegmentType.CENTER_HORIZONTAL) {
            gravity |= 4;
        }
        this.mGrid.setGridAttribute(newChild, "layout_column", column);
        if (this.mRowMatch.type != SegmentType.BASELINE) {
            if (this.mRowMatch.type == SegmentType.BOTTOM) {
                gravity |= 0x80;
            } else if (this.mRowMatch.type == SegmentType.CENTER_VERTICAL) {
                gravity |= 0x10;
            }
        }
        if (!GravityHelper.isConstrainedHorizontally(gravity)) {
            gravity |= 1;
        }
        this.mGrid.setGridAttribute(newChild, "layout_gravity", GravityHelper.getGravity(gravity));
        this.mGrid.setGridAttribute(newChild, "layout_row", row);
        if (columnSpan > 1) {
            this.mGrid.setGridAttribute(newChild, "layout_columnSpan", columnSpan);
        }
        if (rowSpan > 1) {
            this.mGrid.setGridAttribute(newChild, "layout_rowSpan", rowSpan);
        }
        if (this.mGrid.actualColumnCount == 0) {
            this.mGrid.setGridAttribute(this.mGrid.layout, "columnCount", Math.max(1, column + 1));
        }
        return newChild;
    }

    public INode handleGridModeDrop(INode targetNode, IDragElement element) {
        String fqcn = element.getFqcn();
        INode newChild = targetNode.appendChild(fqcn);
        int column = this.mColumnMatch.cellIndex;
        if (this.mColumnMatch.createCell) {
            this.mGrid.addColumn(column, newChild, Integer.MIN_VALUE, false, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        int row = this.mRowMatch.cellIndex;
        if (this.mRowMatch.createCell) {
            this.mGrid.addRow(row, newChild, Integer.MIN_VALUE, false, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        this.mGrid.setGridAttribute(newChild, "layout_column", column);
        this.mGrid.setGridAttribute(newChild, "layout_row", row);
        int gravity = 0;
        if (this.mColumnMatch.type == SegmentType.RIGHT) {
            gravity |= 2;
        } else if (this.mColumnMatch.type == SegmentType.CENTER_HORIZONTAL) {
            gravity |= 4;
        }
        if (this.mRowMatch.type != SegmentType.BASELINE) {
            if (this.mRowMatch.type == SegmentType.BOTTOM) {
                gravity |= 0x80;
            } else if (this.mRowMatch.type == SegmentType.CENTER_VERTICAL) {
                gravity |= 0x10;
            }
        }
        if (!GravityHelper.isConstrainedHorizontally(gravity)) {
            gravity |= 1;
        }
        if (!GravityHelper.isConstrainedVertically(gravity)) {
            gravity |= 0x40;
        }
        this.mGrid.setGridAttribute(newChild, "layout_gravity", GravityHelper.getGravity(gravity));
        if (this.mGrid.declaredColumnCount == Integer.MIN_VALUE || this.mGrid.declaredColumnCount < column + 1) {
            this.mGrid.setGridAttribute(this.mGrid.layout, "columnCount", column + 1);
        }
        return newChild;
    }

    public GridMatch getColumnMatch() {
        return this.mColumnMatch;
    }

    public GridMatch getRowMatch() {
        return this.mRowMatch;
    }

    public GridModel getGrid() {
        return this.mGrid;
    }
}

