/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.build;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.io.FileOp;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.build.BuildHelper;
import org.eclipse.andmore.internal.build.Messages;
import org.eclipse.andmore.internal.build.SourceFileData;
import org.eclipse.andmore.internal.build.SourceProcessor;
import org.eclipse.andmore.internal.build.builders.BaseBuilder;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;

public class AidlProcessor
extends SourceProcessor {
    private static final String PROPERTY_COMPILE_AIDL = "compileAidl";
    private static Pattern sAidlPattern1 = Pattern.compile("^(.+?):(\\d+):?\\s(.+)$");
    private static final Set<String> EXTENSIONS = Collections.singleton("aidl");

    public AidlProcessor(IJavaProject javaProject, BuildToolInfo buildToolInfo, IFolder genFolder) {
        super(javaProject, buildToolInfo, genFolder);
    }

    @Override
    protected Set<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    protected String getSavePropertyName() {
        return PROPERTY_COMPILE_AIDL;
    }

    @Override
    protected void doCompileFiles(List<IFile> sources, BaseBuilder builder, IProject project, IAndroidTarget projectTarget, List<IPath> sourceFolders, List<IFile> notCompiledOut, List<File> libraryProjectsOut, IProgressMonitor monitor) throws CoreException {
        ArrayList<String> commandList = new ArrayList<String>(4 + sourceFolders.size() + libraryProjectsOut.size());
        commandList.add(this.getBuildToolInfo().getPath(BuildToolInfo.PathId.AIDL));
        commandList.add(AidlProcessor.quote("-p" + projectTarget.getPath(2)));
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath p : sourceFolders) {
            IFolder f = wsRoot.getFolder(p);
            if (!f.exists()) continue;
            commandList.add(AidlProcessor.quote("-I" + f.getLocation().toOSString()));
        }
        for (File libOut : libraryProjectsOut) {
            File aidlFile = new File(libOut, "aidl");
            if (!aidlFile.isDirectory()) continue;
            commandList.add(AidlProcessor.quote("-I" + aidlFile.getAbsolutePath()));
        }
        int index = commandList.size();
        String[] commands = commandList.toArray(new String[index + 2]);
        boolean verbose = AdtPrefs.getPrefs().getBuildVerbosity() == AdtPrefs.BuildVerbosity.VERBOSE;
        builder.removeMarkersFromResource((IResource)project, "org.eclipse.andmore.common.aidlProblem");
        IFolder genFolder = this.getGenFolder();
        IFolder projectOut = BaseProjectHelper.getAndroidOutputFolder(project);
        IFolder aidlOutFolder = projectOut.getFolder("aidl");
        if (!aidlOutFolder.exists()) {
            aidlOutFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        boolean success = false;
        for (IFile sourceFile : sources) {
            if (verbose) {
                String name = sourceFile.getName();
                IPath sourceFolderPath = this.getSourceFolderFor(sourceFile);
                if (sourceFolderPath != null) {
                    IPath relative = sourceFile.getFullPath().makeRelativeTo(sourceFolderPath);
                    name = relative.toString();
                }
                AndmoreAndroidPlugin.printToConsole(project, "AIDL: " + name);
            }
            builder.removeMarkersFromResource((IResource)sourceFile, "org.eclipse.andmore.common.aidlProblem");
            IPath sourcePath = sourceFile.getLocation();
            String osSourcePath = sourcePath.toOSString();
            SourceFileData data = this.getFileData(sourceFile);
            if (data == null) {
                data = new SourceFileData(sourceFile);
                this.addData(data);
            }
            if (data.getOutput() == null) {
                IFile javaFile = this.getAidlOutputFile(sourceFile, genFolder, true, true, monitor);
                data.setOutputFile(javaFile);
            }
            commands[index] = AidlProcessor.quote(osSourcePath);
            commands[index + 1] = AidlProcessor.quote(data.getOutput().getLocation().toOSString());
            if (!this.execAidl(builder, project, commands, sourceFile, verbose)) {
                notCompiledOut.add(sourceFile);
                continue;
            }
            this.setCompilationStatus(1);
            success = true;
            IFile aidlOutFile = this.getAidlOutputFile(sourceFile, aidlOutFolder, false, true, monitor);
            FileOp op = new FileOp();
            try {
                op.copyFile(sourceFile.getLocation().toFile(), aidlOutFile.getLocation().toFile());
            }
            catch (IOException iOException) {}
        }
        if (success) {
            aidlOutFolder.refreshLocal(2, monitor);
        }
    }

    @Override
    protected void loadOutputAndDependencies() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFolder genFolder = this.getGenFolder();
        Collection<SourceFileData> dataList = this.getAllFileData();
        for (SourceFileData data : dataList) {
            try {
                IFile javaFile = this.getAidlOutputFile(data.getSourceFile(), genFolder, true, false, (IProgressMonitor)monitor);
                data.setOutputFile(javaFile);
            }
            catch (CoreException coreException) {}
        }
    }

    private boolean execAidl(BaseBuilder builder, IProject project, String[] command, IFile file, boolean verbose) {
        String msg;
        int returnCode;
        block11: {
            if (verbose) {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = command;
                int n = command.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    sb.append(c);
                    sb.append(' ');
                    ++n2;
                }
                String cmd_line = sb.toString();
                AndmoreAndroidPlugin.printToConsole(project, cmd_line);
            }
            Process p = Runtime.getRuntime().exec(command);
            ArrayList<String> stdErr = new ArrayList<String>();
            returnCode = BuildHelper.grabProcessOutput(project, p, stdErr);
            if (stdErr.size() <= 0) break block11;
            boolean parsingError = this.parseAidlOutput(stdErr, file);
            if (returnCode != 0) {
                if (parsingError || verbose) {
                    if (parsingError) {
                        AndmoreAndroidPlugin.printErrorToConsole(project, stdErr.toArray());
                        BaseProjectHelper.markResource((IResource)project, "org.eclipse.andmore.common.aidlProblem", Messages.Unparsed_AIDL_Errors, 2);
                    } else {
                        AndmoreAndroidPlugin.printToConsole(project, stdErr.toArray());
                    }
                }
                return false;
            }
        }
        try {
            if (returnCode != 0) {
                String msg2 = String.format(Messages.AIDL_Exec_Error_d, returnCode);
                BaseProjectHelper.markResource((IResource)project, "org.eclipse.andmore.common.aidlProblem", msg2, 2);
                return false;
            }
        }
        catch (IOException iOException) {
            msg = String.format(Messages.AIDL_Exec_Error_s, command[0]);
            BaseProjectHelper.markResource((IResource)project, "org.eclipse.andmore.common.aidlProblem", msg, 2);
            return false;
        }
        catch (InterruptedException interruptedException) {
            msg = String.format(Messages.AIDL_Exec_Error_s, command[0]);
            BaseProjectHelper.markResource((IResource)project, "org.eclipse.andmore.common.aidlProblem", msg, 2);
            return false;
        }
        return true;
    }

    private boolean parseAidlOutput(ArrayList<String> lines, IFile file) {
        if (lines.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < lines.size()) {
            int line;
            String msg;
            String p = lines.get(i);
            Matcher m = sAidlPattern1.matcher(p);
            if (m.matches()) {
                String lineStr = m.group(2);
                msg = m.group(3);
                line = 0;
                try {
                    line = Integer.parseInt(lineStr);
                }
                catch (NumberFormatException numberFormatException) {
                    return true;
                }
            } else {
                return true;
            }
            BaseProjectHelper.markResource((IResource)file, "org.eclipse.andmore.common.aidlProblem", msg, line, 2);
            ++i;
        }
        return false;
    }

    private IFile getAidlOutputFile(IFile sourceFile, IFolder outputFolder, boolean replaceExt, boolean createFolders, IProgressMonitor monitor) throws CoreException {
        IPath sourceFolderPath = this.getSourceFolderFor(sourceFile);
        if (sourceFolderPath != null) {
            IPath relative = sourceFile.getFullPath().makeRelativeTo(sourceFolderPath);
            IFolder destinationFolder = outputFolder.getFolder(relative = relative.removeLastSegments(1));
            if (!destinationFolder.exists() && createFolders) {
                this.createFolder(destinationFolder, monitor);
            }
            String javaName = replaceExt ? sourceFile.getName().replaceAll("\\.aidl$", ".java") : sourceFile.getName();
            IFile javaFile = destinationFolder.getFile(javaName);
            return javaFile;
        }
        return null;
    }

    private void createFolder(IFolder destinationFolder, IProgressMonitor monitor) throws CoreException {
        IContainer parent = destinationFolder.getParent();
        if (parent.getType() == 2 && !parent.exists()) {
            this.createFolder((IFolder)parent, monitor);
        }
        destinationFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }

    private static AidlType getAidlType(IFile file) {
        return AidlType.UNKNOWN;
    }

    private static enum AidlType {
        UNKNOWN,
        INTERFACE,
        PARCELABLE;

    }
}

