/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.andmore.internal.editors.AndroidXmlAutoEditStrategy;
import org.eclipse.andmore.internal.editors.formatting.AndroidXmlFormatter;
import org.eclipse.andmore.internal.editors.formatting.AndroidXmlFormattingStrategy;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;

public abstract class AndroidSourceViewerConfig
extends StructuredTextViewerConfigurationXML {
    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        return super.getContentAssistant(sourceViewer);
    }

    public abstract IContentAssistProcessor getAndroidContentAssistProcessor(ISourceViewer var1, String var2);

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] others;
        IContentAssistProcessor processor;
        ArrayList<IContentAssistProcessor> processors = new ArrayList<IContentAssistProcessor>();
        if ((partitionType == "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE" || partitionType == "org.eclipse.wst.sse.ST_DEFAULT" || partitionType == "org.eclipse.wst.xml.XML_DEFAULT") && (processor = this.getAndroidContentAssistProcessor(sourceViewer, partitionType)) != null) {
            processors.add(processor);
        }
        if ((others = super.getContentAssistProcessors(sourceViewer, partitionType)) != null && others.length > 0) {
            IContentAssistProcessor[] iContentAssistProcessorArray = others;
            int n = others.length;
            int n2 = 0;
            while (n2 < n) {
                IContentAssistProcessor p = iContentAssistProcessorArray[n2];
                if (p instanceof XMLContentAssistProcessor || p.getClass().getSimpleName().equals("XMLStructuredContentAssistProcessor")) {
                    processors.add(new FilteringContentAssistProcessor(p));
                } else {
                    processors.add(p);
                }
                ++n2;
            }
        }
        if (processors.size() > 0) {
            return processors.toArray(new IContentAssistProcessor[processors.size()]);
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return super.getTextHover(sourceViewer, contentType);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] strategies = super.getAutoEditStrategies(sourceViewer, contentType);
        ArrayList<IAutoEditStrategy> s = new ArrayList<IAutoEditStrategy>(strategies.length + 1);
        s.add(new AndroidXmlAutoEditStrategy());
        IAutoEditStrategy[] iAutoEditStrategyArray = strategies;
        int n = strategies.length;
        int n2 = 0;
        while (n2 < n) {
            IAutoEditStrategy strategy = iAutoEditStrategyArray[n2];
            if (!(strategy instanceof DefaultAutoIndentStrategy)) {
                s.add(strategy);
            }
            ++n2;
        }
        return s.toArray(new IAutoEditStrategy[s.size()]);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        if (formatter instanceof MultiPassContentFormatter) {
            ((MultiPassContentFormatter)formatter).setMasterStrategy((IFormattingStrategy)new AndroidXmlFormattingStrategy());
            return formatter;
        }
        return new AndroidXmlFormatter();
    }

    protected Map<String, ?> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.andmore.xmlCode", null);
        return targets;
    }

    private static class FilteringContentAssistProcessor
    implements IContentAssistProcessor {
        private IContentAssistProcessor mDelegate;

        public FilteringContentAssistProcessor(IContentAssistProcessor delegate) {
            this.mDelegate = delegate;
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            ICompletionProposal[] result = this.mDelegate.computeCompletionProposals(viewer, offset);
            if (result == null) {
                return null;
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(result.length);
            ICompletionProposal[] iCompletionProposalArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                String replacement = proposal.getDisplayString();
                if (!(replacement.charAt(0) == '\"' && replacement.charAt(replacement.length() - 1) == '\"' || replacement.contains("Namespace") || replacement.startsWith("XSL ") || replacement.contains("Schema"))) {
                    proposals.add(proposal);
                }
                ++n2;
            }
            if (proposals.size() == result.length) {
                return result;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return this.mDelegate.computeContextInformation(viewer, offset);
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return this.mDelegate.getCompletionProposalAutoActivationCharacters();
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return this.mDelegate.getContextInformationAutoActivationCharacters();
        }

        public IContextInformationValidator getContextInformationValidator() {
            return this.mDelegate.getContextInformationValidator();
        }

        public String getErrorMessage() {
            return this.mDelegate.getErrorMessage();
        }
    }
}

