/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors;

import com.android.ide.common.api.IAttributeInfo;
import com.android.utils.XmlUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidContentAssist;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.IDescriptorProvider;
import org.eclipse.andmore.internal.editors.descriptors.TextAttributeDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class CompletionProposal
implements ICompletionProposal {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("[@?]android:attr/(.*)");
    private final AndroidContentAssist mAssist;
    private final Object mChoice;
    private final int mCursorPosition;
    private int mReplacementOffset;
    private final int mReplacementLength;
    private final String mReplacementString;
    private final Image mImage;
    private final String mDisplayString;
    private final IContextInformation mContextInformation;
    private final String mNsPrefix;
    private final String mNsUri;
    private String mAdditionalProposalInfo;

    CompletionProposal(AndroidContentAssist assist, Object choice, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, String nsPrefix, String nsUri) {
        assert (replacementString != null);
        assert (replacementOffset >= 0);
        assert (replacementLength >= 0);
        assert (cursorPosition >= 0);
        this.mAssist = assist;
        this.mChoice = choice;
        this.mCursorPosition = cursorPosition;
        this.mReplacementOffset = replacementOffset;
        this.mReplacementLength = replacementLength;
        this.mReplacementString = replacementString;
        this.mImage = image;
        this.mDisplayString = displayString;
        this.mContextInformation = contextInformation;
        this.mAdditionalProposalInfo = additionalProposalInfo;
        this.mNsPrefix = nsPrefix;
        this.mNsUri = nsUri;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.mReplacementOffset + this.mCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.mContextInformation;
    }

    public Image getImage() {
        return this.mImage;
    }

    public String getDisplayString() {
        if (this.mDisplayString != null) {
            return this.mDisplayString;
        }
        return this.mReplacementString;
    }

    public String getAdditionalProposalInfo() {
        if (this.mAdditionalProposalInfo == null) {
            if (this.mChoice instanceof ElementDescriptor) {
                String tooltip = ((ElementDescriptor)this.mChoice).getTooltip();
                this.mAdditionalProposalInfo = DescriptorsUtils.formatTooltip(tooltip);
            } else if (this.mChoice instanceof TextAttributeDescriptor) {
                this.mAdditionalProposalInfo = ((TextAttributeDescriptor)this.mChoice).getTooltip();
            } else if (this.mChoice instanceof String) {
                String value = (String)this.mChoice;
                Matcher matcher = ATTRIBUTE_PATTERN.matcher(value);
                if (matcher.matches()) {
                    IDescriptorProvider descriptorProvider;
                    String attrName = matcher.group(1);
                    AndroidTargetData data = this.mAssist.getEditor().getTargetData();
                    if (data != null && (descriptorProvider = data.getDescriptorProvider(this.mAssist.getRootDescriptorId())) != null) {
                        ElementDescriptor[] rootElementDescriptors;
                        ElementDescriptor[] elementDescriptorArray = rootElementDescriptors = descriptorProvider.getRootElementDescriptors();
                        int n = rootElementDescriptors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ElementDescriptor elementDesc = elementDescriptorArray[n2];
                            AttributeDescriptor[] attributeDescriptorArray = elementDesc.getAttributes();
                            int n3 = attributeDescriptorArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IAttributeInfo attributeInfo;
                                AttributeDescriptor desc = attributeDescriptorArray[n4];
                                String name = desc.getXmlLocalName();
                                if (attrName.equals(name) && (attributeInfo = desc.getAttributeInfo()) != null) {
                                    return attributeInfo.getJavaDoc();
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                }
            } else if (this.mChoice instanceof IType) {
                IType type = (IType)this.mChoice;
                try {
                    ISourceRange sourceRange;
                    ISourceRange javadocRange = type.getJavadocRange();
                    if (javadocRange != null && javadocRange.getLength() > 0 && (sourceRange = type.getSourceRange()) != null) {
                        String source = type.getSource();
                        int start = javadocRange.getOffset() - sourceRange.getOffset();
                        int length = javadocRange.getLength();
                        String doc = source.substring(start, start + length);
                        return doc;
                    }
                    return type.getAttachedJavadoc((IProgressMonitor)new NullProgressMonitor());
                }
                catch (JavaModelException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
            }
        }
        return this.mAdditionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            Element root;
            Document dom;
            Position position = new Position(this.mReplacementOffset);
            document.addPosition(position);
            String prefix = this.mNsPrefix;
            if (this.mNsUri != null && prefix != null && (dom = DomUtilities.getDocument(this.mAssist.getEditor())) != null && (root = dom.getDocumentElement()) != null) {
                boolean found = false;
                NamedNodeMap attributes = root.getAttributes();
                int i = 0;
                int n = attributes.getLength();
                while (i < n) {
                    Attr attribute = (Attr)attributes.item(i);
                    String name = attribute.getName();
                    if (name.startsWith("xmlns") && this.mNsUri.equals(attribute.getValue())) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    if (prefix.endsWith(":")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    XmlUtils.lookupNamespacePrefix((Node)root, (String)this.mNsUri, (String)prefix, (boolean)true);
                }
            }
            this.mReplacementOffset = position.getOffset();
            document.removePosition(position);
            document.replace(this.mReplacementOffset, this.mReplacementLength, this.mReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }
}

