/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.descriptors;

import com.android.ide.common.api.IAttributeInfo;
import com.android.resources.ResourceType;
import org.eclipse.andmore.common.resources.platform.AttributeInfo;
import org.eclipse.andmore.internal.editors.descriptors.ITextAttributeCreator;
import org.eclipse.andmore.internal.editors.descriptors.TextAttributeDescriptor;
import org.eclipse.andmore.internal.editors.ui.ResourceValueCellEditor;
import org.eclipse.andmore.internal.editors.uimodel.UiAttributeNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiResourceAttributeNode;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;

public final class ReferenceAttributeDescriptor
extends TextAttributeDescriptor {
    private ResourceType mResourceType;
    public static final ITextAttributeCreator CREATOR = new ITextAttributeCreator(){

        @Override
        public TextAttributeDescriptor create(String xmlLocalName, String nsUri, IAttributeInfo attrInfo) {
            return new ReferenceAttributeDescriptor(ResourceType.DRAWABLE, xmlLocalName, nsUri, new AttributeInfo(xmlLocalName, IAttributeInfo.Format.REFERENCE_SET));
        }
    };

    public ReferenceAttributeDescriptor(String xmlLocalName, String nsUri, IAttributeInfo attrInfo) {
        super(xmlLocalName, nsUri, attrInfo);
    }

    public ReferenceAttributeDescriptor(ResourceType resourceType, String xmlLocalName, String nsUri, IAttributeInfo attrInfo) {
        super(xmlLocalName, nsUri, attrInfo);
        this.mResourceType = resourceType;
    }

    public ResourceType getResourceType() {
        return this.mResourceType;
    }

    @Override
    public UiAttributeNode createUiNode(UiElementNode uiParent) {
        return new UiResourceAttributeNode(this.mResourceType, this, uiParent);
    }

    @Override
    public CellEditor createPropertyEditor(Composite parent) {
        return new ResourceValueCellEditor(parent);
    }
}

