/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import java.util.List;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasTransform;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.Overlay;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtDrawingStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class HoverOverlay
extends Overlay {
    private final LayoutCanvas mCanvas;
    private Color mHoverStrokeColor;
    private Color mHoverFillColor;
    private Color mHoverSelectStrokeColor;
    private Color mHoverSelectFillColor;
    private CanvasTransform mVScale;
    private CanvasTransform mHScale;
    private Rectangle mHoverRect;

    public HoverOverlay(LayoutCanvas canvas, CanvasTransform hScale, CanvasTransform vScale) {
        this.mCanvas = canvas;
        this.mHScale = hScale;
        this.mVScale = vScale;
    }

    @Override
    public void create(Device device) {
        if (SwtDrawingStyle.HOVER.getStrokeColor() != null) {
            this.mHoverStrokeColor = new Color(device, SwtDrawingStyle.HOVER.getStrokeColor());
        }
        if (SwtDrawingStyle.HOVER.getFillColor() != null) {
            this.mHoverFillColor = new Color(device, SwtDrawingStyle.HOVER.getFillColor());
        }
        if (SwtDrawingStyle.HOVER_SELECTION.getStrokeColor() != null) {
            this.mHoverSelectStrokeColor = new Color(device, SwtDrawingStyle.HOVER_SELECTION.getStrokeColor());
        }
        if (SwtDrawingStyle.HOVER_SELECTION.getFillColor() != null) {
            this.mHoverSelectFillColor = new Color(device, SwtDrawingStyle.HOVER_SELECTION.getFillColor());
        }
    }

    @Override
    public void dispose() {
        if (this.mHoverStrokeColor != null) {
            this.mHoverStrokeColor.dispose();
            this.mHoverStrokeColor = null;
        }
        if (this.mHoverFillColor != null) {
            this.mHoverFillColor.dispose();
            this.mHoverFillColor = null;
        }
        if (this.mHoverSelectStrokeColor != null) {
            this.mHoverSelectStrokeColor.dispose();
            this.mHoverSelectStrokeColor = null;
        }
        if (this.mHoverSelectFillColor != null) {
            this.mHoverSelectFillColor.dispose();
            this.mHoverSelectFillColor = null;
        }
    }

    public void setHover(int x, int y, int w, int h) {
        this.mHoverRect = new Rectangle(x, y, w, h);
    }

    public void clearHover() {
        this.mHoverRect = null;
    }

    @Override
    public void paint(GC gc) {
        if (this.mHoverRect != null) {
            int oldAlpha;
            Color fill;
            int x = this.mHScale.translate(this.mHoverRect.x);
            int y = this.mVScale.translate(this.mHoverRect.y);
            int w = this.mHScale.scale(this.mHoverRect.width);
            int h = this.mVScale.scale(this.mHoverRect.height);
            boolean hoverIsSelected = false;
            List<SelectionItem> selections = this.mCanvas.getSelectionManager().getSelections();
            for (SelectionItem item : selections) {
                if (!this.mHoverRect.equals((Object)item.getViewInfo().getSelectionRect())) continue;
                hoverIsSelected = true;
                break;
            }
            Color stroke = hoverIsSelected ? this.mHoverSelectStrokeColor : this.mHoverStrokeColor;
            Color color = fill = hoverIsSelected ? this.mHoverSelectFillColor : this.mHoverFillColor;
            if (stroke != null) {
                oldAlpha = gc.getAlpha();
                gc.setForeground(stroke);
                gc.setLineStyle(hoverIsSelected ? SwtDrawingStyle.HOVER_SELECTION.getLineStyle() : SwtDrawingStyle.HOVER.getLineStyle());
                gc.setAlpha(hoverIsSelected ? SwtDrawingStyle.HOVER_SELECTION.getStrokeAlpha() : SwtDrawingStyle.HOVER.getStrokeAlpha());
                gc.drawRectangle(x, y, w, h);
                gc.setAlpha(oldAlpha);
            }
            if (fill != null) {
                oldAlpha = gc.getAlpha();
                gc.setAlpha(hoverIsSelected ? SwtDrawingStyle.HOVER_SELECTION.getFillAlpha() : SwtDrawingStyle.HOVER.getFillAlpha());
                gc.setBackground(fill);
                gc.fillRectangle(x, y, w, h);
                gc.setAlpha(oldAlpha);
            }
        }
    }
}

