/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.INode;
import com.android.ide.common.api.RuleAction;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdkuilib.internal.widgets.ResolutionChooserDialog;
import com.google.common.base.Strings;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.common.layout.BaseViewRule;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.editors.layout.configuration.Configuration;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationChooser;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.gre.RulesEngine;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class LayoutActionBar
extends Composite {
    private GraphicalEditorPart mEditor;
    private ToolBar mLayoutToolBar;
    private ToolBar mLintToolBar;
    private ToolBar mZoomToolBar;
    private ToolItem mZoomRealSizeButton;
    private ToolItem mZoomOutButton;
    private ToolItem mZoomResetButton;
    private ToolItem mZoomInButton;
    private ToolItem mZoomFitButton;
    private ToolItem mLintButton;
    private List<RuleAction> mPrevActions;

    public LayoutActionBar(Composite parent, int style, GraphicalEditorPart editor) {
        super(parent, style | 0x80000);
        this.mEditor = editor;
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        this.mLayoutToolBar = new ToolBar((Composite)this, 8519936);
        this.mLayoutToolBar.setLayoutData((Object)new GridData(4, 1, true, false));
        this.mZoomToolBar = this.createZoomControls();
        this.mZoomToolBar.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        this.mLintToolBar = this.createLintControls();
        GridData lintData = new GridData(0x1000008, 1, false, false);
        lintData.exclude = true;
        this.mLintToolBar.setLayoutData((Object)lintData);
    }

    public void dispose() {
        super.dispose();
        this.mPrevActions = null;
    }

    void updateSelection() {
        NodeProxy node;
        NodeProxy parent = null;
        LayoutCanvas canvas = this.mEditor.getCanvasControl();
        SelectionManager selectionManager = canvas.getSelectionManager();
        List<SelectionItem> selections = selectionManager.getSelections();
        if (selections.size() > 0 && (node = selections.get(0).getNode()) != null && node.getParent() != null) {
            parent = (NodeProxy)node.getParent();
        }
        if (parent == null) {
            CanvasViewInfo root = canvas.getViewHierarchy().getRoot();
            if (root == null) {
                return;
            }
            parent = canvas.getNodeFactory().create(root);
            selections = Collections.emptyList();
        }
        RulesEngine engine = this.mEditor.getRulesEngine();
        ArrayList<NodeProxy> selectedNodes = new ArrayList<NodeProxy>();
        for (SelectionItem item : selections) {
            selectedNodes.add(item.getNode());
        }
        ArrayList<RuleAction> actions = new ArrayList<RuleAction>();
        engine.callAddLayoutActions(actions, parent, selectedNodes);
        Collections.sort(actions);
        int index = -1;
        String label = null;
        if (selectedNodes.size() == 1) {
            ArrayList<RuleAction> itemActions = new ArrayList<RuleAction>();
            NodeProxy selectedNode = (NodeProxy)selectedNodes.get(0);
            engine.callAddLayoutActions(itemActions, selectedNode, null);
            if (itemActions.size() > 0) {
                Collections.sort(itemActions);
                if (!(itemActions.get(0) instanceof RuleAction.Separator)) {
                    actions.add((RuleAction)RuleAction.createSeparator((int)0));
                }
                if ((label = selectedNode.getStringAttr("http://schemas.android.com/apk/res/android", "id")) != null) {
                    label = BaseViewRule.stripIdPrefix(label);
                    index = actions.size();
                }
                actions.addAll(itemActions);
            }
        }
        if (!this.updateActions(actions)) {
            this.updateToolbar(actions, index, label);
        }
        this.mPrevActions = actions;
    }

    private void updateToolbar(List<RuleAction> actions, int labelIndex, String label) {
        if (this.mLayoutToolBar == null || this.mLayoutToolBar.isDisposed()) {
            return;
        }
        ToolItem[] toolItemArray = this.mLayoutToolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem c = toolItemArray[n2];
            c.dispose();
            ++n2;
        }
        this.mLayoutToolBar.pack();
        this.addActions(actions, labelIndex, label);
        this.mLayoutToolBar.pack();
        this.mLayoutToolBar.layout();
    }

    private boolean updateActions(List<RuleAction> actions) {
        List<RuleAction> before = this.mPrevActions;
        List<RuleAction> after = actions;
        if (before == null) {
            return false;
        }
        if (!before.equals(after) || after.size() > this.mLayoutToolBar.getItemCount()) {
            return false;
        }
        int actionIndex = 0;
        int i = 0;
        int max = this.mLayoutToolBar.getItemCount();
        while (i < max) {
            ToolItem item = this.mLayoutToolBar.getItem(i);
            int style = item.getStyle();
            Object data = item.getData();
            if (data != null) {
                RuleAction prevAction = before.get(actionIndex);
                while (prevAction != data) {
                    if (++actionIndex == before.size()) {
                        return false;
                    }
                    prevAction = before.get(actionIndex);
                    if (prevAction == data) break;
                    if (prevAction instanceof RuleAction.Separator) continue;
                    return false;
                }
                RuleAction newAction = after.get(actionIndex);
                assert (newAction.equals((Object)prevAction));
                item.setData((Object)newAction);
                if ((style & 0x20) != 0) {
                    assert (newAction instanceof RuleAction.Toggle);
                    RuleAction.Toggle toggle = (RuleAction.Toggle)newAction;
                    item.setSelection(toggle.isChecked());
                } else if ((style & 0x10) != 0) {
                    assert (newAction instanceof RuleAction.Choices);
                    RuleAction.Choices choices = (RuleAction.Choices)newAction;
                    String current = choices.getCurrent();
                    String id = (String)item.getData("id");
                    boolean selected = Strings.nullToEmpty((String)current).equals(id);
                    item.setSelection(selected);
                }
            } else assert ((style & 2) != 0 || !item.getText().isEmpty()) : item;
            ++i;
        }
        return true;
    }

    private void addActions(List<RuleAction> actions, int labelIndex, String label) {
        if (actions.size() > 0) {
            boolean needSeparator = false;
            int index = 0;
            for (RuleAction action : actions) {
                if (index == labelIndex) {
                    ToolItem button = new ToolItem(this.mLayoutToolBar, 8);
                    button.setText(label);
                    needSeparator = false;
                }
                ++index;
                if (action instanceof RuleAction.Separator) {
                    LayoutActionBar.addSeparator(this.mLayoutToolBar);
                    needSeparator = false;
                    continue;
                }
                if (needSeparator) {
                    LayoutActionBar.addSeparator(this.mLayoutToolBar);
                    needSeparator = false;
                }
                if (action instanceof RuleAction.Choices) {
                    RuleAction.Choices choices = (RuleAction.Choices)action;
                    if (!choices.isRadio()) {
                        this.addDropdown(choices);
                        continue;
                    }
                    LayoutActionBar.addSeparator(this.mLayoutToolBar);
                    this.addRadio(choices);
                    needSeparator = true;
                    continue;
                }
                if (action instanceof RuleAction.Toggle) {
                    this.addToggle((RuleAction.Toggle)action);
                    continue;
                }
                this.addPlainAction(action);
            }
        }
    }

    private static void addSeparator(ToolBar toolBar) {
        int n = toolBar.getItemCount();
        if (n > 0 && (toolBar.getItem(n - 1).getStyle() & 2) == 0) {
            ToolItem separator = new ToolItem(toolBar, 2);
            separator.setWidth(15);
        }
    }

    private void addToggle(RuleAction.Toggle toggle) {
        final ToolItem button = new ToolItem(this.mLayoutToolBar, 32);
        URL iconUrl = toggle.getIconUrl();
        String title = toggle.getTitle();
        if (iconUrl != null) {
            button.setImage(IconFactory.getInstance().getIcon(iconUrl));
            button.setToolTipText(title);
        } else {
            button.setText(title);
        }
        button.setData((Object)toggle);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleAction.Toggle toggle = (RuleAction.Toggle)button.getData();
                toggle.getCallback().action((RuleAction)toggle, LayoutActionBar.this.getSelectedNodes(), toggle.getId(), Boolean.valueOf(button.getSelection()));
                LayoutActionBar.this.updateSelection();
            }
        });
        if (toggle.isChecked()) {
            button.setSelection(true);
        }
    }

    private List<INode> getSelectedNodes() {
        List<SelectionItem> selections = this.mEditor.getCanvasControl().getSelectionManager().getSelections();
        ArrayList<INode> nodes = new ArrayList<INode>(selections.size());
        for (SelectionItem item : selections) {
            nodes.add(item.getNode());
        }
        return nodes;
    }

    private void addPlainAction(RuleAction menuAction) {
        final ToolItem button = new ToolItem(this.mLayoutToolBar, 8);
        URL iconUrl = menuAction.getIconUrl();
        String title = menuAction.getTitle();
        if (iconUrl != null) {
            button.setImage(IconFactory.getInstance().getIcon(iconUrl));
            button.setToolTipText(title);
        } else {
            button.setText(title);
        }
        button.setData((Object)menuAction);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleAction menuAction = (RuleAction)button.getData();
                menuAction.getCallback().action(menuAction, LayoutActionBar.this.getSelectedNodes(), menuAction.getId(), Boolean.valueOf(false));
                LayoutActionBar.this.updateSelection();
            }
        });
    }

    private void addRadio(RuleAction.Choices choices) {
        String current;
        List icons = choices.getIconUrls();
        List titles = choices.getTitles();
        List ids = choices.getIds();
        String string = current = choices.getCurrent() != null ? choices.getCurrent() : "";
        assert (icons != null);
        assert (icons.size() == titles.size());
        int i = 0;
        while (i < icons.size()) {
            URL iconUrl = (URL)icons.get(i);
            String title = (String)titles.get(i);
            final String id = (String)ids.get(i);
            final ToolItem item = new ToolItem(this.mLayoutToolBar, 16);
            item.setToolTipText(title);
            item.setImage(IconFactory.getInstance().getIcon(iconUrl));
            item.setData((Object)choices);
            item.setData("id", (Object)id);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (item.getSelection()) {
                        RuleAction.Choices choices = (RuleAction.Choices)item.getData();
                        choices.getCallback().action((RuleAction)choices, LayoutActionBar.this.getSelectedNodes(), id, null);
                        LayoutActionBar.this.updateSelection();
                    }
                }
            });
            boolean selected = current.equals(id);
            if (selected) {
                item.setSelection(true);
            }
            ++i;
        }
    }

    private void addDropdown(RuleAction.Choices choices) {
        final ToolItem combo = new ToolItem(this.mLayoutToolBar, 4);
        URL iconUrl = choices.getIconUrl();
        if (iconUrl != null) {
            combo.setImage(IconFactory.getInstance().getIcon(iconUrl));
            combo.setToolTipText(choices.getTitle());
        } else {
            combo.setText(choices.getTitle());
        }
        combo.setData((Object)choices);
        Listener menuListener = new Listener(){

            public void handleEvent(Event event) {
                Menu menu = new Menu((Decorations)LayoutActionBar.this.mLayoutToolBar.getShell(), 8);
                RuleAction.Choices choices = (RuleAction.Choices)combo.getData();
                List icons = choices.getIconUrls();
                List titles = choices.getTitles();
                List ids = choices.getIds();
                String current = choices.getCurrent() != null ? choices.getCurrent() : "";
                int i = 0;
                while (i < titles.size()) {
                    boolean selected;
                    String title = (String)titles.get(i);
                    final String id = (String)ids.get(i);
                    URL itemIconUrl = icons != null && icons.size() > 0 ? (URL)icons.get(i) : null;
                    MenuItem item = new MenuItem(menu, 32);
                    item.setText(title);
                    if (itemIconUrl != null) {
                        Image itemIcon = IconFactory.getInstance().getIcon(itemIconUrl);
                        item.setImage(itemIcon);
                    }
                    if (selected = id.equals(current)) {
                        item.setSelection(true);
                    }
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RuleAction.Choices choices = (RuleAction.Choices)combo.getData();
                            choices.getCallback().action((RuleAction)choices, LayoutActionBar.this.getSelectedNodes(), id, null);
                            LayoutActionBar.this.updateSelection();
                        }
                    });
                    ++i;
                }
                Rectangle bounds = combo.getBounds();
                Point location = new Point(bounds.x, bounds.y + bounds.height);
                location = combo.getParent().toDisplay(location);
                menu.setLocation(location.x, location.y);
                menu.setVisible(true);
            }
        };
        combo.addListener(13, menuListener);
    }

    private ToolBar createZoomControls() {
        ToolBar toolBar = new ToolBar((Composite)this, 8519936);
        IconFactory iconFactory = IconFactory.getInstance();
        this.mZoomRealSizeButton = new ToolItem(toolBar, 32);
        this.mZoomRealSizeButton.setToolTipText("Emulate Real Size");
        this.mZoomRealSizeButton.setImage(iconFactory.getIcon("zoomreal"));
        this.mZoomRealSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = LayoutActionBar.this.mZoomRealSizeButton.getSelection();
                if (LayoutActionBar.this.rescaleToReal(newState)) {
                    LayoutActionBar.this.mZoomOutButton.setEnabled(!newState);
                    LayoutActionBar.this.mZoomResetButton.setEnabled(!newState);
                    LayoutActionBar.this.mZoomInButton.setEnabled(!newState);
                    LayoutActionBar.this.mZoomFitButton.setEnabled(!newState);
                } else {
                    LayoutActionBar.this.mZoomRealSizeButton.setSelection(!newState);
                }
            }
        });
        this.mZoomFitButton = new ToolItem(toolBar, 8);
        this.mZoomFitButton.setToolTipText("Zoom to Fit (0)");
        this.mZoomFitButton.setImage(iconFactory.getIcon("zoomfit"));
        this.mZoomFitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayoutActionBar.this.rescaleToFit(true);
            }
        });
        this.mZoomResetButton = new ToolItem(toolBar, 8);
        this.mZoomResetButton.setToolTipText("Reset Zoom to 100% (1)");
        this.mZoomResetButton.setImage(iconFactory.getIcon("zoom100"));
        this.mZoomResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayoutActionBar.this.resetScale();
            }
        });
        new ToolItem(toolBar, 2);
        this.mZoomOutButton = new ToolItem(toolBar, 8);
        this.mZoomOutButton.setToolTipText("Zoom Out (-)");
        this.mZoomOutButton.setImage(iconFactory.getIcon("zoomminus"));
        this.mZoomOutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayoutActionBar.this.rescale(-1);
            }
        });
        this.mZoomInButton = new ToolItem(toolBar, 8);
        this.mZoomInButton.setToolTipText("Zoom In (+)");
        this.mZoomInButton.setImage(iconFactory.getIcon("zoomplus"));
        this.mZoomInButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayoutActionBar.this.rescale(1);
            }
        });
        return toolBar;
    }

    private ToolBar createLintControls() {
        ToolBar toolBar = new ToolBar((Composite)this, 8519936);
        new ToolItem(toolBar, 2);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.mLintButton = new ToolItem(toolBar, 8);
        this.mLintButton.setToolTipText("Show Lint Warnings for this Layout");
        this.mLintButton.setImage(sharedImages.getImage("IMG_OBJS_WARN_TSK"));
        this.mLintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonXmlEditor editor = LayoutActionBar.this.mEditor.getEditorDelegate().getEditor();
                IFile file = editor.getInputFile();
                if (file != null) {
                    EclipseLintClient.showErrors(LayoutActionBar.this.getShell(), file, (IEditorPart)editor);
                }
            }
        });
        return toolBar;
    }

    public void updateErrorIndicator() {
        this.updateErrorIndicator(this.mEditor.getEditedFile());
    }

    public void updateErrorIndicator(IFile file) {
        IMarker[] markers = EclipseLintClient.getMarkers((IResource)file);
        this.updateErrorIndicator(markers.length);
    }

    private void updateErrorIndicator(final int markerCount) {
        Display display = this.getDisplay();
        if (display.getThread() != Thread.currentThread()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!LayoutActionBar.this.isDisposed()) {
                        LayoutActionBar.this.updateErrorIndicator(markerCount);
                    }
                }
            });
            return;
        }
        GridData layoutData = (GridData)this.mLintToolBar.getLayoutData();
        Integer existing = (Integer)this.mLintToolBar.getData();
        Integer current = markerCount;
        if (!current.equals(existing)) {
            boolean hasLintWarnings;
            this.mLintToolBar.setData((Object)current);
            boolean layout = false;
            boolean bl = hasLintWarnings = markerCount > 0 && AdtPrefs.getPrefs().isLintOnSave();
            if (layoutData.exclude == hasLintWarnings) {
                layoutData.exclude = !hasLintWarnings;
                this.mLintToolBar.setVisible(hasLintWarnings);
                layout = true;
            }
            if (markerCount > 0) {
                String iconName = "";
                switch (markerCount) {
                    case 1: {
                        iconName = "lint1";
                        break;
                    }
                    case 2: {
                        iconName = "lint2";
                        break;
                    }
                    case 3: {
                        iconName = "lint3";
                        break;
                    }
                    case 4: {
                        iconName = "lint4";
                        break;
                    }
                    case 5: {
                        iconName = "lint5";
                        break;
                    }
                    case 6: {
                        iconName = "lint6";
                        break;
                    }
                    case 7: {
                        iconName = "lint7";
                        break;
                    }
                    case 8: {
                        iconName = "lint8";
                        break;
                    }
                    case 9: {
                        iconName = "lint9";
                        break;
                    }
                    default: {
                        iconName = "lint9p";
                    }
                }
                this.mLintButton.setImage(IconFactory.getInstance().getIcon(iconName));
            }
            if (layout) {
                this.layout();
            }
            this.redraw();
        }
    }

    boolean isZoomingAllowed() {
        return this.mZoomInButton.isEnabled();
    }

    boolean isZoomingRealSize() {
        return this.mZoomRealSizeButton.getSelection();
    }

    void rescale(int direction) {
        LayoutCanvas canvas = this.mEditor.getCanvasControl();
        double s = canvas.getScale();
        s = direction > 0 ? (s *= 1.2) : (s /= 1.2);
        if (Math.abs(s - 1.0) < 1.0E-4) {
            s = 1.0;
        }
        canvas.setScale(s, true);
    }

    void resetScale() {
        this.mEditor.getCanvasControl().setScale(1.0, true);
    }

    void rescaleToFit(boolean onlyZoomOut) {
        this.mEditor.getCanvasControl().setFitScale(onlyZoomOut, true);
    }

    boolean rescaleToReal(boolean real) {
        if (real) {
            return this.computeAndSetRealScale(true);
        }
        this.mEditor.getCanvasControl().setScale(1.0, true);
        return true;
    }

    boolean computeAndSetRealScale(boolean redraw) {
        ConfigurationChooser chooser = this.mEditor.getConfigurationChooser();
        Configuration config = chooser.getConfiguration();
        Device device = config.getDevice();
        Screen screen = device.getDefaultHardware().getScreen();
        double dpi = (screen.getXdpi() + screen.getYdpi()) / 2.0;
        float monitor = AdtPrefs.getPrefs().getMonitorDensity();
        if (monitor == 0.0f) {
            ResolutionChooserDialog dialog = new ResolutionChooserDialog(chooser.getShell());
            if (dialog.open() == 0) {
                monitor = dialog.getDensity();
                AdtPrefs.getPrefs().setMonitorDensity(monitor);
            } else {
                return false;
            }
        }
        this.mEditor.getCanvasControl().setScale((double)monitor / dpi, redraw);
        return true;
    }
}

