/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;

public class LayoutWindowCoordinator
implements IPartListener2 {
    static final String PROPERTY_SHEET_PART_ID = "org.eclipse.ui.views.PropertySheet";
    static final String OUTLINE_PART_ID = "org.eclipse.ui.views.ContentOutline";
    private final IWorkbenchWindow mWindow;
    private boolean mPropertiesOpen;
    private boolean mOutlineOpen;
    private boolean mEditorMaximized;
    private boolean mInitialized;
    private static Map<IWorkbenchWindow, LayoutWindowCoordinator> sCoordinators = Maps.newHashMapWithExpectedSize((int)2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LayoutWindowCoordinator get(IWorkbenchWindow window, boolean create) {
        Class<LayoutWindowCoordinator> clazz = LayoutWindowCoordinator.class;
        synchronized (LayoutWindowCoordinator.class) {
            LayoutWindowCoordinator coordinator = sCoordinators.get(window);
            if (coordinator == null && create) {
                coordinator = new LayoutWindowCoordinator(window);
                IPartService service = window.getPartService();
                if (service != null) {
                    service.addPartListener((IPartListener2)coordinator);
                }
                sCoordinators.put(window, coordinator);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IPartService service = this.mWindow.getPartService();
        if (service != null) {
            service.removePartListener((IPartListener2)this);
        }
        Class<LayoutWindowCoordinator> clazz = LayoutWindowCoordinator.class;
        synchronized (LayoutWindowCoordinator.class) {
            sCoordinators.remove(this.mWindow);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isEditorMaximized() {
        return this.mEditorMaximized;
    }

    private LayoutWindowCoordinator(IWorkbenchWindow window) {
        this.mWindow = window;
        this.initialize();
    }

    private void initialize() {
        IWorkbenchPart part;
        if (this.mInitialized) {
            return;
        }
        IWorkbenchPage activePage = this.mWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        this.mInitialized = true;
        IViewReference ref = LayoutWindowCoordinator.findPropertySheetView(activePage);
        if (ref != null && activePage.isPartVisible(part = ref.getPart(false))) {
            this.mPropertiesOpen = true;
        }
        if ((ref = LayoutWindowCoordinator.findOutlineView(activePage)) != null && activePage.isPartVisible(part = ref.getPart(false))) {
            this.mOutlineOpen = true;
        }
        if (!this.syncMaximizedState(activePage)) {
            this.syncActive();
        }
    }

    static IViewReference findPropertySheetView(IWorkbenchPage activePage) {
        return activePage.findViewReference(PROPERTY_SHEET_PART_ID);
    }

    static IViewReference findOutlineView(IWorkbenchPage activePage) {
        return activePage.findViewReference(OUTLINE_PART_ID);
    }

    public boolean syncMaximizedState(IWorkbenchPage page) {
        boolean maximized = this.isPageZoomed(page);
        if (this.mEditorMaximized != maximized) {
            this.mEditorMaximized = maximized;
            this.syncActive();
            return true;
        }
        return false;
    }

    private boolean isPageZoomed(IWorkbenchPage page) {
        IWorkbenchPartReference reference = page.getActivePartReference();
        if (reference != null && reference instanceof IEditorReference) {
            int state = page.getPartState(reference);
            boolean maximized = (state & 1) != 0;
            return maximized;
        }
        return false;
    }

    private void sync(GraphicalEditorPart editor) {
        if (editor == null) {
            return;
        }
        if (this.mEditorMaximized) {
            editor.showStructureViews(true, true, true);
        } else if (this.mOutlineOpen) {
            editor.showStructureViews(false, false, true);
            editor.getCanvasControl().getOutlinePage().setShowPropertySheet(!this.mPropertiesOpen);
        } else {
            editor.showStructureViews(true, !this.mPropertiesOpen, true);
        }
    }

    private void sync(IWorkbenchPart part) {
        LayoutEditorDelegate editor;
        if (part instanceof AndroidXmlEditor && (editor = LayoutEditorDelegate.fromEditor((IEditorPart)part)) != null) {
            this.sync(editor.getGraphicalEditor());
        }
    }

    private void syncActive() {
        IWorkbenchPage activePage = this.mWindow.getActivePage();
        if (activePage != null) {
            IEditorPart editor = activePage.getActiveEditor();
            this.sync((IWorkbenchPart)editor);
        }
    }

    private void propertySheetClosed() {
        this.mPropertiesOpen = false;
        this.syncActive();
    }

    private void propertySheetOpened() {
        this.mPropertiesOpen = true;
        this.syncActive();
    }

    private void outlineClosed() {
        this.mOutlineOpen = false;
        this.syncActive();
    }

    private void outlineOpened() {
        this.mOutlineOpen = true;
        this.syncActive();
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        IWorkbenchPage activePage = this.mWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        this.initialize();
        String id = partRef.getId();
        if (PROPERTY_SHEET_PART_ID.equals(id)) {
            if (activePage.findViewReference(id) == null) {
                this.propertySheetClosed();
                return;
            }
        } else if (OUTLINE_PART_ID.equals(id) && activePage.findViewReference(id) == null) {
            this.outlineClosed();
            return;
        }
        this.syncMaximizedState(activePage);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPage activePage = this.mWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        this.initialize();
        String id = partRef.getId();
        if (this.mEditorMaximized) {
            this.mEditorMaximized = false;
            this.syncActive();
        }
        IWorkbenchPart part = partRef.getPart(false);
        this.sync(part);
        if (PROPERTY_SHEET_PART_ID.equals(id)) {
            if (!this.mPropertiesOpen) {
                this.propertySheetOpened();
                assert (this.mPropertiesOpen);
            }
        } else if (OUTLINE_PART_ID.equals(id) && !this.mOutlineOpen) {
            this.outlineOpened();
            assert (this.mOutlineOpen);
        }
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof AndroidXmlEditor) {
            ((AndroidXmlEditor)part).activated();
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof AndroidXmlEditor) {
            ((AndroidXmlEditor)part).deactivated();
        }
    }
}

