/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import java.util.List;
import org.eclipse.andmore.common.layout.BaseViewRule;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class LintTooltip
extends Shell {
    private final LayoutCanvas mCanvas;
    private final List<UiViewElementNode> mNodes;

    LintTooltip(LayoutCanvas canvas, List<UiViewElementNode> nodes) {
        super(canvas.getDisplay(), 540676);
        this.mCanvas = canvas;
        this.mNodes = nodes;
        this.createContents();
    }

    protected void createContents() {
        Display display = this.getDisplay();
        Color fg = display.getSystemColor(28);
        Color bg = display.getSystemColor(29);
        this.setBackground(bg);
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        LayoutEditorDelegate delegate = this.mCanvas.getEditorDelegate();
        boolean first = true;
        for (UiViewElementNode node : this.mNodes) {
            String id;
            String message;
            IMarker marker = delegate.getIssueForNode(node);
            if (marker == null || (message = marker.getAttribute("message", null)) == null) continue;
            Label icon = new Label((Composite)this, 0);
            icon.setForeground(fg);
            icon.setBackground(bg);
            icon.setImage(node.getIcon());
            Label label = new Label((Composite)this, 64);
            if (first) {
                label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
                first = false;
            }
            if ((id = BaseViewRule.stripIdPrefix(node.getAttributeValue("id"))).isEmpty()) {
                id = node.getXmlNode() != null ? node.getXmlNode().getNodeName() : node.getDescriptor().getUiName();
            }
            label.setText(String.format("%1$s: %2$s", id, message));
        }
    }

    protected void checkSubclass() {
    }
}

