/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import java.util.ArrayList;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.GlobalCanvasDragInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.OutlinePage;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleXmlTransfer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class OutlineDragListener
implements DragSourceListener {
    private TreeViewer mTreeViewer;
    private OutlinePage mOutlinePage;
    private final ArrayList<SelectionItem> mDragSelection = new ArrayList();
    private SimpleElement[] mDragElements;

    public OutlineDragListener(OutlinePage outlinePage, TreeViewer treeViewer) {
        this.mOutlinePage = outlinePage;
        this.mTreeViewer = treeViewer;
    }

    public void dragStart(DragSourceEvent e) {
        Tree tree = this.mTreeViewer.getTree();
        TreeItem overTreeItem = tree.getItem(new Point(e.x, e.y));
        if (overTreeItem == null) {
            e.doit = false;
            return;
        }
        CanvasViewInfo over = this.getViewInfo(overTreeItem);
        if (over == null) {
            e.doit = false;
            return;
        }
        final LayoutCanvas canvas = this.mOutlinePage.getEditor().getCanvasControl();
        SelectionManager selectionManager = canvas.getSelectionManager();
        TreeItem[] treeSelection = tree.getSelection();
        this.mDragSelection.clear();
        TreeItem[] treeItemArray = treeSelection;
        int n = treeSelection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            CanvasViewInfo viewInfo = this.getViewInfo(item);
            if (viewInfo != null) {
                this.mDragSelection.add(selectionManager.createSelection(viewInfo));
            }
            ++n2;
        }
        SelectionManager.sanitize(this.mDragSelection);
        e.doit = !this.mDragSelection.isEmpty();
        int imageCount = this.mDragSelection.size();
        if (e.doit) {
            this.mDragElements = SelectionItem.getAsElements(this.mDragSelection);
            GlobalCanvasDragInfo.getInstance().startDrag(this.mDragElements, this.mDragSelection.toArray(new SelectionItem[imageCount]), (Object)canvas, new Runnable(){

                @Override
                public void run() {
                    canvas.getClipboardSupport().deleteSelection("Remove", OutlineDragListener.this.mDragSelection);
                }
            });
            return;
        }
        e.detail = 0;
    }

    public void dragSetData(DragSourceEvent e) {
        if (TextTransfer.getInstance().isSupportedType(e.dataType)) {
            LayoutCanvas canvas = this.mOutlinePage.getEditor().getCanvasControl();
            e.data = SelectionItem.getAsText(canvas, this.mDragSelection);
            return;
        }
        if (SimpleXmlTransfer.getInstance().isSupportedType(e.dataType)) {
            e.data = this.mDragElements;
            return;
        }
        e.detail = 0;
        e.doit = false;
    }

    public void dragFinished(DragSourceEvent e) {
        this.mDragSelection.clear();
        this.mDragElements = null;
        GlobalCanvasDragInfo.getInstance().stopDrag();
    }

    private CanvasViewInfo getViewInfo(TreeItem item) {
        Object data = item.getData();
        if (data != null) {
            return OutlinePage.getViewInfo(data);
        }
        return null;
    }
}

