/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.properties;

import com.android.ide.common.api.IAttributeInfo;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.layout.BaseViewRule;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.ImageUtils;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.RenderService;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtUtils;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.properties.FlagXmlPropertyDialog;
import org.eclipse.andmore.internal.editors.layout.properties.StringXmlPropertyDialog;
import org.eclipse.andmore.internal.editors.layout.properties.XmlProperty;
import org.eclipse.andmore.internal.refactorings.core.RenameResourceWizard;
import org.eclipse.andmore.internal.refactorings.core.RenameResult;
import org.eclipse.andmore.internal.resources.ResourceHelper;
import org.eclipse.andmore.internal.resources.manager.ProjectResources;
import org.eclipse.andmore.internal.resources.manager.ResourceManager;
import org.eclipse.andmore.internal.ui.ReferenceChooserDialog;
import org.eclipse.andmore.internal.ui.ResourceChooser;
import org.eclipse.andmore.internal.ui.ResourcePreviewHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

class XmlPropertyEditor
extends AbstractTextPropertyEditor {
    public static final XmlPropertyEditor INSTANCE = new XmlPropertyEditor();
    private static final int SAMPLE_SIZE = 10;
    private static final int SAMPLE_MARGIN = 3;
    private final PropertyEditorPresentation mPresentation = new ButtonPropertyEditorPresentation(){

        protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
            XmlPropertyEditor.this.openDialog(propertyTable, property);
        }
    };
    private static final QualifiedName CACHE_NAME = new QualifiedName("org.eclipse.andmore", "property-images");

    protected XmlPropertyEditor() {
    }

    public PropertyEditorPresentation getPresentation() {
        return this.mPresentation;
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    public void paint(Property property, GC gc, int x, int y, int width, int height) throws Exception {
        String text = this.getText(property);
        if (text != null) {
            ResourceValue resValue = null;
            String resolvedText = null;
            if (text.startsWith("@") || text.startsWith("?")) {
                XmlProperty xmlProperty = (XmlProperty)property;
                GraphicalEditorPart graphicalEditor = xmlProperty.getGraphicalEditor();
                if (graphicalEditor != null) {
                    ResourceResolver resolver = graphicalEditor.getResourceResolver();
                    boolean isFramework = text.startsWith("@android:") || text.startsWith("?android:");
                    resValue = resolver.findResValue(text, isFramework);
                    while (resValue != null && resValue.getValue() != null) {
                        ResourceValue v;
                        String value = resValue.getValue();
                        if ((value.startsWith("@") || value.startsWith("?")) && (v = resolver.findResValue(text, isFramework = isFramework || value.startsWith("@android:") || value.startsWith("?android:"))) != null && !value.equals(v.getValue())) {
                            resValue = v;
                            continue;
                        }
                        break;
                    }
                }
            } else if (text.startsWith("#") && text.matches("#\\p{XDigit}+")) {
                resValue = new ResourceValue(ResourceType.COLOR, property.getName(), text, false);
            }
            if (resValue != null && resValue.getValue() != null) {
                String value = resValue.getValue();
                if (value.startsWith("#") || value.endsWith(".xml") && value.contains("res/color")) {
                    ResourceResolver resolver;
                    RGB rgb;
                    XmlProperty xmlProperty = (XmlProperty)property;
                    GraphicalEditorPart graphicalEditor = xmlProperty.getGraphicalEditor();
                    if (graphicalEditor != null && (rgb = ResourceHelper.resolveColor(resolver = graphicalEditor.getResourceResolver(), resValue)) != null) {
                        Color color = new Color(gc.getDevice(), rgb);
                        Color oldBackground = gc.getBackground();
                        Color oldForeground = gc.getForeground();
                        try {
                            int width_c = 10;
                            int height_c = 10;
                            int x_c = x;
                            int y_c = y + (height - height_c) / 2;
                            int delta = 13;
                            x += delta;
                            width -= delta;
                            gc.setBackground(color);
                            gc.fillRectangle(x_c, y_c, width_c, height_c);
                            gc.setForeground(IColorConstants.gray);
                            gc.drawRectangle(x_c, y_c, width_c, height_c);
                        }
                        finally {
                            gc.setBackground(oldBackground);
                            gc.setForeground(oldForeground);
                        }
                        color.dispose();
                    }
                } else {
                    Map<String, Image> cache;
                    Image swtImage = null;
                    if (value.endsWith(".xml") && value.contains("res/drawable")) {
                        cache = XmlPropertyEditor.getImageCache(property);
                        swtImage = cache.get(value);
                        if (swtImage == null) {
                            XmlProperty xmlProperty = (XmlProperty)property;
                            GraphicalEditorPart graphicalEditor = xmlProperty.getGraphicalEditor();
                            RenderService service = RenderService.create(graphicalEditor);
                            service.setOverrideRenderSize(10, 10);
                            BufferedImage drawable = service.renderDrawable(resValue);
                            if (drawable != null) {
                                swtImage = SwtUtils.convertToSwt(gc.getDevice(), drawable, true, -1);
                                cache.put(value, swtImage);
                            }
                        }
                    } else if (value.endsWith(".png")) {
                        cache = XmlPropertyEditor.getImageCache(property);
                        swtImage = cache.get(value);
                        if (swtImage == null) {
                            File file = new File(value);
                            if (file.exists()) {
                                try {
                                    BufferedImage awtImage = ImageIO.read(file);
                                    if (awtImage != null && awtImage.getWidth() > 0 && awtImage.getHeight() > 0 && (awtImage = ImageUtils.cropBlank(awtImage, null)) != null) {
                                        int imageWidth = awtImage.getWidth();
                                        int imageHeight = awtImage.getHeight();
                                        int maxWidth = 3 * height;
                                        if (imageWidth > maxWidth || imageHeight > height) {
                                            double scale = (double)height / (double)imageHeight;
                                            int scaledWidth = (int)((double)imageWidth * scale);
                                            if (scaledWidth > maxWidth) {
                                                scale = (double)maxWidth / (double)imageWidth;
                                            }
                                            awtImage = ImageUtils.scale(awtImage, scale, scale);
                                        }
                                        swtImage = SwtUtils.convertToSwt(gc.getDevice(), awtImage, true, -1);
                                    }
                                }
                                catch (IOException e) {
                                    AndmoreAndroidPlugin.log(e, value, new Object[0]);
                                }
                            }
                            cache.put(value, swtImage);
                        }
                    } else if (value != null && !value.equals(text) && !value.equals("@null")) {
                        resolvedText = value;
                    }
                    if (swtImage != null) {
                        ImageData imageData = swtImage.getImageData();
                        int imageWidth = imageData.width;
                        int imageHeight = imageData.height;
                        if (imageWidth > 0 && imageHeight > 0) {
                            gc.drawImage(swtImage, x, y + (height - imageHeight) / 2);
                            int delta = imageWidth + 3;
                            x += delta;
                            width -= delta;
                        }
                    }
                }
            }
            DrawUtils.drawStringCV((GC)gc, (String)text, (int)x, (int)y, (int)width, (int)height);
            if (resolvedText != null && resolvedText.length() > 0) {
                Point size = gc.stringExtent(text);
                x += size.x;
                width -= size.x;
                x += 3;
                if ((width -= 3) > 0) {
                    Color oldForeground = gc.getForeground();
                    try {
                        gc.setForeground(PropertyTable.COLOR_PROPERTY_FG_DEFAULT);
                        DrawUtils.drawStringCV((GC)gc, (String)(String.valueOf('(') + resolvedText + ')'), (int)x, (int)y, (int)width, (int)height);
                    }
                    finally {
                        gc.setForeground(oldForeground);
                    }
                }
            }
        }
    }

    protected boolean setEditorText(Property property, String text) throws Exception {
        Object oldValue = property.getValue();
        String old = oldValue != null ? oldValue.toString() : null;
        boolean isId = XmlPropertyEditor.isIdProperty(property);
        if (isId && !text.startsWith("@")) {
            text = "@+id/" + text;
        }
        if (isId && property instanceof XmlProperty && old != null && !old.isEmpty() && text != null && !text.isEmpty() && !text.equals(old)) {
            IProject project;
            CommonXmlEditor xmlEditor;
            XmlProperty xmlProperty = (XmlProperty)property;
            IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
            String refactorPref = store.getString("org.eclipse.andmore.refactorIds");
            boolean performRefactor = false;
            Shell shell = AndmoreAndroidPlugin.getShell();
            if (refactorPref == null || refactorPref.isEmpty() || refactorPref.equals("prompt")) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)"Update References?", (String)"Update all references as well? This will update all XML references and Java R field references.", (String)"Do not show again", (boolean)false, (IPreferenceStore)store, (String)"org.eclipse.andmore.refactorIds");
                switch (dialog.getReturnCode()) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        performRefactor = true;
                        break;
                    }
                    case 3: {
                        performRefactor = false;
                    }
                }
            } else {
                performRefactor = refactorPref.equals("always");
            }
            if (performRefactor && (xmlEditor = xmlProperty.getXmlEditor()) != null && (project = xmlEditor.getProject()) != null && shell != null) {
                RenameResourceWizard.renameResource(shell, project, ResourceType.ID, BaseViewRule.stripIdPrefix(old), BaseViewRule.stripIdPrefix(text), false);
            }
        }
        property.setValue((Object)text);
        return true;
    }

    private static boolean isIdProperty(Property property) {
        XmlProperty xmlProperty = (XmlProperty)property;
        return xmlProperty.getDescriptor().getXmlLocalName().equals("id");
    }

    private void openDialog(PropertyTable propertyTable, Property property) throws Exception {
        XmlProperty xmlProperty = (XmlProperty)property;
        IAttributeInfo attributeInfo = xmlProperty.getDescriptor().getAttributeInfo();
        if (XmlPropertyEditor.isIdProperty(property)) {
            GraphicalEditorPart editor;
            Object value = xmlProperty.getValue();
            if (value != null && !value.toString().isEmpty() && (editor = xmlProperty.getGraphicalEditor()) != null) {
                LayoutCanvas canvas = editor.getCanvasControl();
                SelectionManager manager = canvas.getSelectionManager();
                NodeProxy primary = canvas.getNodeFactory().create(xmlProperty.getNode());
                if (primary != null) {
                    RenameResult result = manager.performRename(primary, null);
                    if (result.isCanceled()) {
                        return;
                    }
                    if (!result.isUnavailable()) {
                        String name = result.getName();
                        String id = "@+id/" + BaseViewRule.stripIdPrefix(name);
                        xmlProperty.setValue(id);
                        return;
                    }
                }
            }
            attributeInfo = null;
        }
        boolean referenceAllowed = false;
        if (attributeInfo != null) {
            GraphicalEditorPart graphicalEditor;
            Object dialog;
            EnumSet formats = attributeInfo.getFormats();
            ResourceType type = null;
            ArrayList<ResourceType> types = null;
            if (formats.contains(IAttributeInfo.Format.FLAG)) {
                String[] flagValues = attributeInfo.getFlagValues();
                if (flagValues != null) {
                    dialog = new FlagXmlPropertyDialog(propertyTable.getShell(), "Select Flag Values", false, flagValues, xmlProperty);
                    dialog.open();
                    return;
                }
            } else if (formats.contains(IAttributeInfo.Format.ENUM)) {
                String[] enumValues = attributeInfo.getEnumValues();
                if (enumValues != null) {
                    dialog = new FlagXmlPropertyDialog(propertyTable.getShell(), "Select Enum Value", true, enumValues, xmlProperty);
                    dialog.open();
                    return;
                }
            } else {
                for (IAttributeInfo.Format format : formats) {
                    ResourceType t = format.getResourceType();
                    if (t != null) {
                        if (type != null) {
                            if (types == null) {
                                types = new ArrayList<ResourceType>();
                                types.add(type);
                            }
                            types.add(t);
                        }
                        type = t;
                        continue;
                    }
                    if (format != IAttributeInfo.Format.REFERENCE) continue;
                    referenceAllowed = true;
                }
            }
            if (types != null || referenceAllowed) {
                LayoutEditorDelegate delegate;
                IProject project;
                graphicalEditor = xmlProperty.getGraphicalEditor();
                if (graphicalEditor != null && (project = (delegate = graphicalEditor.getEditorDelegate()).getEditor().getProject()) != null) {
                    String resource;
                    ProjectResources projectRepository = ResourceManager.getInstance().getProjectResources(project);
                    Shell shell = AndmoreAndroidPlugin.getShell();
                    ReferenceChooserDialog dlg = new ReferenceChooserDialog(project, projectRepository, shell);
                    dlg.setPreviewHelper(new ResourcePreviewHelper((TrayDialog)dlg, graphicalEditor));
                    String currentValue = (String)property.getValue();
                    dlg.setCurrentResource(currentValue);
                    if (dlg.open() == 0 && (resource = dlg.getCurrentResource()) != null) {
                        if (resource.length() > 0) {
                            property.setValue((Object)resource);
                        } else {
                            property.setValue(null);
                        }
                    }
                    return;
                }
            } else if (type != null) {
                String currentValue;
                String resource;
                graphicalEditor = xmlProperty.getGraphicalEditor();
                if (graphicalEditor != null && (resource = ResourceChooser.chooseResource(graphicalEditor, type, currentValue = (String)property.getValue(), null)) != null) {
                    if (resource.length() > 0) {
                        property.setValue((Object)resource);
                    } else {
                        property.setValue(null);
                    }
                }
                return;
            }
        }
        StringXmlPropertyDialog dialog = new StringXmlPropertyDialog(propertyTable.getShell(), property);
        dialog.open();
    }

    private static Map<String, Image> getImageCache(Property property) {
        XmlProperty xmlProperty = (XmlProperty)property;
        GraphicalEditorPart graphicalEditor = xmlProperty.getGraphicalEditor();
        IProject project = graphicalEditor.getProject();
        try {
            Map cache = (Map)project.getSessionProperty(CACHE_NAME);
            if (cache == null) {
                cache = Maps.newHashMap();
                project.setSessionProperty(CACHE_NAME, (Object)cache);
            }
            return cache;
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return Maps.newHashMap();
        }
    }
}

