/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import com.android.ide.common.xml.XmlFormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoring;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoringWizard;
import org.eclipse.andmore.internal.editors.layout.refactoring.WrapInWizard;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class WrapInRefactoring
extends VisualRefactoring {
    private static final String KEY_ID = "name";
    private static final String KEY_TYPE = "type";
    private String mId;
    private String mTypeFqcn;
    private String mInitializedAttributes;

    WrapInRefactoring(Map<String, String> arguments) {
        super(arguments);
        this.mId = arguments.get(KEY_ID);
        this.mTypeFqcn = arguments.get(KEY_TYPE);
    }

    public WrapInRefactoring(IFile file, LayoutEditorDelegate delegate, ITextSelection selection, ITreeSelection treeSelection) {
        super(file, delegate, selection, treeSelection);
    }

    WrapInRefactoring(List<Element> selectedElements, LayoutEditorDelegate editor) {
        super(selectedElements, editor);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            pm.beginTask("Checking preconditions...", 6);
            if (this.mSelectionStart == -1 || this.mSelectionEnd == -1) {
                status.addFatalError("No selection to wrap");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mTreeSelection != null) {
                List<CanvasViewInfo> infos = this.getSelectedViewInfos();
                if (!this.validateNotEmpty(infos, status)) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
                if (!this.validateContiguous(infos, status)) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
            }
            if (this.mElements.size() == 0) {
                status.addFatalError("Nothing to wrap");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected VisualRefactoring.VisualRefactoringDescriptor createDescriptor() {
        String comment = this.getName();
        return new Descriptor(this.mProject.getName(), comment, comment, this.createArgumentMap());
    }

    @Override
    protected Map<String, String> createArgumentMap() {
        Map<String, String> args = super.createArgumentMap();
        args.put(KEY_TYPE, this.mTypeFqcn);
        args.put(KEY_ID, this.mId);
        return args;
    }

    public String getName() {
        return "Wrap in Container";
    }

    void setId(String id) {
        this.mId = id;
    }

    void setType(String typeFqcn) {
        this.mTypeFqcn = typeFqcn;
    }

    void setInitializedAttributes(String initializedAttributes) {
        this.mInitializedAttributes = initializedAttributes;
    }

    @Override
    protected List<Change> computeChanges(IProgressMonitor monitor) {
        MultiTextEdit formatted;
        String[] oldHeight;
        String indentUnit = "    ";
        boolean separateAttributes = true;
        IStructuredDocument document = this.mDelegate.getEditor().getStructuredDocument();
        String startIndent = AndroidXmlEditor.getIndentAtOffset((IDocument)document, this.mSelectionStart);
        String viewClass = this.getViewClass(this.mTypeFqcn);
        String androidNsPrefix = this.getAndroidNamespacePrefix();
        IFile file = this.mDelegate.getEditor().getInputFile();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (file == null) {
            return changes;
        }
        TextFileChange change = new TextFileChange(file.getName(), file);
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setTextType("xml");
        String id = this.ensureNewId(this.mId);
        if (id != null) {
            String rootId = this.getRootId();
            IStructuredModel model = this.mDelegate.getEditor().getModelForRead();
            try {
                IStructuredDocument doc = model.getStructuredDocument();
                if (doc != null) {
                    List<TextEdit> replaceIds = WrapInRefactoring.replaceIds(androidNsPrefix, doc, this.mSelectionStart, this.mSelectionEnd, rootId, id);
                    for (TextEdit edit : replaceIds) {
                        rootEdit.addChild(edit);
                    }
                }
            }
            finally {
                model.releaseFromRead();
            }
        }
        StringBuilder namespace = null;
        ArrayList<DeleteEdit> deletions = new ArrayList<DeleteEdit>();
        Element primary = this.getPrimaryElement();
        if (primary != null && this.getDomDocument().getDocumentElement() == primary) {
            namespace = new StringBuilder();
            List<Attr> declarations = WrapInRefactoring.findNamespaceAttributes(primary);
            for (Attr attribute : declarations) {
                if (!(attribute instanceof IndexedRegion)) continue;
                IndexedRegion region = (IndexedRegion)attribute;
                int startOffset = region.getStartOffset();
                int endOffset = region.getEndOffset();
                String text = this.getText(startOffset, endOffset);
                DeleteEdit deletion = new DeleteEdit(startOffset, endOffset - startOffset);
                deletions.add(deletion);
                rootEdit.addChild((TextEdit)deletion);
                text = text.trim();
                if (separateAttributes) {
                    namespace.append('\n').append(startIndent).append(indentUnit);
                } else {
                    namespace.append(' ');
                }
                namespace.append(text);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(viewClass);
        if (namespace != null) {
            sb.append((CharSequence)namespace);
        }
        if (id != null) {
            if (separateAttributes) {
                sb.append('\n').append(startIndent).append(indentUnit);
            } else {
                sb.append(' ');
            }
            sb.append(androidNsPrefix).append(':');
            sb.append("id").append('=').append('\"').append(id).append('\"');
        }
        String width = "wrap_content";
        String height = "wrap_content";
        for (Element element : this.getElements()) {
            String oldWidth = element.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_width");
            oldHeight = element.getAttributeNS("http://schemas.android.com/apk/res/android", "layout_height");
            if ("match_parent".equals(oldWidth) || "fill_parent".equals(oldWidth)) {
                width = oldWidth;
            }
            if (!"match_parent".equals(oldHeight) && !"fill_parent".equals(oldHeight)) continue;
            height = oldHeight;
        }
        if (separateAttributes) {
            sb.append('\n').append(startIndent).append(indentUnit);
        } else {
            sb.append(' ');
        }
        sb.append(androidNsPrefix).append(':');
        sb.append("layout_width").append('=').append('\"').append(width).append('\"');
        if (separateAttributes) {
            sb.append('\n').append(startIndent).append(indentUnit);
        } else {
            sb.append(' ');
        }
        sb.append(androidNsPrefix).append(':');
        sb.append("layout_height").append('=').append('\"').append(height).append('\"');
        if (this.mInitializedAttributes != null && this.mInitializedAttributes.length() > 0) {
            oldHeight = this.mInitializedAttributes.split(",");
            int oldWidth = oldHeight.length;
            int startOffset = 0;
            while (startOffset < oldWidth) {
                String s = oldHeight[startOffset];
                sb.append(' ');
                String[] nameValue = s.split("=");
                String name = nameValue[0];
                String value = nameValue[1];
                if (name.startsWith("android:")) {
                    name = name.substring("android:".length());
                    sb.append(androidNsPrefix).append(':');
                }
                sb.append(name).append('=').append('\"').append(value).append('\"');
                ++startOffset;
            }
        }
        if (primary != null) {
            List<Attr> layoutAttributes = this.findLayoutAttributes(primary);
            for (Attr attribute : layoutAttributes) {
                String name = attribute.getLocalName();
                if ((name.equals("layout_width") || name.equals("layout_height")) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) || !(attribute instanceof IndexedRegion)) continue;
                IndexedRegion region = (IndexedRegion)attribute;
                int startOffset = region.getStartOffset();
                int endOffset = region.getEndOffset();
                String text = this.getText(startOffset, endOffset);
                DeleteEdit deletion = new DeleteEdit(startOffset, endOffset - startOffset);
                rootEdit.addChild((TextEdit)deletion);
                deletions.add(deletion);
                if (separateAttributes) {
                    sb.append('\n').append(startIndent).append(indentUnit);
                } else {
                    sb.append(' ');
                }
                sb.append(text.trim());
            }
        }
        sb.append('>');
        sb.append('\n').append(startIndent).append(indentUnit);
        InsertEdit beginEdit = new InsertEdit(this.mSelectionStart, sb.toString());
        rootEdit.addChild((TextEdit)beginEdit);
        String nested = this.getText(this.mSelectionStart, this.mSelectionEnd);
        int index = 0;
        while (index != -1) {
            if ((index = nested.indexOf(10, index)) == -1) continue;
            InsertEdit newline = new InsertEdit(this.mSelectionStart + ++index, indentUnit);
            boolean covered = false;
            for (DeleteEdit deletion : deletions) {
                if (!deletion.covers((TextEdit)newline)) continue;
                covered = true;
                break;
            }
            if (covered) continue;
            rootEdit.addChild((TextEdit)newline);
        }
        sb.setLength(0);
        sb.append('\n').append(startIndent);
        sb.append('<').append('/').append(viewClass).append('>');
        InsertEdit endEdit = new InsertEdit(this.mSelectionEnd, sb.toString());
        rootEdit.addChild((TextEdit)endEdit);
        if (AdtPrefs.getPrefs().getFormatGuiXml() && (formatted = this.reformat(rootEdit, XmlFormatStyle.LAYOUT)) != null) {
            rootEdit = formatted;
        }
        change.setEdit((TextEdit)rootEdit);
        changes.add((Change)change);
        return changes;
    }

    String getOldType() {
        Element primary = this.getPrimaryElement();
        if (primary != null) {
            String oldType = primary.getTagName();
            if (oldType.indexOf(46) == -1) {
                oldType = "android.widget." + oldType;
            }
            return oldType;
        }
        return null;
    }

    @Override
    VisualRefactoringWizard createWizard() {
        return new WrapInWizard(this, this.mDelegate);
    }

    public static class Descriptor
    extends VisualRefactoring.VisualRefactoringDescriptor {
        public Descriptor(String project, String description, String comment, Map<String, String> arguments) {
            super("org.eclipse.andmore.refactoring.wrapin", project, description, comment, arguments);
        }

        @Override
        protected Refactoring createRefactoring(Map<String, String> args) {
            return new WrapInRefactoring(args);
        }
    }
}

