/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.internal.editors.AndroidContentAssist;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.w3c.dom.Node;

public final class ManifestContentAssist
extends AndroidContentAssist {
    public ManifestContentAssist() {
        super(1);
    }

    @Override
    protected boolean computeAttributeValues(List<ICompletionProposal> proposals, int offset, String parentTagName, String attributeName, Node node, String wordPrefix, boolean skipEndTag, int replaceLength) {
        if (attributeName.endsWith("minSdkVersion") || attributeName.endsWith("targetSdkVersion")) {
            IAndroidTarget[] targets;
            ArrayList<Pair> choices = new ArrayList<Pair>();
            int max = AdtUtils.getHighestKnownApiLevel();
            Sdk sdk = Sdk.getCurrent();
            if (sdk == null) {
                return false;
            }
            IAndroidTarget[] iAndroidTargetArray = targets = sdk.getTargets();
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IAndroidTarget target = iAndroidTargetArray[n2];
                AndroidVersion version = target.getVersion();
                int apiLevel = version.getApiLevel();
                if (apiLevel > max) {
                    if (version.isPreview()) {
                        choices.add(Pair.of((Object)version.getCodename(), (Object)version.getCodename()));
                    } else {
                        choices.add(Pair.of((Object)Integer.toString(apiLevel), (Object)target.getFullName()));
                    }
                }
                ++n2;
            }
            int api = max;
            while (api >= 1) {
                String name = AdtUtils.getAndroidName(api);
                choices.add(Pair.of((Object)Integer.toString(api), (Object)name));
                --api;
            }
            char needTag = '\u0000';
            this.addMatchingProposals(proposals, choices.toArray(), offset, node, wordPrefix, needTag, true, false, skipEndTag, replaceLength);
            return true;
        }
        return super.computeAttributeValues(proposals, offset, parentTagName, attributeName, node, wordPrefix, skipEndTag, replaceLength);
    }
}

