/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.pages;

import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IPageImageProvider;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.manifest.ManifestEditor;
import org.eclipse.andmore.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import org.eclipse.andmore.internal.editors.manifest.pages.ApplicationAttributesPart;
import org.eclipse.andmore.internal.editors.manifest.pages.ApplicationToggle;
import org.eclipse.andmore.internal.editors.ui.tree.UiTreeBlock;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class ApplicationPage
extends FormPage
implements IPageImageProvider {
    public static final String PAGE_ID = "application_page";
    ManifestEditor mEditor;
    private ApplicationToggle mTooglePart;
    private ApplicationAttributesPart mAttrPart;
    private UiTreeBlock mTreeBlock;

    public ApplicationPage(ManifestEditor editor) {
        super((FormEditor)editor, PAGE_ID, "Application");
        this.mEditor = editor;
    }

    @Override
    public Image getPageImage() {
        return IconFactory.getInstance().getIcon(this.getTitle(), 10, 82);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText("Android Manifest Application");
        form.setImage(AndmoreAndroidPlugin.getAndroidLogo());
        UiElementNode appUiNode = this.getUiApplicationNode();
        Composite body = form.getBody();
        FormToolkit toolkit = managedForm.getToolkit();
        this.mTooglePart = new ApplicationToggle(body, toolkit, this.mEditor, appUiNode);
        this.mTooglePart.getSection().setLayoutData((Object)new GridData(4, 128, true, false));
        managedForm.addPart((IFormPart)this.mTooglePart);
        this.mAttrPart = new ApplicationAttributesPart(body, toolkit, this.mEditor, appUiNode);
        this.mAttrPart.getSection().setLayoutData((Object)new GridData(4, 128, true, false));
        managedForm.addPart((IFormPart)this.mAttrPart);
        this.mTreeBlock = new UiTreeBlock(this.mEditor, appUiNode, false, null, "Application Nodes", "List of all elements in the application");
        this.mTreeBlock.createContent(managedForm);
    }

    private UiElementNode getUiApplicationNode() {
        AndroidManifestDescriptors manifestDescriptor = this.mEditor.getManifestDescriptors();
        if (manifestDescriptor != null) {
            ElementDescriptor desc = manifestDescriptor.getApplicationElement();
            return this.mEditor.getUiRootNode().findUiChildNode(desc.getXmlName());
        }
        return this.mEditor.getUiRootNode();
    }

    public void refreshUiApplicationNode() {
        UiElementNode appUiNode = this.getUiApplicationNode();
        if (this.mTooglePart != null) {
            this.mTooglePart.setUiElementNode(appUiNode);
        }
        if (this.mAttrPart != null) {
            this.mAttrPart.setUiElementNode(appUiNode);
        }
        if (this.mTreeBlock != null) {
            this.mTreeBlock.changeRootAndDescriptors(appUiNode, null, true);
        }
    }
}

