/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.ui.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.ui.tree.ICommitXml;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CopyCutAction
extends Action {
    private List<UiElementNode> mUiNodes;
    private boolean mPerformCut;
    private final AndroidXmlEditor mEditor;
    private final Clipboard mClipboard;
    private final ICommitXml mXmlCommit;

    public CopyCutAction(AndroidXmlEditor editor, Clipboard clipboard, ICommitXml xmlCommit, UiElementNode selected, boolean performCut) {
        this(editor, clipboard, xmlCommit, CopyCutAction.toList(selected), performCut);
    }

    public CopyCutAction(AndroidXmlEditor editor, Clipboard clipboard, ICommitXml xmlCommit, List<UiElementNode> selected, boolean performCut) {
        super(performCut ? "Cut" : "Copy");
        this.mEditor = editor;
        this.mClipboard = clipboard;
        this.mXmlCommit = xmlCommit;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        if (performCut) {
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_CUT"));
            this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_CUT_HOVER"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        } else {
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
            this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_HOVER"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        }
        this.mUiNodes = selected;
        this.mPerformCut = performCut;
    }

    public void run() {
        super.run();
        if (this.mUiNodes == null || this.mUiNodes.size() < 1) {
            return;
        }
        if (this.mXmlCommit != null) {
            this.mXmlCommit.commitPendingXmlChanges();
        }
        StringBuilder allText = new StringBuilder();
        ArrayList<UiElementNode> nodesToCut = this.mPerformCut ? new ArrayList<UiElementNode>() : null;
        for (UiElementNode uiNode : this.mUiNodes) {
            try {
                Node xml_node = uiNode.getXmlNode();
                if (xml_node == null) {
                    return;
                }
                String data = this.getXmlTextFromEditor(xml_node);
                if (data == null) {
                    data = this.getXmlTextFromSerialization(xml_node);
                }
                if (data == null) continue;
                allText.append(data);
                if (!this.mPerformCut) continue;
                nodesToCut.add(uiNode);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "CopyCutAction failed for UI node %1$s", uiNode.getBreadcrumbTrailDescription(true));
            }
        }
        if (allText != null && allText.length() > 0) {
            this.mClipboard.setContents(new Object[]{allText.toString()}, new Transfer[]{TextTransfer.getInstance()});
            if (this.mPerformCut) {
                for (UiElementNode uiNode : nodesToCut) {
                    uiNode.deleteXmlNode();
                }
            }
        }
    }

    private String getXmlTextFromEditor(Node xml_node) {
        String data = null;
        IStructuredModel model = this.mEditor.getModelForRead();
        try {
            try {
                IStructuredDocument sse_doc = this.mEditor.getStructuredDocument();
                if (xml_node instanceof NodeContainer) {
                    data = ((NodeContainer)xml_node).getSource();
                } else if (xml_node instanceof IndexedRegion && sse_doc != null) {
                    IndexedRegion region = (IndexedRegion)xml_node;
                    int start = region.getStartOffset();
                    int end = region.getEndOffset();
                    if (end > start) {
                        data = sse_doc.get(start, end - start);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                model.releaseFromRead();
            }
        }
        finally {
            model.releaseFromRead();
        }
        return data;
    }

    private String getXmlTextFromSerialization(Node xml_node) throws IOException {
        StringWriter sw = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)sw, new OutputFormat("xml", "UTF-8", true));
        serializer.serialize((Element)xml_node);
        String data = sw.toString();
        return data;
    }

    private static ArrayList<UiElementNode> toList(UiElementNode selected) {
        ArrayList<UiElementNode> list = null;
        if (selected != null) {
            list = new ArrayList<UiElementNode>(1);
            list.add(selected);
        }
        return list;
    }
}

