/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.CanceledException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.xml.ManifestData;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.utils.NullLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.ddms.DdmsPlugin;
import org.eclipse.andmore.internal.actions.AvdManagerAction;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.launch.AndroidLaunch;
import org.eclipse.andmore.internal.launch.AndroidLaunchConfiguration;
import org.eclipse.andmore.internal.launch.AvdCompatibility;
import org.eclipse.andmore.internal.launch.DelayedLaunchInfo;
import org.eclipse.andmore.internal.launch.DeviceChooserDialog;
import org.eclipse.andmore.internal.launch.IAndroidLaunchAction;
import org.eclipse.andmore.internal.launch.ILaunchController;
import org.eclipse.andmore.internal.launch.LaunchConfigDelegate;
import org.eclipse.andmore.internal.project.AndroidManifestHelper;
import org.eclipse.andmore.internal.project.ApkInstallManager;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public final class AndroidLaunchController
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener,
ILaunchController {
    private static final String FLAG_AVD = "-avd";
    private static final String FLAG_NETDELAY = "-netdelay";
    private static final String FLAG_NETSPEED = "-netspeed";
    private static final String FLAG_WIPE_DATA = "-wipe-data";
    private static final String FLAG_NO_BOOT_ANIM = "-no-boot-anim";
    private static final HashMap<ILaunchConfiguration, Integer> sRunningAppMap;
    private static final Object sListLock;
    private final ArrayList<DelayedLaunchInfo> mWaitingForEmulatorLaunches = new ArrayList();
    private final ArrayList<DelayedLaunchInfo> mWaitingForReadyEmulatorList = new ArrayList();
    private final ArrayList<DelayedLaunchInfo> mWaitingForDebuggerApplications = new ArrayList();
    private final ArrayList<Client> mUnknownClientsWaitingForDebugger = new ArrayList();
    private static AndroidLaunchController sThis;

    static {
        sListLock = sRunningAppMap = new HashMap();
        sThis = new AndroidLaunchController();
    }

    private AndroidLaunchController() {
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    public static AndroidLaunchController getInstance() {
        return sThis;
    }

    public static void debugRunningApp(IProject project, int debugPort) {
        ILaunchConfiguration config = AndroidLaunchController.getLaunchConfig(project, "org.eclipse.andmore.debug.LaunchConfigType");
        if (config != null) {
            AndroidLaunchController.setPortLaunchConfigAssociation(config, debugPort);
            DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
        }
    }

    public static ILaunchConfiguration getLaunchConfig(IProject project, String launchTypeId) {
        String name;
        ILaunchConfigurationType configType;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration config = AndroidLaunchController.findConfig(manager, configType = manager.getLaunchConfigurationType(launchTypeId), name = project.getName());
        if (config == null) {
            ILaunchConfigurationWorkingCopy wc = null;
            try {
                wc = configType.newInstance(null, manager.generateLaunchConfigurationName(name));
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
                wc.setAttribute("org.eclipse.andmore.action", 0);
                wc.setAttribute("org.eclipse.andmore.target", LaunchConfigDelegate.DEFAULT_TARGET_MODE.toString());
                wc.setAttribute("org.eclipse.andmore.avd", null);
                wc.setAttribute("org.eclipse.andmore.speed", 0);
                wc.setAttribute("org.eclipse.andmore.delay", 0);
                wc.setAttribute("org.eclipse.andmore.wipedata", false);
                wc.setAttribute("org.eclipse.andmore.nobootanim", false);
                IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
                String emuOptions = store.getString("org.eclipse.andmore.emuOptions");
                wc.setAttribute("org.eclipse.andmore.commandline", emuOptions);
                wc.setMappedResources(AndroidLaunchController.getResourcesToMap(project));
                return wc.doSave();
            }
            catch (CoreException e) {
                String msg = String.format("Failed to create a Launch config for project '%1$s': %2$s", project.getName(), e.getMessage());
                AndmoreAndroidPlugin.printErrorToConsole(project, new Object[]{msg});
                return null;
            }
        }
        return config;
    }

    public static IResource[] getResourcesToMap(IProject project) {
        ArrayList<Object> array = new ArrayList<Object>(2);
        array.add(project);
        IFile manifest = ProjectHelper.getManifest(project);
        if (manifest != null) {
            array.add(manifest);
        }
        return array.toArray(new IResource[array.size()]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(final IProject project, String mode, IFile apk, String packageName, String debugPackageName, Boolean debuggable, String requiredApiVersionNumber, IAndroidLaunchAction launchAction, final AndroidLaunchConfiguration config, final AndroidLaunch launch, IProgressMonitor monitor) {
        block30: {
            block29: {
                block27: {
                    block28: {
                        message = String.format("Performing %1$s", new Object[]{launchAction.getLaunchDescription()});
                        AndmoreAndroidPlugin.printToConsole(project, new Object[]{message});
                        launchInfo = new DelayedLaunchInfo(project, packageName, debugPackageName, launchAction, apk, debuggable, requiredApiVersionNumber, launch, monitor);
                        launchInfo.setDebugMode(mode.equals("debug"));
                        currentSdk = Sdk.getCurrent();
                        avdManager = currentSdk.getAvdManager();
                        try {
                            avdManager.reloadAvds(NullLogger.getLogger());
                        }
                        catch (AndroidLocation.AndroidLocationException v0) {
                            config.mTargetMode = AndroidLaunchConfiguration.TargetMode.MANUAL;
                        }
                        projectTarget = currentSdk.getTarget(project);
                        mi = ManifestInfo.get(project);
                        minApiLevel = mi.getMinSdkVersion();
                        minApiCodeName = mi.getMinSdkCodeName();
                        minApiVersion = new AndroidVersion(minApiLevel, minApiCodeName);
                        response = new DeviceChooserDialog.DeviceChooserResponse();
                        devices = AndroidDebugBridge.getBridge().getDevices();
                        if (config.mReuseLastUsedDevice && (lastUsedDevice = AndroidLaunchController.getDeviceIfOnline(config.mLastUsedDevice, devices)) != null) {
                            response.setDeviceToUse(lastUsedDevice);
                            this.continueLaunch(response, project, launch, launchInfo, config);
                            return;
                        }
                        if (config.mTargetMode != AndroidLaunchConfiguration.TargetMode.AUTO) break block27;
                        preferredAvd = null;
                        if (config.mAvdName != null) {
                            preferredAvd = avdManager.getAvd(config.mAvdName, true);
                        }
                        if (preferredAvd != null && (preferredAvdTarget = preferredAvd.getTarget()) != null && !preferredAvdTarget.getVersion().canRun(minApiVersion)) {
                            preferredAvd = null;
                            AndmoreAndroidPlugin.printErrorToConsole(project, new Object[]{String.format("Preferred AVD '%1$s' (API Level: %2$d) cannot run application with minApi %3$s. Looking for a compatible AVD...", new Object[]{config.mAvdName, preferredAvdTarget.getVersion().getApiLevel(), minApiVersion})});
                        }
                        if (preferredAvd == null) break block28;
                        var27_28 = devices;
                        var26_32 = devices.length;
                        var25_34 = 0;
                        if (true) ** GOTO lbl61
                    }
                    if (minApiCodeName == null || minApiLevel >= projectTarget.getVersion().getApiLevel()) break block29;
                    maxDist = projectTarget.getVersion().getApiLevel() - minApiLevel;
                    candidate = null;
                    var29_41 = currentSdk.getTargets();
                    deviceAvd = var29_41.length;
                    var27_29 = 0;
                    if (true) ** GOTO lbl72
                }
                if ((config.mTargetMode == AndroidLaunchConfiguration.TargetMode.ALL_DEVICES_AND_EMULATORS || config.mTargetMode == AndroidLaunchConfiguration.TargetMode.ALL_DEVICES || config.mTargetMode == AndroidLaunchConfiguration.TargetMode.ALL_EMULATORS) && "run".equals(mode)) {
                    includeDevices = config.mTargetMode != AndroidLaunchConfiguration.TargetMode.ALL_EMULATORS;
                    compatibleDevices = this.findCompatibleDevices(devices, minApiVersion, includeDevices, includeAvds = config.mTargetMode != AndroidLaunchConfiguration.TargetMode.ALL_DEVICES);
                    if (compatibleDevices.size() == 0) {
                        AndmoreAndroidPlugin.printErrorToConsole(project, new Object[]{"No active compatible AVD's or devices found. Relaunch this configuration after connecting a device or starting an AVD."});
                        this.stopLaunch(launchInfo);
                        return;
                    }
                    this.multiLaunch(launchInfo, compatibleDevices);
                    return;
                }
                break block30;
                do {
                    if ((deviceAvd = (d = var27_28[var25_34]).getAvdName()) != null && deviceAvd.equals(config.mAvdName)) {
                        response.setDeviceToUse(d);
                        AndmoreAndroidPlugin.printToConsole(project, new Object[]{String.format("Automatic Target Mode: Preferred AVD '%1$s' is available on emulator '%2$s'", new Object[]{config.mAvdName, d})});
                        this.continueLaunch(response, project, launch, launchInfo, config);
                        return;
                    }
                    ++var25_34;
lbl61:
                    // 2 sources

                } while (var25_34 < var26_32);
                response.setAvdToLaunch(preferredAvd);
                AndmoreAndroidPlugin.printToConsole(project, new Object[]{String.format("Automatic Target Mode: Preferred AVD '%1$s' is not available. Launching new emulator.", new Object[]{config.mAvdName})});
                this.continueLaunch(response, project, launch, launchInfo, config);
                return;
                do {
                    if ((target = var29_41[var27_29]).canRunOn(projectTarget) && (currDist = target.getVersion().getApiLevel() - minApiLevel) >= 0 && currDist < maxDist) {
                        maxDist = currDist;
                        candidate = target;
                        if (maxDist == 0) break;
                    }
                    ++var27_29;
lbl72:
                    // 2 sources

                } while (var27_29 < deviceAvd);
                if (candidate != null) {
                    projectTarget = candidate;
                }
            }
            compatibleRunningAvds = new HashMap<IDevice, AvdInfo>();
            hasDevice = false;
            var29_41 = devices;
            deviceAvd = devices.length;
            var27_29 = 0;
            while (var27_29 < deviceAvd) {
                d = var29_41[var27_29];
                deviceAvd = d.getAvdName();
                if (deviceAvd != null) {
                    info = avdManager.getAvd(deviceAvd, true);
                    if (AvdCompatibility.canRun(info, projectTarget, minApiVersion) == AvdCompatibility.Compatibility.YES) {
                        compatibleRunningAvds.put(d, info);
                    }
                } else if (projectTarget.isPlatform() && (deviceVersion = Sdk.getDeviceVersion(d)) != null && deviceVersion.canRun(projectTarget.getVersion())) {
                    compatibleRunningAvds.put(d, null);
                } else {
                    hasDevice = true;
                }
                ++var27_29;
            }
            if (!hasDevice && compatibleRunningAvds.size() == 0) {
                defaultAvd = this.findMatchingAvd(avdManager, projectTarget, minApiVersion);
                if (defaultAvd != null) {
                    response.setAvdToLaunch(defaultAvd);
                    AndmoreAndroidPlugin.printToConsole(project, new Object[]{String.format("Automatic Target Mode: launching new emulator with compatible AVD '%1$s'", new Object[]{defaultAvd.getName()})});
                    this.continueLaunch(response, project, launch, launchInfo, config);
                    return;
                }
                AndmoreAndroidPlugin.printToConsole(project, new Object[]{String.format("Failed to find an AVD compatible with target '%1$s'.", new Object[]{projectTarget.getName()})});
                display = AndmoreAndroidPlugin.getDisplay();
                searchAgain = new boolean[1];
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = display.getActiveShell();
                        if (MessageDialog.openQuestion((Shell)shell, (String)"Android AVD Error", (String)"No compatible targets were found. Do you wish to add a new Android Virtual Device?")) {
                            AvdManagerAction action = new AvdManagerAction();
                            action.run(null);
                            searchAgain[0] = true;
                        }
                    }
                });
                if (searchAgain[0]) {
                    defaultAvd = this.findMatchingAvd(avdManager, projectTarget, minApiVersion);
                    if (defaultAvd != null) {
                        response.setAvdToLaunch(defaultAvd);
                        AndmoreAndroidPlugin.printToConsole(project, new Object[]{String.format("Launching new emulator with compatible AVD '%1$s'", new Object[]{defaultAvd.getName()})});
                        this.continueLaunch(response, project, launch, launchInfo, config);
                        return;
                    }
                    AndmoreAndroidPlugin.printErrorToConsole(project, new Object[]{String.format("Still no compatible AVDs with target '%1$s': Aborting launch.", new Object[]{projectTarget.getName()})});
                    this.stopLaunch(launchInfo);
                }
            } else if (!hasDevice && compatibleRunningAvds.size() == 1) {
                e = compatibleRunningAvds.entrySet().iterator().next();
                response.setDeviceToUse((IDevice)e.getKey());
                avdInfo = (AvdInfo)e.getValue();
                message = avdInfo != null ? String.format("Automatic Target Mode: using existing emulator '%1$s' running compatible AVD '%2$s'", new Object[]{response.getDeviceToUse(), ((AvdInfo)e.getValue()).getName()}) : String.format("Automatic Target Mode: using device '%1$s'", new Object[]{response.getDeviceToUse()});
                AndmoreAndroidPlugin.printToConsole(project, new Object[]{message});
                this.continueLaunch(response, project, launch, launchInfo, config);
                return;
            }
            if (compatibleRunningAvds.size() >= 2) {
                message = "Automatic Target Mode: Several compatible targets. Please select a target device.";
            } else if (hasDevice) {
                message = "Automatic Target Mode: Unable to detect device compatibility. Please select a target device.";
            }
            AndmoreAndroidPlugin.printToConsole(project, new Object[]{message});
        }
        desiredProjectTarget = projectTarget;
        continueLaunch = new AtomicBoolean(false);
        AndmoreAndroidPlugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DeviceChooserDialog dialog = new DeviceChooserDialog(AndmoreAndroidPlugin.getShell(), response, launchInfo.getPackageName(), desiredProjectTarget, minApiVersion, config.mReuseLastUsedDevice);
                    if (dialog.open() != 0) {
                        AndmoreAndroidPlugin.printErrorToConsole(project, new Object[]{"Launch canceled!"});
                        AndroidLaunchController.this.stopLaunch(launchInfo);
                        return;
                    }
                    AndroidLaunchController.updateLaunchConfigWithLastUsedDevice(launch.getLaunchConfiguration(), response);
                    continueLaunch.set(true);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.getClass().getCanonicalName();
                    }
                    AndmoreAndroidPlugin.printErrorToConsole(project, new Object[]{String.format("Error during launch: %s", msg)});
                    AndroidLaunchController.this.stopLaunch(launchInfo);
                }
            }
        });
        if (continueLaunch.get() == false) return;
        this.continueLaunch(response, project, launch, launchInfo, config);
    }

    private Collection<IDevice> findCompatibleDevices(IDevice[] devices, AndroidVersion requiredVersion, boolean includeDevices, boolean includeAvds) {
        HashSet<IDevice> compatibleDevices = new HashSet<IDevice>(devices.length);
        AvdManager avdManager = Sdk.getCurrent().getAvdManager();
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                boolean canRun;
                IDevice d;
                block10: {
                    block8: {
                        d = iDeviceArray[n2];
                        boolean isEmulator = d.isEmulator();
                        canRun = false;
                        if (!isEmulator) break block8;
                        if (!includeAvds) break block9;
                        AvdInfo avdInfo = avdManager.getAvd(d.getAvdName(), true);
                        if (avdInfo != null && avdInfo.getTarget() != null) {
                            canRun = avdInfo.getTarget().getVersion().canRun(requiredVersion);
                        }
                        break block10;
                    }
                    if (!includeDevices) break block9;
                    AndroidVersion deviceVersion = Sdk.getDeviceVersion(d);
                    if (deviceVersion != null) {
                        canRun = deviceVersion.canRun(requiredVersion);
                    }
                }
                if (canRun) {
                    compatibleDevices.add(d);
                }
            }
            ++n2;
        }
        return compatibleDevices;
    }

    private AvdInfo findMatchingAvd(AvdManager avdManager, IAndroidTarget projectTarget, AndroidVersion minApiVersion) {
        AvdInfo[] avds = avdManager.getValidAvds();
        AvdInfo bestAvd = null;
        AvdInfo[] avdInfoArray = avds;
        int n = avds.length;
        int n2 = 0;
        while (n2 < n) {
            AvdInfo avd = avdInfoArray[n2];
            if (AvdCompatibility.canRun(avd, projectTarget, minApiVersion) == AvdCompatibility.Compatibility.YES && (bestAvd == null || avd.getTarget().getVersion().getApiLevel() < bestAvd.getTarget().getVersion().getApiLevel())) {
                bestAvd = avd;
            }
            ++n2;
        }
        return bestAvd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continueLaunch(DeviceChooserDialog.DeviceChooserResponse response, IProject project, AndroidLaunch launch, DelayedLaunchInfo launchInfo, AndroidLaunchConfiguration config) {
        if (response.getAvdToLaunch() != null) {
            Object object = sListLock;
            synchronized (object) {
                AvdInfo info = response.getAvdToLaunch();
                this.mWaitingForEmulatorLaunches.add(launchInfo);
                AndmoreAndroidPlugin.printToConsole(project, String.format("Launching a new emulator with Virtual Device '%1$s'", info.getName()));
                boolean status = this.launchEmulator(config, info);
                if (!status) {
                    AndmoreAndroidPlugin.displayError("Emulator Launch", "Couldn't launch the emulator! Make sure the SDK directory is properly setup and the emulator is not missing.");
                    this.mWaitingForEmulatorLaunches.remove(launchInfo);
                    AndmoreAndroidPlugin.printErrorToConsole(project, new Object[]{"Launch canceled!"});
                    this.stopLaunch(launchInfo);
                    return;
                }
                return;
            }
        }
        if (response.getDeviceToUse() != null) {
            launchInfo.setDevice(response.getDeviceToUse());
            this.simpleLaunch(launchInfo, launchInfo.getDevice());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getPortForConfig(ILaunchConfiguration launchConfig) {
        Object object = sListLock;
        synchronized (object) {
            Integer port = sRunningAppMap.get(launchConfig);
            if (port != null) {
                sRunningAppMap.remove(launchConfig);
                return port;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPortLaunchConfigAssociation(ILaunchConfiguration launchConfig, int port) {
        Object object = sListLock;
        synchronized (object) {
            sRunningAppMap.put(launchConfig, port);
        }
    }

    private boolean checkBuildInfo(DelayedLaunchInfo launchInfo, IDevice device) {
        if (device != null) {
            String debuggableDevice;
            String deviceVersion = device.getProperty("ro.build.version.release");
            String deviceApiLevelString = device.getProperty("ro.build.version.sdk");
            String deviceCodeName = device.getProperty("ro.build.version.codename");
            int deviceApiLevel = -1;
            try {
                deviceApiLevel = Integer.parseInt(deviceApiLevelString);
            }
            catch (NumberFormatException numberFormatException) {}
            String requiredApiString = launchInfo.getRequiredApiVersionNumber();
            if (requiredApiString != null) {
                int requiredApi = -1;
                try {
                    requiredApi = Integer.parseInt(requiredApiString);
                }
                catch (NumberFormatException numberFormatException) {}
                if (requiredApi == -1) {
                    if (!requiredApiString.equals(deviceCodeName)) {
                        AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("ERROR: Application requires a device running '%1$s'!", requiredApiString)});
                        return false;
                    }
                } else if (deviceApiLevel == -1) {
                    AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), "WARNING: Unknown device API version!");
                } else if (deviceApiLevel < requiredApi) {
                    String msg = String.format("ERROR: Application requires API version %1$d. Device API version is %2$d (Android %3$s).", requiredApi, deviceApiLevel, deviceVersion);
                    AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg});
                    return false;
                }
            } else {
                AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"WARNING: Application does not specify an API level requirement!"});
                if (deviceApiLevel == -1) {
                    AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"WARNING: Unknown device API version!"});
                } else {
                    AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Device API version is %1$d (Android %2$s)", deviceApiLevel, deviceVersion)});
                }
            }
            if (!device.isEmulator() && launchInfo.isDebugMode() && (debuggableDevice = device.getProperty("ro.debuggable")) != null && debuggableDevice.equals("0") && launchInfo.getDebuggable() == Boolean.FALSE) {
                String message = String.format("Application '%1$s' has its 'debuggable' attribute set to FALSE and cannot be debugged.", launchInfo.getPackageName());
                AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{message});
                launchInfo.setDebugMode(false);
            }
        }
        return true;
    }

    private boolean simpleLaunch(DelayedLaunchInfo launchInfo, IDevice device) {
        if (!this.doPreLaunchActions(launchInfo, device)) {
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch canceled!"});
            this.stopLaunch(launchInfo);
            return false;
        }
        this.launchApp(launchInfo, device);
        return true;
    }

    private boolean doPreLaunchActions(DelayedLaunchInfo launchInfo, IDevice device) {
        if (!this.checkBuildInfo(launchInfo, device)) {
            return false;
        }
        return this.syncApp(launchInfo, device);
    }

    private void multiLaunch(DelayedLaunchInfo launchInfo, Collection<IDevice> devices) {
        for (IDevice d : devices) {
            boolean success = this.doPreLaunchActions(launchInfo, d);
            if (success) continue;
            String deviceName = d.isEmulator() ? d.getAvdName() : d.getSerialNumber();
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch failed on device: " + deviceName});
        }
        this.doLaunchAction(launchInfo, devices);
        this.stopLaunch(launchInfo);
    }

    private boolean syncApp(DelayedLaunchInfo launchInfo, IDevice device) {
        boolean alreadyInstalled = ApkInstallManager.getInstance().isApplicationInstalled(launchInfo.getProject(), launchInfo.getPackageName(), device);
        if (alreadyInstalled) {
            AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), "Application already deployed. No need to reinstall.");
        } else if (!this.doSyncApp(launchInfo, device)) {
            return false;
        }
        for (DelayedLaunchInfo dependentLaunchInfo : this.getDependenciesLaunchInfo(launchInfo)) {
            String msg = String.format("Project dependency found, installing: %s", dependentLaunchInfo.getProject().getName());
            AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), msg);
            if (this.syncApp(dependentLaunchInfo, device)) continue;
            return false;
        }
        return true;
    }

    private boolean doSyncApp(DelayedLaunchInfo launchInfo, IDevice device) {
        IPath path = launchInfo.getPackageFile().getLocation();
        String fileName = path.lastSegment();
        try {
            String message = String.format("Uploading %1$s onto device '%2$s'", fileName, device.getSerialNumber());
            AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), message);
            String remotePackagePath = device.syncPackageToDevice(path.toOSString());
            boolean installResult = this.installPackage(launchInfo, remotePackagePath, device);
            device.removeRemotePackage(remotePackagePath);
            if (installResult) {
                ApkInstallManager.getInstance().registerInstallation(launchInfo.getProject(), launchInfo.getPackageName(), device);
            }
            return installResult;
        }
        catch (IOException e) {
            String msg = String.format("Failed to install %1$s on device '%2$s': %3$s", fileName, device.getSerialNumber(), e.getMessage());
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e});
        }
        catch (TimeoutException timeoutException) {
            String msg = String.format("Failed to install %1$s on device '%2$s': timeout", fileName, device.getSerialNumber());
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg});
        }
        catch (AdbCommandRejectedException e) {
            String msg = String.format("Failed to install %1$s on device '%2$s': adb rejected install command with: %3$s", fileName, device.getSerialNumber(), e.getMessage());
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e});
        }
        catch (CanceledException e) {
            if (e.wasCanceled()) {
                AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), String.format("Install of %1$s canceled", fileName));
            }
            String msg = String.format("Failed to install %1$s on device '%2$s': %3$s", fileName, device.getSerialNumber(), e.getMessage());
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e});
        }
        return false;
    }

    public List<DelayedLaunchInfo> getDependenciesLaunchInfo(DelayedLaunchInfo launchInfo) {
        List<IJavaProject> androidProjectList;
        IJavaProject javaProject;
        ArrayList<DelayedLaunchInfo> dependencies = new ArrayList<DelayedLaunchInfo>();
        try {
            javaProject = BaseProjectHelper.getJavaProject(launchInfo.getProject());
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{e});
            return dependencies;
        }
        try {
            androidProjectList = ProjectHelper.getAndroidProjectDependencies(javaProject);
        }
        catch (JavaModelException e) {
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{e});
            return dependencies;
        }
        for (IJavaProject androidProject : androidProjectList) {
            IFile apk;
            ManifestData manifestData = AndroidManifestHelper.parseForData(androidProject.getProject());
            if (manifestData == null || (apk = ProjectHelper.getApplicationPackage(androidProject.getProject())) == null) continue;
            DelayedLaunchInfo delayedLaunchInfo = new DelayedLaunchInfo(androidProject.getProject(), manifestData.getPackage(), manifestData.getPackage(), launchInfo.getLaunchAction(), apk, manifestData.getDebuggable(), manifestData.getMinSdkVersionString(), launchInfo.getLaunch(), launchInfo.getMonitor());
            dependencies.add(delayedLaunchInfo);
        }
        return dependencies;
    }

    private boolean installPackage(DelayedLaunchInfo launchInfo, String remotePath, IDevice device) {
        String message = String.format("Installing %1$s...", launchInfo.getPackageFile().getName());
        AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), message);
        try {
            String result = this.doInstall(launchInfo, remotePath, device, true);
            return this.checkInstallResult(result, device, launchInfo, remotePath, DelayedLaunchInfo.InstallRetryMode.ALWAYS);
        }
        catch (Exception e) {
            String msg = String.format("Failed to install %1$s on device '%2$s!", launchInfo.getPackageFile().getName(), device.getSerialNumber());
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg, e.getMessage()});
            return false;
        }
    }

    private boolean checkInstallResult(String result, IDevice device, DelayedLaunchInfo launchInfo, String remotePath, DelayedLaunchInfo.InstallRetryMode retryMode) throws InstallException {
        if (result == null) {
            AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), "Success!");
            return true;
        }
        if (result.equals("INSTALL_FAILED_ALREADY_EXISTS")) {
            if (retryMode == DelayedLaunchInfo.InstallRetryMode.PROMPT) {
                boolean prompt = AndmoreAndroidPlugin.displayPrompt("Application Install", "A previous installation needs to be uninstalled before the new package can be installed.\nDo you want to uninstall?");
                if (prompt) {
                    retryMode = DelayedLaunchInfo.InstallRetryMode.ALWAYS;
                } else {
                    AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation error! The package already exists."});
                    return false;
                }
            }
            if (retryMode == DelayedLaunchInfo.InstallRetryMode.ALWAYS) {
                AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), "Application already exists. Attempting to re-install instead...");
                String res = this.doInstall(launchInfo, remotePath, device, true);
                return this.checkInstallResult(res, device, launchInfo, remotePath, DelayedLaunchInfo.InstallRetryMode.NEVER);
            }
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation error! The package already exists."});
        } else if (result.equals("INSTALL_FAILED_INVALID_APK")) {
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation failed due to invalid APK file!", "Please check logcat output for more details."});
        } else if (result.equals("INSTALL_FAILED_INVALID_URI")) {
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Installation failed due to invalid URI!", "Please check logcat output for more details."});
        } else if (result.equals("INSTALL_FAILED_COULDNT_COPY")) {
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Installation failed: Could not copy %1$s to its final location!", launchInfo.getPackageFile().getName()), "Please check logcat output for more details."});
        } else if (result.equals("INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES")) {
            boolean prompt;
            if (retryMode != DelayedLaunchInfo.InstallRetryMode.NEVER && (prompt = AndmoreAndroidPlugin.displayPrompt("Application Install", "Re-installation failed due to different application signatures. You must perform a full uninstall of the application. WARNING: This will remove the application data!\nDo you want to uninstall?"))) {
                this.doUninstall(device, launchInfo);
                String res = this.doInstall(launchInfo, remotePath, device, false);
                return this.checkInstallResult(res, device, launchInfo, remotePath, DelayedLaunchInfo.InstallRetryMode.NEVER);
            }
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Re-installation failed due to different application signatures.", "You must perform a full uninstall of the application. WARNING: This will remove the application data!", String.format("Please execute 'adb uninstall %1$s' in a shell.", launchInfo.getPackageName())});
        } else {
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Installation error: %1$s", result), "Please check logcat output for more details."});
        }
        return false;
    }

    private String doUninstall(IDevice device, DelayedLaunchInfo launchInfo) throws InstallException {
        try {
            return device.uninstallPackage(launchInfo.getPackageName());
        }
        catch (InstallException e) {
            String msg = String.format("Failed to uninstall %1$s: %2$s", launchInfo.getPackageName(), e.getMessage());
            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{msg});
            throw e;
        }
    }

    private String doInstall(DelayedLaunchInfo launchInfo, String remotePath, IDevice device, boolean reinstall) throws InstallException {
        return device.installRemotePackage(remotePath, reinstall, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchApp(DelayedLaunchInfo info, IDevice device) {
        if (info.isDebugMode()) {
            Object object = sListLock;
            synchronized (object) {
                if (!this.mWaitingForDebuggerApplications.contains(info)) {
                    this.mWaitingForDebuggerApplications.add(info);
                }
            }
        }
        if (this.doLaunchAction(info, device)) {
            if (!info.isDebugMode()) {
                this.stopLaunch(info);
            }
        } else {
            this.stopLaunch(info);
        }
    }

    private boolean doLaunchAction(DelayedLaunchInfo info, Collection<IDevice> devices) {
        boolean result = info.getLaunchAction().doLaunchAction(info, devices);
        for (IDevice d : devices) {
            DdmsPlugin.getDefault().startLogCatMonitor(d);
        }
        return result;
    }

    private boolean doLaunchAction(DelayedLaunchInfo info, IDevice device) {
        return this.doLaunchAction(info, Collections.singletonList(device));
    }

    private boolean launchEmulator(AndroidLaunchConfiguration config, AvdInfo avdToLaunch) {
        boolean needsWipeData;
        ArrayList<String> customArgs = new ArrayList<String>();
        boolean hasWipeData = false;
        if (config.mEmulatorCommandLine != null && config.mEmulatorCommandLine.length() > 0) {
            String[] segments;
            String[] stringArray = segments = config.mEmulatorCommandLine.split("\\s+");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() > 0) {
                    customArgs.add(s);
                    if (!hasWipeData && s.equals(FLAG_WIPE_DATA)) {
                        hasWipeData = true;
                    }
                }
                ++n2;
            }
        }
        boolean bl = needsWipeData = config.mWipeData && !hasWipeData;
        if (needsWipeData && !AndmoreAndroidPlugin.displayPrompt("Android Launch", "Are you sure you want to wipe all user data when starting this emulator?")) {
            needsWipeData = false;
        }
        ArrayList<String> list = new ArrayList<String>();
        String path = AndmoreAndroidPlugin.getOsAbsoluteEmulator();
        list.add(path);
        list.add(FLAG_AVD);
        list.add(avdToLaunch.getName());
        if (config.mNetworkSpeed != null) {
            list.add(FLAG_NETSPEED);
            list.add(config.mNetworkSpeed);
        }
        if (config.mNetworkDelay != null) {
            list.add(FLAG_NETDELAY);
            list.add(config.mNetworkDelay);
        }
        if (needsWipeData) {
            list.add(FLAG_WIPE_DATA);
        }
        if (config.mNoBootAnim) {
            list.add(FLAG_NO_BOOT_ANIM);
        }
        list.addAll(customArgs);
        String[] command = list.toArray(new String[list.size()]);
        try {
            Process process = Runtime.getRuntime().exec(command);
            this.grabEmulatorOutput(process);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static ILaunchConfiguration findConfig(ILaunchManager manager, ILaunchConfigurationType type, String projectName) {
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(type);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                    return config;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)AndmoreAndroidPlugin.getShell(), (String)"Launch Error", (String)e.getStatus().getMessage());
        }
        return null;
    }

    public static boolean connectRemoteDebugger(int debugPort, AndroidLaunch launch, IProgressMonitor monitor) throws CoreException {
        int connectTimeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("hostname", "localhost");
        newMap.put("port", Integer.toString(debugPort));
        newMap.put("timeout", Integer.toString(connectTimeout));
        IVMConnector connector = JavaRuntime.getDefaultVMConnector();
        connector.connect(newMap, monitor, (ILaunch)launch);
        if (monitor.isCanceled()) {
            IDebugTarget[] debugTargets;
            IDebugTarget[] iDebugTargetArray = debugTargets = launch.getDebugTargets();
            int n = debugTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if (target.canDisconnect()) {
                    target.disconnect();
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public static void launchRemoteDebugger(final int debugPort, final AndroidLaunch androidLaunch, final IProgressMonitor monitor) {
        new Thread("Debugger connection"){

            @Override
            public void run() {
                try {
                    AndroidLaunchController.connectRemoteDebugger(debugPort, androidLaunch, monitor);
                }
                catch (CoreException coreException) {
                    androidLaunch.stopLaunch();
                }
                monitor.done();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bridgeChanged(AndroidDebugBridge bridge) {
        String message = "adb server change: cancelling '%1$s'!";
        Object object = sListLock;
        synchronized (object) {
            for (DelayedLaunchInfo launchInfo : this.mWaitingForReadyEmulatorList) {
                AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
            for (DelayedLaunchInfo launchInfo : this.mWaitingForDebuggerApplications) {
                AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
            this.mWaitingForReadyEmulatorList.clear();
            this.mWaitingForDebuggerApplications.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceConnected(IDevice device) {
        Object object = sListLock;
        synchronized (object) {
            if (this.mWaitingForEmulatorLaunches.size() > 0) {
                DelayedLaunchInfo launchInfo = this.mWaitingForEmulatorLaunches.get(0);
                this.mWaitingForEmulatorLaunches.remove(0);
                launchInfo.setDevice(device);
                this.mWaitingForReadyEmulatorList.add(launchInfo);
                AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), String.format("New emulator found: %1$s", device.getSerialNumber()));
                AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), String.format("Waiting for HOME ('%1$s') to be launched...", AndmoreAndroidPlugin.getDefault().getPreferenceStore().getString("org.eclipse.andmore.homePackage")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnected(IDevice device) {
        String message = "%1$s disconnected! Cancelling '%2$s'!";
        Object object = sListLock;
        synchronized (object) {
            ArrayList copyList = (ArrayList)this.mWaitingForReadyEmulatorList.clone();
            for (DelayedLaunchInfo launchInfo : copyList) {
                if (launchInfo.getDevice() != device) continue;
                AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, device.getSerialNumber(), launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
            copyList = (ArrayList)this.mWaitingForDebuggerApplications.clone();
            for (DelayedLaunchInfo launchInfo : copyList) {
                if (launchInfo.getDevice() != device) continue;
                AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format(message, device.getSerialNumber(), launchInfo.getLaunchAction().getLaunchDescription())});
                this.stopLaunch(launchInfo);
            }
        }
    }

    public void deviceChanged(IDevice device, int changeMask) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientChanged(final Client client, int changeMask) {
        Object applicationName;
        Object home;
        String applicationName2;
        boolean connectDebugger = false;
        if ((changeMask & 1) == 1 && (applicationName2 = client.getClientData().getClientDescription()) != null) {
            Object device;
            IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
            home = store.getString("org.eclipse.andmore.homePackage");
            if (((String)home).equals(applicationName2)) {
                device = client.getDevice();
                Object object = sListLock;
                synchronized (object) {
                    int i = 0;
                    while (i < this.mWaitingForReadyEmulatorList.size()) {
                        DelayedLaunchInfo launchInfo = this.mWaitingForReadyEmulatorList.get(i);
                        if (launchInfo.getDevice() == device) {
                            this.mWaitingForReadyEmulatorList.remove(i);
                            if (!this.checkBuildInfo(launchInfo, (IDevice)device)) {
                                AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch canceled!"});
                                this.stopLaunch(launchInfo);
                                return;
                            }
                            AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), String.format("HOME is up on device '%1$s'", device.getSerialNumber()));
                            if (this.syncApp(launchInfo, (IDevice)device)) {
                                this.launchApp(launchInfo, (IDevice)device);
                                break;
                            }
                            AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{"Launch canceled!"});
                            this.stopLaunch(launchInfo);
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (client.getClientData().getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING) {
                device = sListLock;
                synchronized (device) {
                    int index = this.mUnknownClientsWaitingForDebugger.indexOf(client);
                    if (index != -1) {
                        connectDebugger = true;
                        this.mUnknownClientsWaitingForDebugger.remove(client);
                    }
                }
            }
        }
        if ((changeMask & 2) == 2) {
            ClientData clientData = client.getClientData();
            applicationName = client.getClientData().getClientDescription();
            if (clientData.getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING) {
                if (applicationName == null) {
                    home = sListLock;
                    synchronized (home) {
                        this.mUnknownClientsWaitingForDebugger.add(client);
                    }
                    return;
                }
                connectDebugger = true;
            }
        }
        if (connectDebugger) {
            Log.d((String)"adt", (String)("Debugging " + client));
            applicationName2 = client.getClientData().getClientDescription();
            Log.d((String)"adt", (String)("App Name: " + applicationName2));
            applicationName = sListLock;
            synchronized (applicationName) {
                int i = 0;
                while (i < this.mWaitingForDebuggerApplications.size()) {
                    final DelayedLaunchInfo launchInfo = this.mWaitingForDebuggerApplications.get(i);
                    if (client.getDevice() == launchInfo.getDevice() && applicationName2.equals(launchInfo.getDebugPackageName())) {
                        this.mWaitingForDebuggerApplications.remove(i);
                        String msg = String.format("Attempting to connect debugger to '%1$s' on port %2$d", launchInfo.getDebugPackageName(), client.getDebuggerListenPort());
                        AndmoreAndroidPlugin.printToConsole(launchInfo.getProject(), msg);
                        new Thread("Debugger Connection"){

                            @Override
                            public void run() {
                                try {
                                    if (!AndroidLaunchController.connectRemoteDebugger(client.getDebuggerListenPort(), launchInfo.getLaunch(), launchInfo.getMonitor())) {
                                        return;
                                    }
                                }
                                catch (CoreException e) {
                                    AndmoreAndroidPlugin.printErrorToConsole(launchInfo.getProject(), new Object[]{String.format("Launch error: %s", e.getMessage())});
                                    AndroidLaunchController.this.stopLaunch(launchInfo);
                                }
                                launchInfo.getMonitor().done();
                            }
                        }.start();
                        return;
                    }
                    ++i;
                }
            }
            IProject project = ProjectHelper.findAndroidProjectByAppName(applicationName2);
            if (project != null) {
                AndroidLaunchController.debugRunningApp(project, client.getDebuggerListenPort());
            }
        }
    }

    private void grabEmulatorOutput(final Process process) {
        new Thread(""){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        AndmoreAndroidPlugin.printErrorToConsole("Emulator", line);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
        new Thread(""){

            @Override
            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        AndmoreAndroidPlugin.printToConsole("Emulator", line);
                    }
                }
                catch (IOException iOException) {}
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLaunch(DelayedLaunchInfo launchInfo) {
        launchInfo.getLaunch().stopLaunch();
        Object object = sListLock;
        synchronized (object) {
            this.mWaitingForReadyEmulatorList.remove(launchInfo);
            this.mWaitingForDebuggerApplications.remove(launchInfo);
        }
    }

    public static void updateLaunchConfigWithLastUsedDevice(ILaunchConfiguration launchConfiguration, DeviceChooserDialog.DeviceChooserResponse response) {
        try {
            String selected;
            boolean configModified = false;
            boolean reuse = launchConfiguration.getAttribute("org.eclipse.andmore.reuse.last.used.device", false);
            String serial = launchConfiguration.getAttribute("org.eclipse.andmore.last.used.device", null);
            ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
            if (reuse != response.useDeviceForFutureLaunches()) {
                reuse = response.useDeviceForFutureLaunches();
                wc.setAttribute("org.eclipse.andmore.reuse.last.used.device", reuse);
                configModified = true;
            }
            if (reuse && (selected = AndroidLaunchController.getSerial(response)) != null && !selected.equalsIgnoreCase(serial)) {
                wc.setAttribute("org.eclipse.andmore.last.used.device", selected);
                configModified = true;
            }
            if (configModified) {
                wc.doSave();
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private static String getSerial(DeviceChooserDialog.DeviceChooserResponse response) {
        AvdInfo avd = response.getAvdToLaunch();
        return avd != null ? avd.getName() : response.getDeviceToUse().getSerialNumber();
    }

    public static IDevice getDeviceIfOnline(String serial, IDevice[] onlineDevices) {
        if (serial == null) {
            return null;
        }
        IDevice[] iDeviceArray = onlineDevices;
        int n = onlineDevices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (serial.equals(device.getAvdName()) || serial.equals(device.getSerialNumber())) {
                return device;
            }
            ++n2;
        }
        return null;
    }
}

